/* atmarpd.c - ATMARP demon */
 
/* Written 1995 by Werner Almesberger, EPFL-LRC */
 

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <linux/atmarp.h>

#include "atmd.h"

#include "io.h"
#include "table.h"


#ifndef NULL
#define NULL ((void *) 0)
#endif


#define COMPONENT "ARPD"


ITF *itfs = NULL;
VCC *pending = NULL;
int debug;


static void usage(const char *name)
{
    fprintf(stderr,"usage: %s [ -b ] [ -d ]\n",name);
    exit(1);
}


int main(int argc,char **argv)
{
    int c,background;

    set_verbosity(NULL,DIAG_INFO);
    background = 0;
    while ((c = getopt(argc,argv,"bdnp")) != EOF)
	switch (c) {
	    case 'b':
		background = 1;
		break;
	    case 'd':
		set_verbosity(NULL,DIAG_DEBUG);
		debug = 1;
		break;
	    case 'n':
		/* will enable NSAP matching @@@ */
	    case 'p':
		/* paranoid anti-firewall-tunneling mode @@@ */
	    default:
		usage(argv[0]);
	}
    diag(COMPONENT,DIAG_INFO,"Linux ATM ARP, version " VERSION);
    open_all();
    if (background) {
    	pid_t pid;
 
	pid = fork();
	if (pid < 0) diag(COMPONENT,DIAG_FATAL,"fork: %s",strerror(errno));
	if (pid) {
	    diag(COMPONENT,DIAG_DEBUG,"Backgrounding (PID %d)",pid);
	    exit(0);
	}
    }
    poll_loop();
    close_all();
    return 0;
}
