/* bw.c - block write */

/* Written 1995 by Werner Almesberger, EPFL-LRC */


#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <linux/atm.h>


#define BSIZE 8192


int main(int argc,char **argv)
{
    struct sockaddr_atmpvc addr;
    char buffer[BSIZE];
    int blocks,s;
    size_t size;

    if (argc != 4 && argc != 5) {
	fprintf(stderr,"usage: %s itf vpi vci [ blocks ]\n",argv[0]);
	return 1;
    }
    if (argc == 4) blocks = 0;
    else blocks = atoi(argv[4]);
    if ((s = socket(PF_ATMPVC,SOCK_DGRAM,ATM_AAL5)) < 0) {
	perror("socket");
	return 1;
    }
    memset(&addr,0,sizeof(addr));
    addr.sap_family = AF_ATMPVC;
    addr.sap_addr.itf = atoi(argv[1]);
    addr.sap_addr.vpi = atoi(argv[2]);
    addr.sap_addr.vci = atoi(argv[3]);
    addr.sap_txtp.class = ATM_UBR;
    if (connect(s,(struct sockaddr *) &addr,sizeof(addr)) < 0) {
	perror("bind");
	return 1;
    }
    if (blocks)
	while (blocks--) (void) write(s,buffer,BSIZE);
    else while ((size = read(0,buffer,BSIZE)) > 0)
	    (void) write(s,buffer,size);
    return 0;
}
