/* atmarp.c - RFC1577 ATMARP control */
 
/* Written 1995 by Werner Almesberger, EPFL-LRC */


#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <net/if.h> /* struct ifreq */

#include <linux/atm.h>
#include <linux/atmarp.h>
#include <linux/atmclip.h>
#include <linux/if_arp.h> /* for ATF_PERM */

#include "atm.h"


static void usage(const char *name)
{
    fprintf(stderr,"usage: %s -c atmN\n",name);
    fprintf(stderr,"%6s %s -s ip_addr itf.vpi.vci [perm] [null]\n","",name);
    fprintf(stderr,"%6s %s -s ip_addr atm_addr [perm] [arpsrv]\n","",name);
    fprintf(stderr,"%6s %s -d ip_addr\n","",name);
    exit(1);
}


int main(int argc,char **argv)
{
    struct hostent *hostent;
    struct atmarpreq req;
    int c,op,s,i,num;
    char *here,*end;

    op = 0;
    while ((c = getopt(argc,argv,"cds")) != EOF)
	switch (c) {
	    case 'c':
		if (op) usage(argv[0]);
		op = SIOCMKCLIP;
		break;
	    case 's':
		if (op) usage(argv[0]);
		op = SIOCSARP;
		break;
	    case 'd':
		if (op) usage(argv[0]);
		op = SIOCDARP;
		break;
	    default:
		usage(argv[0]);
	}
    switch (op) {
	case SIOCMKCLIP:
	    if (argc != optind+1) usage(argv[0]);
	    if ((s = socket(PF_ATMSVC,SOCK_DGRAM,0)) < 0) {
		perror("socket");
		return 1;
	    }
	    here = argv[optind];
	    if (strlen(here) > 3 && !strncmp(here,"atm",3)) here += 3;
#if 1
	    else usage(argv[0]);
#endif
	    num = strtoul(here,&end,10);
	    if (*end || (here[0] == '0' && here[1])) {
		usage(argv[0]);
		return 1;
	    }
	    if (ioctl(s,op,num) < 0) {
		perror("ioctl");
		return 1;
	    }
	    return 0;
	case SIOCSARP:
	    if (argc < optind+2) usage(argv[0]);
	    break;
	case SIOCDARP:
	    if (argc != optind+1) usage(argv[0]);
	    break;
	default:
	    usage(argv[0]);
    }
    ((struct sockaddr_in *) &req.arp_pa)->sin_family = AF_INET;
    if (strspn(argv[optind],"0123456789.") == strlen(argv[optind])) {
	if ((((struct sockaddr_in *) &req.arp_pa)->sin_addr.s_addr =
	  inet_addr(argv[optind])) == -1) {
	    fprintf(stderr,"%s: invalid address\n",argv[optind]);
	    return 1;
	}
    }
    else {
	if (!(hostent = gethostbyname(argv[optind]))) {
	    fprintf(stderr,"%s: no such host\n",argv[optind]);
	    return 1;
	}
	if (hostent->h_addrtype != AF_INET) {
	    fprintf(stderr,"%s: unknown protocol family\n",argv[0]);
	    return 1;
	}
	memcpy(&((struct sockaddr_in *) &req.arp_pa)->sin_addr,hostent->h_addr,
	  hostent->h_length);
    }
    if (op == SIOCSARP) {
	req.arp_flags = 0;
	for (i = optind+2; i < argc; i++)
		if (!strcmp(argv[i],"perm")) req.arp_flags |= ATF_PERM;
		else if (!strcmp(argv[i],"null")) req.arp_flags |= ATF_NULL;
		else if (!strcmp(argv[i],"arpsrv")) req.arp_flags |= ATF_ARPSRV;
		else usage(argv[0]);
	if (text2atm(argv[optind+1],(struct sockaddr *) &req.arp_ha,
	  sizeof(req.arp_ha),T2A_NAME) < 0) {
	    fprintf(stderr,"%s: invalid ATM address\n",argv[i]);
	    return 1;
	}
	if (((struct sockaddr *) &req.arp_ha)->sa_family == AF_ATMPVC) {
	    ((struct sockaddr_atmpvc *) &req.arp_ha)->sap_txtp.class = ATM_UBR;
	    ((struct sockaddr_atmpvc *) &req.arp_ha)->sap_txtp.max_sdu =
	      RFC1483LLC_LEN+RFC1626_MTU;
	    ((struct sockaddr_atmpvc *) &req.arp_ha)->sap_rxtp =
	      ((struct sockaddr_atmpvc *) &req.arp_ha)->sap_txtp;
	}
	else {
	    req.arp_ha.sas_txtp.class = ATM_UBR;
	    req.arp_ha.sas_txtp.max_sdu = RFC1483LLC_LEN+RFC1626_MTU;
	    req.arp_ha.sas_rxtp = req.arp_ha.sas_txtp;
	/* @@@ special treatment for SVCs ... */
	}
    }
    if ((s = socket(AF_INET,SOCK_DGRAM,0)) < 0) {
	perror("socket");
	return 1;
    }
    if (ioctl(s,op,&req) < 0) {
	perror("ioctl");
	return 1;
    }
    return 0;
}
