%{
/* cfg.l - configuration language */
 
/* Written 1995 by Werner Almesberger, EPFL-LRC */


#include <stdlib.h>
#include <stdio.h>
#include <linux/atm.h>

#include "y.tab.h"


static int lineno = 1;


void yyerror(const char *s);

%}

%%

level			return TOK_LEVEL;
debug			|
debugging		return TOK_DEBUG;
info			|
information		|
informational		return TOK_INFO;
warn			|
warning			return TOK_WARN;
error			return TOK_ERROR;
fatal			return TOK_FATAL;
sig			|
signaling		|
signalling		return TOK_SIG;
uni30			return TOK_UNI30;
uni31			return TOK_UNI31;
net			|
network			return TOK_NET;
saal			return TOK_SAAL;
vpi			return TOK_VPI;
vci			return TOK_VCI;
nsap			return TOK_NSAP;
io			return TOK_IO;
[0-9]+			{ char *end;
			  yylval.num = strtoul(yytext,&end,10);
			  if (*end) yyerror("invalid number");
			  return TOK_NUMBER; }
[-0-9a-fA-F]+		{ const char *get;
			  char *put;
			  put = yylval.nsap;
			  for (get = yytext; *get; get++)
			      if (*get != '-')
				  if (put < yylval.nsap+40) *put++ = *get;
				  else yyerror("NSAP address/prefix is too "
					"long");
			  *put = 0;
			  return TOK_ADDR; }
\n?[\t ]*		lineno += *yytext && *yytext == '\n';
#[^\n]*\n		lineno++;
.			return *yytext;

%%

void yyerror(const char *s)
{
    fprintf(stderr,"line %d: %s near \"%s\"\n",lineno,s,yytext);
    exit(1);
}
