/* sig.c - signaling entity handling */

/* Written 1998 by Werner Almesberger, EPFL ICA */


#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <stdint.h>
#include <linux/atmsvc.h>

#include "atmd.h"

#include "dispatch.h"
#include "proto.h"
#include "sig.h"


#define COMPONENT "SIG"


static int sig_check_listen(SIGNALING_ENTITY *sig,struct atmsvc_msg *msg)
{
    return msg->type == as_okay ? 0 : msg->reply;
}


static int sig_recv(SIGNALING_ENTITY *sig,
  int (*handler)(SIGNALING_ENTITY *sig,struct atmsvc_msg *msg))
{
    char buf[sizeof(struct atmsvc_msg)+1];
    int len;

    len = read(sig->s,buf,sizeof(buf));
    if (len == sizeof(struct atmsvc_msg))
	return handler(sig,(struct atmsvc_msg *) buf);
    if (len < 0) 
	diag(COMPONENT,DIAG_ERROR,"read isp msg: %s",strerror(errno));
    else diag(COMPONENT,DIAG_ERROR,"bad isp msg: %d != %d",len,
	  sizeof(struct atmsvc_msg));
    return -1;
}


static void sig_data(int fd,void *sig)
{
    (void) sig_recv(sig,from_sigd);
}


SIGNALING_ENTITY *sig_vc(const char *path,int itf)
{
    SIGNALING_ENTITY *sig;
    int error;

    sig = alloc_t(SIGNALING_ENTITY);
    sig->s = un_attach(path);
    if (sig->s < 0)
	diag(COMPONENT,DIAG_FATAL,"un_attach %s: %s",path,strerror(errno));
    sig->itf = itf;
    send_listen(sig);
    error = sig_recv(sig,sig_check_listen);
    if (!error) dsp_fd_add(sig->s,sig_data,sig);
    else diag(COMPONENT,DIAG_FATAL,"listen failed: %s",strerror(error));
    return sig;
}


void sig_send(SIGNALING_ENTITY *sig,struct atmsvc_msg *msg)
{
    int len;

    len = write(sig->s,msg,sizeof(*msg));
    if (len == sizeof(*msg)) return;
    if (len < 0) diag(COMPONENT,DIAG_ERROR,"write isp msg: %s",strerror(errno));
    else diag(COMPONENT,DIAG_ERROR,"bad isp msg write: %d != %d",len,
	  sizeof(*msg));
}
