/* io.h - I/O operations */
 
/* Written 1995-1998 by Werner Almesberger, EPFL-LRC/ICA */
 

#ifndef IO_H
#define IO_H

#include <linux/atm.h>
#include <linux/atmsvc.h>


#define MAX_ADDRS 128


typedef struct {
    enum { ls_unused,ls_added,ls_removed,ls_same } state;
    int itf;
    struct sockaddr_atmsvc addr;
} LOCAL_ADDR;


extern LOCAL_ADDR local_addr[];
extern struct sockaddr_atmpvc signaling_pvc;


int open_all(void);
void open_unix(const char *name);
void init_current_time(void);
void poll_loop(void);
void close_all(void);

void to_kernel(struct atmsvc_msg *msg);
void to_net(void *msg,int size);

int get_addr(int itf);

int get_pvc(int itf,int *vci);

#endif
