%{
/* isp.l - Internal Signaling Protocol test generator language */

/* Written 1997 by Werner Almesberger, EPFL-ICA */


#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <linux/atmsvc.h>
#include "y.tab.h"


static int lineno = 1;

void yyerror(const char *s);

%}

%%

send			return TOK_SEND;
wait			return TOK_WAIT;
vcc			return TOK_VCC;
listen			return TOK_LISTEN;
reply			return TOK_REPLY;
pvc			return TOK_PVC;
local			return TOK_LOCAL;
qos			return TOK_QOS;
svc			return TOK_SVC;
sap			return TOK_SAP;
bind			return TOK_BIND;
connect			return TOK_CONNECT;
accept			return TOK_ACCEPT;
reject			return TOK_REJECT;
okay			return TOK_OKAY;
error			return TOK_ERROR;
indicate		return TOK_INDICATE;
close			return TOK_CLOSE;
itf_notify		return TOK_ITF_NOTIFY;
modify			return TOK_MODIFY;
identify		return TOK_IDENTIFY;
=[ \t]*[^ \t\n]*	{
			    const char *start;

			    for (start = yytext+1; strchr(" \t\n",*start);
			      start++);
			    yylval.str = strdup(start);
			    if (!yylval.str) {
				perror("strdup");
				exit(1);
			    }
			    return TOK_VALUE;
			}
\n?[\t ]*		{
			    if (*yytext == '\n') {
				lineno++;
				return TOK_EOL;
			    }
			}
\\[\t ]*\n		lineno++;
#[^\n]*\n		lineno++;
.			return *yytext;

%%

void yyerror(const char *s)
{
    fprintf(stderr,"line %d: %s near \"%s\"\n",lineno,s,yytext);
    exit(1);
}
