/*
 *    rfc1155_smi.c
 *
 *    "RFC1155-SMI" ASN.1 module encode/decode/print/free C src.
 *
 *    This file was generated by snacc on Fri Jan 31 14:49:02 1997
 *
 *    UBC snacc written by Mike Sample
 *
 *    NOTE: This is a machine generated file - editing not recommended
 */



#include "asn_incl.h"
#include "rfc1155_smi.h"
#include "rfc1157_snmp.h"


AsnOid internet = { 3, "\53\6\1" };

AsnOid directory = { 4, "\53\6\1\1" };

AsnOid mgmt = { 4, "\53\6\1\2" };

AsnOid experimental = { 4, "\53\6\1\3" };

AsnOid private = { 4, "\53\6\1\4" };

AsnOid enterprises = { 5, "\53\6\1\4\1" };

AsnLen
BEncSimpleSyntaxContent PARAMS((b, v),
BUF_TYPE b _AND_
SimpleSyntax* v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void* component;

    switch(v->choiceId)
    {
       case(SIMPLESYNTAX_NUMBER):
    itemLen = BEncAsnIntContent( b, (&v->a.number));
    BEncDefLenTo127( b, itemLen);
    itemLen++;
    itemLen += BEncTag1(b, UNIV, PRIM, 2);

    totalLen += itemLen;

    break;

       case(SIMPLESYNTAX_STRING):
    itemLen = BEncAsnOctsContent( b, (v->a.string));
    itemLen += BEncDefLen( b, itemLen);
    itemLen += BEncTag1(b, UNIV, PRIM, 4);

    totalLen += itemLen;

    break;

       case(SIMPLESYNTAX_OBJECT):
    itemLen = BEncAsnOidContent( b, (v->a.object));
    itemLen += BEncDefLen( b, itemLen);
    itemLen += BEncTag1(b, UNIV, PRIM, 6);

    totalLen += itemLen;

    break;

       case(SIMPLESYNTAX_EMPTY):
    itemLen = BEncAsnNullContent( b, (&v->a.empty));
    BEncDefLenTo127( b, itemLen);
    itemLen++;
    itemLen += BEncTag1(b, UNIV, PRIM, 5);

    totalLen += itemLen;

    break;

    }
    return (totalLen);

}  /* BEncSimpleSyntaxContent */

void
BDecSimpleSyntaxContent PARAMS((b, tagId0, elmtLen0, v, bytesDecoded, env),
BUF_TYPE b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
SimpleSyntax* v _AND_
AsnLen* bytesDecoded _AND_
ENV_TYPE env)
{
    int seqDone = FALSE;
    AsnLen totalElmtsLen1 = 0;
    AsnLen elmtLen1;
    AsnTag tagId1;
    int mandatoryElmtCount1 = 0;


    switch(tagId0)
    {
       case(MAKE_TAG_ID( UNIV, PRIM, INTEGER_TAG_CODE)):
        (v->choiceId) = SIMPLESYNTAX_NUMBER;
    BDecAsnIntContent( b, tagId0, elmtLen0, (&v->a.number), &totalElmtsLen1, env);
    break;

       case(MAKE_TAG_ID( UNIV, PRIM, OCTETSTRING_TAG_CODE)):
       case(MAKE_TAG_ID( UNIV, CONS, OCTETSTRING_TAG_CODE)):
        (v->choiceId) = SIMPLESYNTAX_STRING;
    (v->a.string) = (AsnOcts*) Asn1Alloc(sizeof(AsnOcts));
    CheckAsn1Alloc((v->a.string), env);
    BDecAsnOctsContent( b, tagId0, elmtLen0, (v->a.string), &totalElmtsLen1, env);
    break;

       case(MAKE_TAG_ID( UNIV, PRIM, OID_TAG_CODE)):
        (v->choiceId) = SIMPLESYNTAX_OBJECT;
    (v->a.object) = (AsnOid*) Asn1Alloc(sizeof(AsnOid));
    CheckAsn1Alloc((v->a.object), env);
    BDecAsnOidContent( b, tagId0, elmtLen0, (v->a.object), &totalElmtsLen1, env);
    break;

       case(MAKE_TAG_ID( UNIV, PRIM, NULLTYPE_TAG_CODE)):
        (v->choiceId) = SIMPLESYNTAX_EMPTY;
    BDecAsnNullContent( b, tagId0, elmtLen0, (&v->a.empty), &totalElmtsLen1, env);
    break;

    default:
        Asn1Error("ERROR - unexpected tag in CHOICE\n");
        longjmp(env, -100);
        break;
    } /* end switch */
    (*bytesDecoded) += totalElmtsLen1;
}  /* BDecSimpleSyntaxContent */

void
PrintSimpleSyntax PARAMS((f, v, indent),
FILE* f _AND_
SimpleSyntax* v _AND_
unsigned short int indent)
{
    switch(v->choiceId)
    {
      case(SIMPLESYNTAX_NUMBER):
          fprintf(f,"number ");
    PrintAsnInt(f, (&v->a.number), indent + stdIndentG);
          break;

      case(SIMPLESYNTAX_STRING):
          fprintf(f,"string ");
    PrintAsnOcts(f, (v->a.string), indent + stdIndentG);
          break;

      case(SIMPLESYNTAX_OBJECT):
          fprintf(f,"object ");
    PrintAsnOid(f, (v->a.object), indent + stdIndentG);
          break;

      case(SIMPLESYNTAX_EMPTY):
          fprintf(f,"empty ");
    PrintAsnNull(f, (&v->a.empty), indent + stdIndentG);
          break;

    }
}  /* PrintSimpleSyntax */




AsnLen
BEncNetworkAddressContent PARAMS((b, v),
BUF_TYPE b _AND_
NetworkAddress* v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void* component;

    switch(v->choiceId)
    {
       case(NETWORKADDRESS_INTERNET):
    itemLen = BEncIpAddressContent( b, (v->a.internet));
    itemLen += BEncDefLen( b, itemLen);
    itemLen += BEncTag1(b, APPL, PRIM, 0);

    totalLen += itemLen;

    break;

    }
    return (totalLen);

}  /* BEncNetworkAddressContent */

void
BDecNetworkAddressContent PARAMS((b, tagId0, elmtLen0, v, bytesDecoded, env),
BUF_TYPE b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
NetworkAddress* v _AND_
AsnLen* bytesDecoded _AND_
ENV_TYPE env)
{
    int seqDone = FALSE;
    AsnLen totalElmtsLen1 = 0;
    AsnLen elmtLen1;
    AsnTag tagId1;
    int mandatoryElmtCount1 = 0;


    switch(tagId0)
    {
       case(MAKE_TAG_ID( APPL, PRIM, 0)):
       case(MAKE_TAG_ID( APPL, CONS, 0)):
        (v->choiceId) = NETWORKADDRESS_INTERNET;
    (v->a.internet) = (IpAddress*) Asn1Alloc(sizeof(IpAddress));
    CheckAsn1Alloc((v->a.internet), env);
    BDecIpAddressContent( b, tagId0, elmtLen0, (v->a.internet), &totalElmtsLen1, env);
    break;

    default:
        Asn1Error("ERROR - unexpected tag in CHOICE\n");
        longjmp(env, -101);
        break;
    } /* end switch */
    (*bytesDecoded) += totalElmtsLen1;
}  /* BDecNetworkAddressContent */

void
PrintNetworkAddress PARAMS((f, v, indent),
FILE* f _AND_
NetworkAddress* v _AND_
unsigned short int indent)
{
    switch(v->choiceId)
    {
      case(NETWORKADDRESS_INTERNET):
          fprintf(f,"internet ");
    PrintIpAddress(f, (v->a.internet), indent + stdIndentG);
          break;

    }
}  /* PrintNetworkAddress */




AsnLen
BEncApplicationSyntaxContent PARAMS((b, v),
BUF_TYPE b _AND_
ApplicationSyntax* v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void* component;

    switch(v->choiceId)
    {
       case(APPLICATIONSYNTAX_ADDRESS):
    itemLen = BEncNetworkAddressContent( b, (v->a.address));

    totalLen += itemLen;

    break;

       case(APPLICATIONSYNTAX_COUNTER):
    itemLen = BEncCounterContent( b, (&v->a.counter));
    BEncDefLenTo127( b, itemLen);
    itemLen++;
    itemLen += BEncTag1(b, APPL, PRIM, 1);

    totalLen += itemLen;

    break;

       case(APPLICATIONSYNTAX_GAUGE):
    itemLen = BEncGaugeContent( b, (&v->a.gauge));
    BEncDefLenTo127( b, itemLen);
    itemLen++;
    itemLen += BEncTag1(b, APPL, PRIM, 2);

    totalLen += itemLen;

    break;

       case(APPLICATIONSYNTAX_TICKS):
    itemLen = BEncTimeTicksContent( b, (&v->a.ticks));
    BEncDefLenTo127( b, itemLen);
    itemLen++;
    itemLen += BEncTag1(b, APPL, PRIM, 3);

    totalLen += itemLen;

    break;

       case(APPLICATIONSYNTAX_ARBITRARY):
    itemLen = BEncOpaqueContent( b, (v->a.arbitrary));
    itemLen += BEncDefLen( b, itemLen);
    itemLen += BEncTag1(b, APPL, PRIM, 4);

    totalLen += itemLen;

    break;

    }
    return (totalLen);

}  /* BEncApplicationSyntaxContent */

void
BDecApplicationSyntaxContent PARAMS((b, tagId0, elmtLen0, v, bytesDecoded, env),
BUF_TYPE b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ApplicationSyntax* v _AND_
AsnLen* bytesDecoded _AND_
ENV_TYPE env)
{
    int seqDone = FALSE;
    AsnLen totalElmtsLen1 = 0;
    AsnLen elmtLen1;
    AsnTag tagId1;
    int mandatoryElmtCount1 = 0;
    AsnLen totalElmtsLen2 = 0;
    AsnLen elmtLen2;
    AsnTag tagId2;


    switch(tagId0)
    {
       case(MAKE_TAG_ID( APPL, PRIM, 0)):
       case(MAKE_TAG_ID( APPL, CONS, 0)):
        (v->choiceId) = APPLICATIONSYNTAX_ADDRESS;
    (v->a.address) = (NetworkAddress*) Asn1Alloc(sizeof(NetworkAddress));
    CheckAsn1Alloc((v->a.address), env);
    BDecNetworkAddressContent( b, tagId0, elmtLen0, (v->a.address), &totalElmtsLen1, env);
    break;

       case(MAKE_TAG_ID( APPL, PRIM, 1)):
        (v->choiceId) = APPLICATIONSYNTAX_COUNTER;
    BDecCounterContent( b, tagId0, elmtLen0, (&v->a.counter), &totalElmtsLen1, env);
    break;

       case(MAKE_TAG_ID( APPL, PRIM, 2)):
        (v->choiceId) = APPLICATIONSYNTAX_GAUGE;
    BDecGaugeContent( b, tagId0, elmtLen0, (&v->a.gauge), &totalElmtsLen1, env);
    break;

       case(MAKE_TAG_ID( APPL, PRIM, 3)):
        (v->choiceId) = APPLICATIONSYNTAX_TICKS;
    BDecTimeTicksContent( b, tagId0, elmtLen0, (&v->a.ticks), &totalElmtsLen1, env);
    break;

       case(MAKE_TAG_ID( APPL, PRIM, 4)):
       case(MAKE_TAG_ID( APPL, CONS, 4)):
        (v->choiceId) = APPLICATIONSYNTAX_ARBITRARY;
    (v->a.arbitrary) = (Opaque*) Asn1Alloc(sizeof(Opaque));
    CheckAsn1Alloc((v->a.arbitrary), env);
    BDecOpaqueContent( b, tagId0, elmtLen0, (v->a.arbitrary), &totalElmtsLen1, env);
    break;

    default:
        Asn1Error("ERROR - unexpected tag in CHOICE\n");
        longjmp(env, -102);
        break;
    } /* end switch */
    (*bytesDecoded) += totalElmtsLen1;
}  /* BDecApplicationSyntaxContent */

void
PrintApplicationSyntax PARAMS((f, v, indent),
FILE* f _AND_
ApplicationSyntax* v _AND_
unsigned short int indent)
{
    switch(v->choiceId)
    {
      case(APPLICATIONSYNTAX_ADDRESS):
          fprintf(f,"address ");
    PrintNetworkAddress(f, (v->a.address), indent + stdIndentG);
          break;

      case(APPLICATIONSYNTAX_COUNTER):
          fprintf(f,"counter ");
    PrintCounter(f, (&v->a.counter), indent + stdIndentG);
          break;

      case(APPLICATIONSYNTAX_GAUGE):
          fprintf(f,"gauge ");
    PrintGauge(f, (&v->a.gauge), indent + stdIndentG);
          break;

      case(APPLICATIONSYNTAX_TICKS):
          fprintf(f,"ticks ");
    PrintTimeTicks(f, (&v->a.ticks), indent + stdIndentG);
          break;

      case(APPLICATIONSYNTAX_ARBITRARY):
          fprintf(f,"arbitrary ");
    PrintOpaque(f, (v->a.arbitrary), indent + stdIndentG);
          break;

    }
}  /* PrintApplicationSyntax */




AsnLen
BEncObjectSyntaxContent PARAMS((b, v),
BUF_TYPE b _AND_
ObjectSyntax* v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void* component;

    switch(v->choiceId)
    {
       case(OBJECTSYNTAX_SIMPLE):
    itemLen = BEncSimpleSyntaxContent( b, (v->a.simple));

    totalLen += itemLen;

    break;

       case(OBJECTSYNTAX_APPLICATION_WIDE):
    itemLen = BEncApplicationSyntaxContent( b, (v->a.application_wide));

    totalLen += itemLen;

    break;

    }
    return (totalLen);

}  /* BEncObjectSyntaxContent */

void
BDecObjectSyntaxContent PARAMS((b, tagId0, elmtLen0, v, bytesDecoded, env),
BUF_TYPE b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
ObjectSyntax* v _AND_
AsnLen* bytesDecoded _AND_
ENV_TYPE env)
{
    int seqDone = FALSE;
    AsnLen totalElmtsLen1 = 0;
    AsnLen elmtLen1;
    AsnTag tagId1;
    int mandatoryElmtCount1 = 0;
    AsnLen totalElmtsLen2 = 0;
    AsnLen elmtLen2;
    AsnTag tagId2;


    switch(tagId0)
    {
       case(MAKE_TAG_ID( UNIV, PRIM, INTEGER_TAG_CODE)):
       case(MAKE_TAG_ID( UNIV, PRIM, OCTETSTRING_TAG_CODE)):
       case(MAKE_TAG_ID( UNIV, CONS, OCTETSTRING_TAG_CODE)):
       case(MAKE_TAG_ID( UNIV, PRIM, OID_TAG_CODE)):
       case(MAKE_TAG_ID( UNIV, PRIM, NULLTYPE_TAG_CODE)):
        (v->choiceId) = OBJECTSYNTAX_SIMPLE;
    (v->a.simple) = (SimpleSyntax*) Asn1Alloc(sizeof(SimpleSyntax));
    CheckAsn1Alloc((v->a.simple), env);
    BDecSimpleSyntaxContent( b, tagId0, elmtLen0, (v->a.simple), &totalElmtsLen1, env);
    break;

       case(MAKE_TAG_ID( APPL, PRIM, 0)):
       case(MAKE_TAG_ID( APPL, CONS, 0)):
       case(MAKE_TAG_ID( APPL, PRIM, 1)):
       case(MAKE_TAG_ID( APPL, PRIM, 2)):
       case(MAKE_TAG_ID( APPL, PRIM, 3)):
       case(MAKE_TAG_ID( APPL, PRIM, 4)):
       case(MAKE_TAG_ID( APPL, CONS, 4)):
        (v->choiceId) = OBJECTSYNTAX_APPLICATION_WIDE;
    (v->a.application_wide) = (ApplicationSyntax*) Asn1Alloc(sizeof(ApplicationSyntax));
    CheckAsn1Alloc((v->a.application_wide), env);
    BDecApplicationSyntaxContent( b, tagId0, elmtLen0, (v->a.application_wide), &totalElmtsLen1, env);
    break;

    default:
        Asn1Error("ERROR - unexpected tag in CHOICE\n");
        longjmp(env, -103);
        break;
    } /* end switch */
    (*bytesDecoded) += totalElmtsLen1;
}  /* BDecObjectSyntaxContent */

void
PrintObjectSyntax PARAMS((f, v, indent),
FILE* f _AND_
ObjectSyntax* v _AND_
unsigned short int indent)
{
    switch(v->choiceId)
    {
      case(OBJECTSYNTAX_SIMPLE):
          fprintf(f,"simple ");
    PrintSimpleSyntax(f, (v->a.simple), indent + stdIndentG);
          break;

      case(OBJECTSYNTAX_APPLICATION_WIDE):
          fprintf(f,"application-wide ");
    PrintApplicationSyntax(f, (v->a.application_wide), indent + stdIndentG);
          break;

    }
}  /* PrintObjectSyntax */




