/*************************************************************************
  (c) Copyright.  Digital Equipment Corporation, 1995.  All Rights
  Reserved.

  Permission is hereby granted to use, copy, modify, or enhance this 
  software freely, as long as the foregoing copyright of Digital Equipment
  Corporation and this notice are retained on the software.  This 
  software may not be distributed or sublicensed for a fee.  Digital      
  makes this software available "AS IS" and without warranties of any
  kind.  
 *************************************************************************/
/*
 * Marko Kiiskila carnil@cs.tut.fi 
 * 
 * Tampere University of Technology - Telecommunications Laboratory
 *
 * Permission to use, copy, modify and distribute this
 * software and its documentation is hereby granted,
 * provided that both the copyright notice and this
 * permission notice appear in all copies of the software,
 * derivative works or modified versions, and any portions
 * thereof, that both notices appear in supporting
 * documentation, and that the use of this software is
 * acknowledged in any publications resulting from using
 * the software.
 * 
 * TUT ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION AND DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS
 * SOFTWARE.
 * 
 */

/*
* Module Name:
*   g_types.h
*   
* Abstract:
*   This module defines basic types that can be shared amongst modules.
*
* Authors:
*   DMW - Douglas M. Washabaugh
*   TLR - Theodore L. Ross
*
* Modification History:
*   Date       Name  Description 
*   08-Aug-94  DMW   Created.
*   06-Oct-94  DMW   Added UINT8.
*   12-Oct-94  DMW   Fixed UINT8, removed BYTE, ULONG, LONG.
*                    Changed BOOLEAN to be unsigned char.
*   05-Dec-94  DMW   Added change to avoid collision with NT and HANDLE.
*   05-Jan-95  DMW   Changed boolean to be 32 bits for NOVELL.
*   09-May-95  TLR   Renamed file and added alpha conditionals.
*
* Description:
*   The types in this module are defined only if previously undefined.  This
*   allows a specific implemenation to override a definition if needed.
*
* Conditional Compilation:
*   - NOVELL
--*/
#ifndef G_TYPES_H
#define G_TYPES_H

/* Define the unsigned data types. */
#ifndef VW_DEFS
#ifndef UINT32 
#ifdef __alpha
typedef unsigned int UINT32;
#else
typedef unsigned long int UINT32;
#endif
#endif

#ifndef UINT16
typedef unsigned short int UINT16;
#endif

#ifndef UINT8
typedef unsigned char UINT8;
#endif

/* Define the signed data types. */

#ifndef INT32
#ifdef __alpha
typedef signed int INT32;
#else
typedef signed long int INT32;
#endif
#endif

#ifndef INT16
typedef signed short int INT16;
#endif

#ifndef INT8
typedef signed char INT8;
#endif
#endif
/* Define some miscellaneous data types. */

#ifndef BOOLEAN
#ifdef NOVELL
typedef unsigned long BOOLEAN;
#else
typedef unsigned char BOOLEAN;
#endif
#endif

#ifndef NULL
#define NULL 0
#endif


#if !defined HANDLE
typedef void *HANDLE;
#endif

#ifndef VW_DEFS
#ifndef STATUS
typedef unsigned int STATUS;
#endif
#endif

/* Define STATIC so that it does nothing for DEBUG builds. */

#ifndef STATIC
#ifdef DEBUG
#define STATIC
#else
#define STATIC static
#endif
#endif

/* Define the values that should be used with BOOLEAN types. */

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE 1
#endif 

/* The default value is defined to be the largest value for any size field. */

#define DEFAULT -1

/* This macro is used to specify arguments that are not used in functions.  */

#define ARG_NOT_USED(x) (x=x)

#endif
/* G_TYPES_H */
