/*
 * util.c - Various utility procedures
 *
 * Written by Scott W. Shumate
 * 
 * Copyright (c) 1995 Telecommunications & Information
 * Sciences Laboratory, The University of Kansas 
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this
 * software and its documentation is hereby granted,
 * provided that both the copyright notice and this
 * permission notice appear in all copies of the software,
 * derivative works or modified versions, and any portions
 * thereof, that both notices appear in supporting
 * documentation, and that the use of this software is
 * acknowledged in any publications resulting from using
 * the software.
 * 
 * TISL ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION AND DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS
 * SOFTWARE.
 * 
 * Telecommunications & Information Science Lab
 * 2291, Irving Hill Road Lawrence, KS 66046
 * (913)-864-7757
 * http://www.tisl.ukans.edu
 * 
 * The development of this software was generously
 * supported by research grants from Sprint corporation,
 * and we would like to express our thanks.
 */

#include "util.h"
#include "atmd.h"

int AsnOidSize(AsnOid *oid)
{
  int n, size;

  for(n = 1, size = 2; n < oid->octetLen; n++)
    if(!(oid->octs[n] & 0x80))
      size++;

  return size;
}


VarBind *AppendVarBind(VarBindList *list)
{
  AsnListNode *newNode;
  VarBind *entry;
  
  newNode  = alloc_t(AsnListNode);
  newNode->data = alloc_t(VarBind);
  newNode->next = NULL;

  if(list->last == NULL)
    {
      newNode->prev = NULL;
      list->first = newNode;
      list->last = newNode;
    }
  else
    {
      newNode->prev = list->last;
      list->last->next = newNode;
      list->last = newNode;
    }
  
  list->curr = newNode;
  list->count++;
  
  return newNode->data;
}

void AppendListNode(VarBindList *list, AsnListNode *node)
{
  node->next = NULL;
  if(list->last == NULL)
    {
      node->prev = NULL;
      list->first = node;
      list->last = node;
    }
  else
    {
      node->prev = list->last;
      list->last->next = node;
      list->last = node;
    }
  
  list->curr = node;
  list->count++;
  
  return;
}
