#!/usr/bin/perl
#
# The E.164 country code listing can be obtained from
# http://www.itu.ch/itudoc/itu-t/lists/tf_cc_e_*.rtf
#
# This program generates the following coding:
# 
# 0: this is the last digit
# 1: more digits follow; the next bits describe the ten digits
#
# The hierarchy is limited to two digits (i.e. the bit indicating a third
# digit is present but no bits for further digits are there)

while (<>) {
    next unless
      /{\\fs18\\cf1\s(\d+)}{\\f7\\fs24\s\\tab\s}{\\fs18\\cf1\s([^}]+)}/;
    $more[$1/10] = 1;
}
$more[0] = 0; # anomaly
for $a (0..9) {
    if (!$more[$a]) { $bits .= "0"; }
    else {
	$bits .= "1";
	for $b (0..9) {
	    $bits .= sprintf("%d",$more[$a*10+$b]);
	}
    }
}
print "static const char bits[] =" || die "write: $!";
while (length($bits)) {
    print "\n" || die "write: $!";
    print "  \"".substr($bits,0,60)."\"" || die "write: $!";
    $bits = substr($bits,60);
}
print ";\n" || die "write: $!";
