/* qlib.h - run-time library */
 
/* Written 1995,1996 by Werner Almesberger, EPFL-LRC */
 
 
#ifndef QLIB_H
#define QLIB_H

#ifdef DUMP_MODE
#define PREFIX(x) qd_##x
#else
#define PREFIX(x) q_##x
#endif


#include "q.out.h"


/*
 * Severity codes used by the run-time library. Surprisingly, they happen to
 * have the same numerical values as their corresponding atmsigd counterparts.
 */

#define Q_DEBUG		3
#define Q_ERROR		0
#define Q_FATAL		-1


extern int q_dump;
extern void q_report(int severity,const char *msg,...);

#if defined(DUMP_MODE) && !defined(STANDALONE)
extern void qd_dump(const char *fmt,...);
#endif


typedef enum { qet_catch_zero,qet_space,qet_case,qet_abort } Q_ERR_TYPE;

typedef struct _q_err_dsc {
    Q_ERR_TYPE type; /* error type code */
    int pc; /* PC when error was discovered */
    int offset; /* offset into message when error was discovered */
    int value; /* additional value (optional) */
    int id; /* user-assigned id */
    int start; /* recovery area */
    int length;
    int group; /* group that failed (for fixups) */
    struct _q_err_dsc *next;
} Q_ERR_DSC;

typedef struct {
    unsigned char *data;
    unsigned char *required;
    unsigned char *field_present;
    unsigned char *group_present;
    int *length;
    void *buffer;
    int buf_size;
    int error;
    Q_ERR_DSC *errors;
} Q_DSC;
 

void PREFIX(start)(void);
int PREFIX(open)(Q_DSC *dsc,void *buf,int size);
int q_create(Q_DSC *dsc,void *buf,int size);
int PREFIX(close)(Q_DSC *dsc);

void q_assign(Q_DSC *dsc,int field,unsigned long value);
void q_write(Q_DSC *dsc,int field,const void *buf,int size);

int q_present(const Q_DSC *dsc,int field);
unsigned long q_fetch(const Q_DSC *dsc,int field);
int q_read(Q_DSC *dsc,int field,void *buf,int size);
int q_length(const Q_DSC *dsc,int field);

#endif
