/* atmlib.h - Functions useful for ATM applications */
 
/* Written 1995,1996 by Werner Almesberger, EPFL-LRC */
 

#ifndef ATMLIB_H
#define ATMLIB_H

#include <sys/socket.h>
#include <linux/atm.h>


#define HOSTS_ATM "/etc/hosts.atm"

#define T2A_PVC		 1	/* address is PVC */
#define T2A_SVC		 2	/* address is SVC */
#define T2A_UNSPEC	 4	/* allow unspecified parts in PVC address */
#define T2A_WILDCARD	 8	/* allow wildcards in PVC address */
#define T2A_NNI		16	/* allow NNI VPI range (PVC) */
#define T2A_NAME	32	/* allow name resolution */
#define T2A_REMOTE	64	/* try to use ANS if local lookup fails */

#define A2T_PRETTY	 1	/* add syntactic sugar */
#define A2T_NAME	 2	/* attempt name lookup */
#define A2T_REMOTE	 4	/* try to use ANS if local lookup fails */

#define AXE_WILDCARD	 1	/* allow wildcard match */
#define AXE_PRVOPT	 2	/* private part is optional */

#define T2Q_DEFAULTS	 1	/* structure contains default values */


#define MAX_ATM_ADDR_LEN (2*ATM_ESA_LEN+ATM_E164_LEN+5)
				/* 4 dots, 1 plus */
#define MAX_ATM_NAME_LEN 256 /* wild guess */
#define MAX_ATM_QOS_LEN 111	/* 4+2*(3+3*(7+9)+2)+1 */


int text2atm(const char *text,struct sockaddr *addr,int length,int flags);
int atm2text(char *buffer,int length,const struct sockaddr *addr,int flags);
int atm_equal(const struct sockaddr_atmsvc *a,const struct sockaddr_atmsvc *b,
  int len,int flags);
int sdu2cell(int s,int sizes,const int *sdu_size,int *num_sdu);
int text2qos(const char *text,struct atm_qos *qos,int flags);
int qos2text(char *buffer,int length,const struct atm_qos *qos,int flags);
int qos_equal(const struct atm_qos *a,const struct atm_qos *b);

#endif
