/*************************************************************************
  (c) Copyright.  Digital Equipment Corporation, 1995.  All Rights
  Reserved.

  Permission is hereby granted to use, copy, modify, or enhance this 
  software freely, as long as the foregoing copyright of Digital Equipment
  Corporation and this notice are retained on the software.  This 
  software may not be distributed or sublicensed for a fee.  Digital      
  makes this software available "AS IS" and without warranties of any
  kind.  
 *************************************************************************/
/*
 * Marko Kiiskila carnil@cs.tut.fi 
 * 
 * Tampere University of Technology - Telecommunications Laboratory
 *
 * Permission to use, copy, modify and distribute this
 * software and its documentation is hereby granted,
 * provided that both the copyright notice and this
 * permission notice appear in all copies of the software,
 * derivative works or modified versions, and any portions
 * thereof, that both notices appear in supporting
 * documentation, and that the use of this software is
 * acknowledged in any publications resulting from using
 * the software.
 * 
 * TUT ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION AND DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS
 * SOFTWARE.
 * 
 */

/*
* Module Name:
*   g_event.c
*   
* Abstract:
*   This file contains routines that support event reporting.
*                                                                             
* Authors:
*   TLR - Theodore L. Ross
*
* Modification History:
*   Date       Name  Description 
*   15-May-95  TLR   - Created.
*
* Description:
*/


/* Include general headers. */
#include "g_types.h"
#include "codes.h"
#include "g_event.h"

const char *emodtext  (UINT16 mod)
   {
   switch (mod)
      {
      case MOD_CM        : return "CM    ";
      case MOD_SIG       : return "SIGNAL";
      case MOD_LEC_DATA  : return "LECDAT";
      case MOD_LEC_CTRL  : return "LECCTL";
      case MOD_LEC_ARP   : return "LECARP";
      case MOD_UP_DRV    : return "UP_DRV";
      case MOD_LO_DRV    : return "LO_DRV";
      case MOD_ILMI_IO   : return "ILMIIO";
      case MOD_ADDR_REG  : return "ADRREG";
      case MOD_LINE_UP   : return "LINEUP";
      case MOD_SNMP      : return "SNMPAG";
      case MOD_MIB_II    : return "MIB_II";
      case MOD_ILMI_MIB  : return "IL_MIB";
      case MOD_DEC_MIB   : return "DECMIB";
      case MOD_UTL_OS    : return "UTL_OS";
      case MOD_DIAG      : return "DIAGS ";
      case MOD_FLOW      : return "FLOW  ";
      case MOD_OAM       : return "OAM   ";
      case MOD_ATMIP     : return "ATMIP ";
      case MOD_ATMARP    : return "ATMARP";
		case MOD_INIT      : return "INIT  ";
		case MOD_CLIP      : return "CLIP  ";
		default            : return "??????";
      }
   }

const char *emasktext (UINT32 mask)
{
  if (mask & EM_SERR)     return "SERR";
  if (mask & EM_NERR)     return "NERR";
  if (mask & EM_WARN)     return "WARN";
  if (mask & EM_ASSERT)   return "ASRT";
  if (mask & EM_TRAN)     return "TRAN";
  if (mask & EM_EVENT)    return "EVNT";
  if (mask & EM_RCTRL)    return "RCTL";
  if (mask & EM_XCTRL)    return "XCTL";
  if (mask & EM_RDATA)    return "RDAT";
  if (mask & EM_XDATA)    return "XDAT";
  if (mask & EM_TRACE)    return "TRCE";
  if (mask & EM_TIMER)    return "TIMR";
  if (mask & EM_MEM)      return "MEM ";
  if (mask & EM_MSG)      return "MSG ";
  if (mask & EM_DEBUG)    return "DBUG";
  return "????";
}

