/*
 * mib.c - Ilmi management information base (MIB)
 *
 * Written by Scott W. Shumate
 * 
 * Copyright (c) 1995 Telecommunications & Information
 * Sciences Laboratory, The University of Kansas 
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this
 * software and its documentation is hereby granted,
 * provided that both the copyright notice and this
 * permission notice appear in all copies of the software,
 * derivative works or modified versions, and any portions
 * thereof, that both notices appear in supporting
 * documentation, and that the use of this software is
 * acknowledged in any publications resulting from using
 * the software.
 * 
 * TISL ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION AND DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS
 * SOFTWARE.
 * 
 * Telecommunications & Information Science Lab
 * 2291, Irving Hill Road Lawrence, KS 66046
 * (913)-864-7757
 * http://www.tisl.ukans.edu
 * 
 * The development of this software was generously
 * supported by research grants from Sprint corporation,
 * and we would like to express our thanks.
 */

#include "mib.h"
#include "netprefix.h"
#include "util.h"
#include "atmd.h"

#define COMPONENT "MIB"

static Variable variables[] =
{
  { &atmNetPrefixStatus,
    getNetPrefix,
    getnextNetPrefix,
    setNetPrefix,
    NULL },
  { NULL }
};

void MIBget(VarBindList *list, PDUInt *status, AsnInt *index)
{
  VarBind *varbind;
  Variable *var;
  int cmp;

  *index = 1;
  FOR_EACH_LIST_ELMT(varbind, list)
    {
      for(var = variables, cmp = -1;
	  var->name != NULL && (cmp = AsnOidCompare(&varbind->name, var->name)) == -1;
	  var++);
      
      if(cmp == 0)
	*status = var->get(varbind, var);
      else
	*status = NOSUCHNAME;
      
      if(*status != NOERROR)
	return;
      
      (*index)++;
    }
    *index = 0;
    return;
}


void MIBgetnext(VarBindList *list, PDUInt *status, AsnInt *index)
{
  VarBind *varbind;
  Variable *var;

  *index = 1;
  FOR_EACH_LIST_ELMT(varbind, list)
    {
      for(var = variables;
	  var->name != NULL && AsnOidNext(&varbind->name, var->name);
	  var++);

      for(*status = NOSUCHNAME;
	  var->name != NULL && *status == NOSUCHNAME;
	  var++)
	*status = var->getnext(varbind, var);

      if(*status != NOERROR)
	return;
      
      (*index)++;
    }
  *index = 0;
  return;
}

void MIBset(VarBindList *list, PDUInt *status, AsnInt *index)
{
  VarBind *varbind;
  Variable *var;
  int cmp;

  *index = 1;
  FOR_EACH_LIST_ELMT(varbind, list)
    {
      for(var = variables, cmp = -1;
	  var->name != NULL && (cmp = AsnOidCompare(&varbind->name, var->name)) == -1;
	  var++);

      if(cmp == 0)
	*status = var->set(varbind, var);
      else
	*status = NOSUCHNAME;

      if(*status != NOERROR)
	return;
      
      (*index)++;
    }
    *index = 0;
    return;
}

void *MIBdelete(AsnOid *oid)
{
  Variable *var;
  void *value;
  int cmp;

  for(var = variables, cmp = -1;
      var->name != NULL && (cmp = AsnOidCompare(oid, var->name)) == -1;
      var++);

  if(cmp != 0)
    return NULL;

  value = var->value;
  var->value = NULL;

  return value;
}

