/* arequipa.c - AREQUIPA support functions */
 
/* Written 1996 by Jean-Michel Pittet and Werner Almesberger, EPFL-LRC */


#include <unistd.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <linux/arequipa.h>
#include <linux/atm.h>

#include "arequipa.h"


int arequipa_preset(int sd,const struct sockaddr_atmsvc *addr,
  const struct atm_qos *qos)
{
    struct sockaddr_atmsvc a;
    struct atm_blli blli;
    int s;

    if ((s = socket(addr->sas_family,SOCK_DGRAM,ATM_AAL5)) < 0) return -1;
    if (setsockopt(s,SOL_ATM,SO_ATMQOS,qos,sizeof(struct atm_qos)) < 0) {
	(void) close(s);
	return -1;
    }
    a = *addr;
    if (a.sas_family == AF_ATMSVC) {
	a.sas_addr.bhli.hl_type = ATM_HL_USER;
	a.sas_addr.bhli.hl_length = strlen("AREQ");
	strcpy(a.sas_addr.bhli.hl_info,"AREQ");
	a.sas_addr.blli = &blli;
	blli.l2_proto = ATM_L2_ISO8802;
	blli.l3_proto = ATM_L3_NONE;
	blli.next = NULL;
    }
    if (connect(s,(struct sockaddr *) &a,a.sas_family == AF_ATMSVC ? sizeof(a)
      : sizeof(struct sockaddr_atmpvc)) < 0) {
	(void) close (s);
	return -1;
    }
    if (ioctl(s,AREQUIPA_PRESET,sd) < 0) {
	(void) close(s);
	return -1;
    }
    (void) close(s);
    return 0;
}


int arequipa_expect(int sd,int on)
{
    return ioctl(sd,AREQUIPA_EXPECT,on);
}


int arequipa_close(int sd)
{
    return ioctl(sd,AREQUIPA_CLOSE,0);
}
