/*************************************************************************
  (c) Copyright.  Digital Equipment Corporation, 1995.  All Rights
  Reserved.

  Permission is hereby granted to use, copy, modify, or enhance this 
  software freely, as long as the foregoing copyright of Digital Equipment
  Corporation and this notice are retained on the software.  This 
  software may not be distributed or sublicensed for a fee.  Digital      
  makes this software available "AS IS" and without warranties of any
  kind.  
 *************************************************************************/
/*
 * Marko Kiiskila carnil@cs.tut.fi 
 * 
 * Tampere University of Technology - Telecommunications Laboratory
 *
 * Permission to use, copy, modify and distribute this
 * software and its documentation is hereby granted,
 * provided that both the copyright notice and this
 * permission notice appear in all copies of the software,
 * derivative works or modified versions, and any portions
 * thereof, that both notices appear in supporting
 * documentation, and that the use of this software is
 * acknowledged in any publications resulting from using
 * the software.
 * 
 * TUT ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION AND DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS
 * SOFTWARE.
 * 
 */

/*
* Module Name:
*   lec_mgt.h
*   
* Overview:
*
* Authors:
*   TLR - Theodore L. Ross
*
* Modification History:
*   Date       Name  Description 
*
* Dependencies:
*   types.h    - Generally used type definitions.
*   codes.h    - Completion codes.
*   atm.h      - ATM specific definitions and types.
*
* Description:
*
* Call Sequence Requirements:
*
*/

/*************************************************************************
 * Types that are specific to this interface.                            *
 *************************************************************************/

#define  ATTR_C1_MY_ATM_ADDR            1001  /* R  */
#define  ATTR_C2_LAN_TYPE               1002  /* R  */
#define  ATTR_C3_LAN_MTU                1003  /* R  */
#define  ATTR_C4_PROXY_FLAG             1004  /* R  */
#define  ATTR_C5_ELAN_NAME              1005  /* R  */
#define  ATTR_C6_LOCAL_ESI              1006  /* R  */
#define  ATTR_C7_CONTROL_TIMEOUT        1008  /* RW */
#define  ATTR_C8_LOCAL_RD               1009  /* -- */
#define  ATTR_C9_LES_ATM_ADDR           1010  /* R  */
#define  ATTR_C10_MAX_UF_COUNT          1011  /* RW */
#define  ATTR_C11_MAX_UF_TIME           1012  /* RW */
#define  ATTR_C12_VCC_TIMEOUT           1013  /* RW */
#define  ATTR_C13_MAX_RETRY_COUNT       1014  /* RW */
#define  ATTR_C14_LEC_ID                1015  /* R  */
#define  ATTR_C16_LEARP_CACHE           1017  /* R  */
#define  ATTR_C17_AGING_TIME            1019  /* RW */
#define  ATTR_C18_FORW_DELAY_TIME       1020  /* RW */
#define  ATTR_C19_TOPOLOGY_CHANGE_FLAG  1021  /* RW */
#define  ATTR_C20_LEARP_RSP_TIME        1022  /* RW */
#define  ATTR_C21_FLUSH_TIMEOUT         1023  /* RW */
#define  ATTR_C22_PATH_SWITCH_DELAY     1024  /* RW */
#define  ATTR_SM_STATE                  1025  /* R  */
#define  ATTR_SM_STATE_HISTORY          1026  /* R  */
#define  ATTR_BUS_ATM_ADDR              1027  /* R  */
#define  ATTR_ILLEGAL_CTRL_FRAMES_RVCD  1028  /* R  */
#define  ATTR_CTRL_XMT_FAILURES         1029  /* R  */
#define  ATTR_ILLEGAL_TRANSITIONS       1030  /* R  */
#define  ATTR_UCASTS_SENT_DIRECT        1031  /* R  */
#define  ATTR_UCASTS_FLOODED            1032  /* R  */
#define  ATTR_UCASTS_DISCARDED          1033  /* R  */
#define  ATTR_NUCASTS_SENT              1034  /* R  */
#define  ATTR_BUS_FRAMES_RCVD           1035  /* R  */
#define  ATTR_DIRECT_FRAMES_RCVD        1036  /* R  */
#define  ATTR_RCV_FRAMES_DISCARDED      1037  /* R  */
#define  ATTR_ECHOS_SUPPRESSED          1038  /* R  */
#define  ATTR_CTRL_FRAMES_SENT          1039  /* R  */
#define  ATTR_CTRL_FRAMES_RCVD          1040  /* R  */
#define  ATTR_LEARPS_SENT               1041  /* R  */
#define  ATTR_LEARPS_RCVD               1042  /* R  */
#define  ATTR_LEARP_SET                 1043  /* W  */
#define  ATTR_LEARP_DELETE              1044  /* W  */


typedef struct
   {
   ESI         esi;
   UINT16      esi_status;
   BOOLEAN     remote_flag;
   BOOLEAN     permanent_flag;
   UINT32      arp_age;
   ADDR_ATM    addr_atm;
   UINT16      atm_status;
   UINT32      vcc_count;
   UINT32      esi_count;
   UINT32      vc_id;
   UINT16      vc_flags;
   UINT32      age_limit;
   UINT32      idle_time;
   } LEARP_CACHE_ENTRY;

typedef struct
   {
   ESI         esi;
   ADDR_ATM    addr_atm;
   BOOLEAN     permanent_flag;
   } LEARP_SET;

