/*
 * Marko Kiiskila carnil@cs.tut.fi 
 * 
 * Copyright (c) 1996
 * Tampere University of Technology - Telecommunications Laboratory
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this
 * software and its documentation is hereby granted,
 * provided that both the copyright notice and this
 * permission notice appear in all copies of the software,
 * derivative works or modified versions, and any portions
 * thereof, that both notices appear in supporting
 * documentation, and that the use of this software is
 * acknowledged in any publications resulting from using
 * the software.
 * 
 * TUT ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION AND DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS
 * SOFTWARE.
 * 
 */
/*
 * Include file for kernel interface
 *
 * $Id: kernel_itf.h,v 1.3 1996/04/25 19:42:13 carnil Exp carnil $
 *
 */
#ifndef KERNEL_ITF_H
#define KERNEL_ITF_H
#include <linux/atmlec.h>

typedef void (*kernel_callback)(struct atmlec_msg *mesg);

int kernel_init(unsigned char *mac_addr);
int kernel_sendmsg(atmlec_msg_type type, unsigned char *mac_addr,
		   unsigned char *atm_addr, struct atmlec_config_msg *config,
		   unsigned long flag);
int kernel_register_callback(atmlec_msg_type type, kernel_callback callback);
void kernel_dispatch_handlers(void);

#endif /* KERNEL_ITF_H */
/*
 *
 * $Log: kernel_itf.h,v $
 * Revision 1.3  1996/04/25 19:42:13  carnil
 * Copyright notice
 *
 * Revision 1.2  1996/03/17 21:23:41  carnil
 * kernel_sendmsg changed
 *
 * Revision 1.1  1996/03/15 07:08:09  carnil
 * Initial revision
 *
 *
 */
