#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <linux/atm.h>


int main(int argc,char **argv)
{
    struct sockaddr_atmpvc addr;
    int s;

    if (argc != 4 && argc != 5) {
	fprintf(stderr,"usage: %s itf vpi vci [ pcr ]\n",argv[0]);
	return 1;
    }
    if ((s = socket(PF_ATMPVC,SOCK_DGRAM,ATM_CLIP)) < 0) {
	perror("socket");
	return 1;
    }
    memset(&addr,0,sizeof(addr));
    addr.sap_family = AF_ATMPVC;
    addr.sap_addr.itf = atoi(argv[1]);
    addr.sap_addr.vpi = atoi(argv[2]);
    addr.sap_addr.vci = atoi(argv[3]);
    if (argc == 5) {
	addr.sap_txtp.class = ATM_CBR;
	addr.sap_txtp.min_pcr = atoi(argv[4]);
    }
    if (bind(s,(struct sockaddr *) &addr,sizeof(addr)) < 0) {
	perror("bind");
	return 1;
    }
    printf("OK\n");
    pause();
    return 0;
}
