#
#	MN_lib.pl
#
#	Mail-Net common functions library.
#
#	Created: Fri Feb 28 20:02:02 1992
#	Last modified: Sat Dec 26 02:16:10 1992
#
#	@ arl // 1992
#

sub
tmpfile
{
	local($filename) = pop(@_);

	$filename = sprintf("%s%ld.%d", $filename, time, $$ );
}

sub
do_upper
{
#	We should throw this function away
	local($ourstring) = pop(@_);

	$ourstring =~ y/[a-z]/[A-Z]/;

#	return($ourstring);
	return $ourstring;
}

sub
WriteLog
{
	local(@array)		= @_;
	local($i)		= 1;
	local($lokistring)	= '';
#	local(LOKIF);

	while (@array[$i])
	{
		$lokistring .= @array[$i] . ":";
		$i++;
	}
	$lokistring .= "\n";

#	Try to make only one write, hope the system writes
#	a string at once.
	$DEBUG && print "LOKIF=",@array[0],"\n";
	$DEBUG && print "LOKIS=",$lokistring,"\n";
	open( LOKIF, ">>" . @array[0] ) || do
	{
		$DEBUG && print "$0: Could not open logfile ", @array[0], "\n";
		exit(1);
	};

	print LOKIF $lokistring;
	close(LOKIF);
}

@ADMIN_WORDS	=
( 	"MN-Admin:","MN-admin:","Mn-Admin:","Mn-admin:","mn-Admin:",
		"mn-admin:",
	"X-MN-Admin:","X-MN-admin:","X-Mn-Admin:","X-Mn-admin:","X-mn-Admin:",
		"X-mn-admin:"
);

@INFO_WORDS	=
(
	"MN-Info:","MN-info:","Mn-Info:","Mn-info:","mn-Info:",
		"mn-info:",
	"X-MN-Info:","X-MN-info:","X-Mn-Info:","X-Mn-info:","X-mn-Info:",
		"X-mn-info:"
);

@SERVER_WORDS	=
(
	"MN-Key:","MN-key:","Mn-Key:","Mn-key:","mn-Key:","mn-key:", #/*0-5*/
	"X-MN-Key:","X-MN-key:","X-Mn-Key:","X-Mn-key:","X-mn-Key:", #/*6-11*/
		"X-mn-key:",
	"MN-Dist:","MN-dist:","Mn-Dist:","Mn-dist:","mn-Dist:","mn-dist:",
#				     /*12-17*/
	"X-MN-Dist:","X-MN-dist:","X-Mn-Dist:","X-Mn-dist:","X-mn-Dist:",
		"X-mn-dist:"
);

sub
ParseMnLine
{
	local($line)	= pop(@_);

	$DEBUG && print "line = $line\n";
	if ( (($line,$dummy) = split(/([:])/o,$line,2) ) )
	{
		$line .= ':';
	}
	$DEBUG && print "line = $line\n";

	foreach (@SERVER_WORDS)
	{
		if ( $_ eq $line )
		{
			return $SERVER;
		}
	}

	foreach (@ADMIN_WORDS)
	{
		if ( $_ eq $line )
		{
			return $ADMIN;
		}
	}

	foreach (@INFO_WORDS)
	{
		if ( $_ eq $line )
		{
			return $INFO;
		}
	}

	return 0;
}

$default_mode	= 0;
$quote_mode	= 1;
$string_mode	= 2;
$startup_mode	= 3;
$address_mode	= 4;
$name_mode	= 5;
$parent_mode	= 6;

sub
do_from
{
	local($line)	= pop(@_);
	local(@parse)	= ();
	local(@save)	= ();
	local($mode)	= $startup_mode;
	local(@modes)	= ();

	@parse = split(/([ \t\(\)\<\>\"\@\\])/,$line);

	$Address'address	= '';
	$Address'name		= '';

	foreach (@parse)
	{
#		print "do_from: parse = \"",$_,"\"\n";
		if ( $_ eq '' ) { next; }

#print "-> save = ";
#foreach (@save)
#{
#	print "\"",$_,"\" ";
#}
#print "\n-> mode = ",$mode,"\n";

		if ( /\"/ )
		{
			if ( $mode == $quote_mode )
			{
				push( @save, $_ );
				$mode = pop( @modes );
				next;
			}
			elsif ( $mode == $address_mode )
			{
				push( @save, $_ );
				next;
			}
			elsif ( $mode == $string_mode )
			{
				push( @save, $_ );
				foreach ( @save )
				{
					$Address'name .= $_;
				}
				@save = ();
				$mode = $default_mode;
				next;
			}
			else
			{
				$mode = $string_mode;
				push( @save, $_ );
				next;
			}
		}
		elsif ( /\\/ )
		{
			if ( $mode == $quote_mode )
			{
				$mode = pop( @modes );
			}
			else
			{
				push( @modes, $mode );
				$mode = $quote_mode;
			}
			push( @save, $_ );
			next;
		}
		elsif ( / / || /\t/ )
		{
			if ( $mode == $startup_mode )
			{
#				eat whitespaces.
				next;
			}
			elsif ( $mode == $address_mode )
			{
				foreach ( @save )
				{
					$Address'address .= $_;
				}
				@save = ();
				$mode = $default_mode;
				next;
			}
			elsif ( $mode == $quote_mode )
			{
				$mode = pop( @modes );
			}
			push( @save, $_ );
			next;
		}
		elsif ( /\</ )
		{
#			This must be start of address.
			if ( $mode == $string_mode )
			{
				push( @save, $_ );
				next;
			}
			elsif ( $mode == $quote_mode )
			{
				push( @save, $_ );
				$mode = pop( @modes );
				next;
			}
			foreach ( @save )
			{
				$Address'name .= $_;
			}
			@save = ();
			$mode = $address_mode;
		}
		elsif ( /\>/ )
		{
#			This must be end of address.
			if ( $mode == $address_mode )
			{
#				if address contains data, it's caused
#				by addresses like:
#				Veijo Luuser (VJ) <veijo@site.domain.fi>
				if ( length($Address'address) > 0 )
				{
$DEBUG && print "***** Error: Address'address has = \"",
		$Address'address, "\"", " Corrected\n";
					$Address'name = $Address'address .
						$Address'name;
				}
				$Address'address = '';
				foreach ( @save )
				{
					$Address'address .= $_;
				}
				@save = ();
				$mode = $default_mode;
				next;
			}
			elsif ( $mode == $quote_mode )
			{
				$mode = pop( @modes );
			}
			push( @save, $_ );
			next;
		}
		elsif ( /\(/ )
		{
			if ( $mode == $string_mode )
			{
				push( @save, $_ );
				next;
			}
			elsif ( $mode == $quote_mode )
			{
				$mode = pop( @modes );
				push( @save, $_ );
				next;
			}
			elsif ( $mode == $name_mode )
			{
				push( @modes, $mode );
				$mode = $parent_mode;
				push( @save, $_ );
				next;
			}
#			if ( $mode == $address_mode )
			if ( $#save > -1 )
			{
#				Possibly no space between address and
#				name field (..).

				foreach ( @save )
				{
					$Address'address .= $_;
				}
				@save = ();
			}
			$mode = $name_mode;
		}
		elsif ( /\)/ )
		{
			if ( $mode == $string_mode )
			{
				push( @save, $_ );
				next;
			}
			elsif ( $mode == $quote_mode )
			{
				$mode = pop( @modes );
				push( @save, $_ );
				next;
			}
			elsif ( $mode == $parent_mode )
			{
				$mode = pop( @modes );
				push( @save, $_ );
				next;
			}
			elsif ( $mode == $name_mode )
			{
				foreach ( @save )
				{
					$Address'name .= $_;
				}
				@save = ();
				$mode = $default_mode;
				next;
			}
			$DEBUG && print "mode = ", $mode,
					" after ) .. really weird\n";
		}
		elsif ( /\@/ )
		{
			if ( $mode == $string_mode )
			{
				push( @save, $_ );
				next;
			}
			elsif ( $mode == $quote_mode )
			{
				$mode = pop( @modes );
				push( @save, $_ );
				next;
			}
			elsif ( $mode == $name_mode )
			{
				push( @save, $_ );
				next;
			}
			$mode = $address_mode;
#			This means '@' starting addresses not
#			supported ;-) .. there must have been
#			"vms::name"@foo.site.country
			if ( @save == () )
			{
				push( @save, $Address'name );
			}
			push( @save, $_ );
			next;
		}
		else
		{
			if ( $mode == $quote_mode )
			{
				$mode = pop( @modes );
			}
			if ( $mode == $startup_mode )
			{
				$mode = $default_mode;
			}
			push( @save, $_ );
			next;
		}
	}

	if ( $mode == $quote_mode )
	{
#		\ at the end of the line is not supported ...
		$mode = pop( @modes );
	}

	if ( $mode == $address_mode )
	{
		foreach ( @save )
		{
			$Address'address .= $_;
		}
		@save = ();
	}
	else
	{
		if ( length($Address'address) < 1 )
		{
			foreach ( @save )
			{
				$Address'address .= $_;
			}
			@save = ();
		}
		else
		{
			foreach ( @save )
			{
				$Address'name .= $_;
			}
			@save = ();
		}
	}

#
#	Remove trailing white spaces from name.
#
	while (1)
	{
		if ( length($Address'name) == 0 )
		{
			last;
		}
		$char = chop($Address'name);
		if ( $char ne " " && $char ne "\t" )
		{
			$Address'name .= $char;
			last;
		}
	}

#
#	Remove trailing white spaces from address.
#
	while (1)
	{
		if ( length($Address'address) == 0 )
		{
			last;
		}
		$char = chop($Address'address);
		if ( $char ne " " && $char ne "\t" )
		{
			$Address'address .= $char;
			last;
		}
	}

	$DEBUG && print "do_from: address = \"", $Address'address,
		"\" name = \"", $Address'name,"\"\n";
}

1;

