#
#	MN_admin.pl
#
#	Mail-Net admin program
#
#	Created: Fri Feb 28 20:02:02 1992
#	Last modified: Sun Dec 13 04:15:12 1992
#
#	@ arl // 1992
#

require		"$ARGV[0]/MN_config.pl";
require		"$ARGV[0]/MN_lib.pl";
require		"$ARGV[0]/MN_global.pl";

sub
CreateChannel
{
	local($ChannelName)	= pop(@_);
	local($result)		= -1;

	&OpenChannelFile("+<");

	&ReadChannelFile();

	if ( &CheckIfChannelThere( $ChannelName ) == 1 )
	{
#		Write error to our log file.
		&WriteLog( $LOG_FILENAME, $0, "failed to create",
			$FromAddress, $ChannelName );
#		Send mail to user trying to create the channel.
		&SendMail( $SendBackAddress, $ChannelName,
			"Error: Channel already exists" );
		&CloseChannelFile();
	}
	else
	{
#		&AddToChannelFile( $ChannelName, $FileName, $FromAddress );
		&AddToChannelFile( $ChannelName, @ARGV[3], $FromAddress );
		&SaveChannelFile();
		&CloseChannelFile();
		&WriteLog( $LOG_FILENAME, $0, "created a new channel",
			$FromAddress, $ChannelName );
		&SendMail( $SendBackAddress, $ChannelName,
			"Created a new channel" );
		$result = 0;
	}
	$result;
}

sub
DeleteChannel
{
	local($ChannelName)	= pop(@_);
	local($result)		= -1;
	$result;
}

sub
LinkChannel
{
	local($ChannelName)	= pop(@_);
	local($result)		= -1;
	$result;
}

sub
JoinChannel
{
	local($ChannelName)	= pop(@_);
	local($result)		= -1;

	$DEBUG && print "JoinChannel: channelname = \"",$ChannelName,"\"\n";

	&OpenChannelFile( "<" );
	&ReadChannelFile();
	if ( &CheckIfChannelThere( $ChannelName ) == 0 )
	{
		&WriteLog( $LOG_FILENAME, $0, "failed to join",
			"channel does not exist", $ChannelName,
			$FromAddress );
		&SendMail( $SendBackAddress, $ChannelName,
			"Error: No such channel to join" );
		&CloseChannelFile();
		$result = -1;
	}
	else
	{
		&AddToUserFile( $ChannelName, $FromAddress );
		&CloseChannelFile();
		&WriteLog( $LOG_FILENAME, $0, "joined to channel",
			$FromAddress, $ChannelName );

		&SendMail( $SendBackAddress, $ChannelName,
			"You've joined to the channel" );
		$result = 0;
	}
	$result;
}

sub
LeaveChannel
{
	local($ChannelName)	= pop(@_);
	local($result)		= -1;

	&OpenChannelFile( "+<" );

	&ReadChannelFile();

	if ( &CheckIfChannelThere( $ChannelName ) == 0 )
	{
#		No such channel, send error message.
		&WriteLog( $LOG_FILENAME, $0, "failed to leave",
			"no such channel", $ChannelName,
			$Address'address );
		&SendMail( $Address'address, $ChannelName,
			"Error: No such channel to leave" );
		&CloseChannelFile();
		return -1;
	}
	$result = &TakeFromUserFile( $ChannelName, $Address'address );
	&do_from( $FromAddress );
	if ( $result == 0 )
	{
		&WriteLog( $LOG_FILENAME, $0, "failed to leave",
			"user not on channel", $ChannelName,
			$Address'address );
		&SendMail( $Address'address, $ChannelName,
			"Sorry, you're not on the channel" );
	}
	elsif ( $result == 1 )
	{
		&WriteLog( $LOG_FILENAME, $0,
			"left the channel", $ChannelName,
			$Address'address );
		&SendMail( $Address'address, $ChannelName,
			"You've left the channel" );
	}
	else
	{
		&WriteLog( $LOG_FILENAME, $0,
			"LEAVE ERROR", $ChannelName,
			$Address'address );
		&SendMail( $Address'address, $ChannelName,
			"Some error happened here - admin notified" );
	}

	&CloseChannelFile();

	$result;
}

sub
AdminChannel
{
	local($FileName)	= pop(@_);
	local($ChannelName)	= pop(@_);

	$AdminAddress = "arl@cs.hut.fi";
	if ( $Address'address eq $AdminAddress )
	{
		&WriteLog( $LOG_FILENAME, $0, $Address'address,
			"not allowed to admin" );
		return -1;
	}

	$DEBUG && print "AdminCommand = ",$ChannelName,"\n";

	return 0;
}

@TheMail	=	();

#
#	main ...
#

chdir( @ARGV[1] );

$GL_WhoAmI = @ARGV[2];

open( tempf, "<" . @ARGV[$#ARGV] ) || do
{
	$DEBUG && print "$0: Could not open file:", @ARGV[$#ARGV], "\n";
	exit(1);
};

$header = 1;
$NoCommand = 1;
while (<tempf>)
{
	@TheMail .= $_;

	if ( $header == 1 )
	{
		if ( length($_) == 1 )
		{
			$header = 0;
			next;
		}

#		Remove the eol newline.
		chop;

		if ( /^From:/ )
		{
			($dummy,$FromAddress) = split(/[:]/o);
			next;
		}
		if ( /^Reply-To:/ )
		{
			($dummy,$ReplyToAddress) = split(/[:]/o);
			next;
		}
		if ( /^Sender:/ )
		{
			($dummy,$SenderAddress) = split(/[:]/o);
			next;
		}

		if ( ( /^X-Mn/ || /^Mn/ ) && $NoCommand )
		{
			($dummy,$AdminCommand) = split(/[:]/o);
			$DEBUG && print "Line=\"",$_,
				"\" admincommand=\"",$AdminCommand,"\"\n";
			$NoCommand = 0;
			next;
		}
	}
}

close( tempf );

if ( $ReplyToAddress )
{
	$SendBackAddress = $ReplyToAddress;
}
else
{
	$SendBackAddress = $FromAddress;
}

&do_from( $FromAddress );

$DEBUG && print "$0: Admin command =\"", $AdminCommand, "\"\n";

#
#	Parsing the command out.
#
@Commands = ();
$dummy = ( @Commands = split(' ', $AdminCommand ) );

$DEBUG && print "Admin command =\"", $AdminCommand, "\"\n";
foreach (@Commands)
{
	$DEBUG && print "Commands=\"",$_,"\"\n";
}

if ( @Commands[0] eq "create" )
{
	&CreateChannel( @Commands[1] );
}
elsif ( @Commands[0] eq "delete" )
{
	&DeleteChannel( @Commands[1] );
}
elsif ( @Commands[0] eq "link" )
{
	&LinkChannel( @Commands[1] );
}
elsif ( @Commands[0] eq "join" )
{
	&JoinChannel( @Commands[1] );
}
elsif ( @Commands[0] eq "leave" )
{
	&LeaveChannel( @Commands[1] );
}
elsif ( @Commands[0] eq "admin" )
{
	&AdminChannel( @Commands[1] );
}
else
{
	&WriteLog( $LOG_FILENAME, $0, "unknown command",
		$Address'address, $AdminCommand );
	&SendMail( $Address'address, $AdminCommand,
		"MN-ADMIN: ERROR: unknown command" );
}

#Enable after debugging done.
link( @ARGV[3], &tmpfile( $DONE_TMPFILE ) );
unlink( @ARGV[3] );

exit( 0 );

