#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/grinternal.h>

void
gr_handle_ioperm(void)
{
	security_alert(GR_IOPERM_MSG, DEFAULTSECARGS);
	return;
}

void
gr_handle_iopl(void)
{
	security_alert(GR_IOPL_MSG, DEFAULTSECARGS);
	return;
}

void
gr_handle_mem_write(void)
{
	security_alert(GR_MEM_WRITE_MSG, DEFAULTSECARGS);
	return;
}

void
gr_handle_kmem_write(void)
{
	security_alert(GR_KMEM_MSG, DEFAULTSECARGS);
	return;
}

void
gr_handle_open_port(void)
{
	security_alert(GR_PORT_OPEN_MSG, DEFAULTSECARGS);
	return;
}

int
gr_handle_mem_mmap(const unsigned long offset, struct vm_area_struct *vma)
{
	if (offset < __pa(high_memory) &&
	    (pgprot_val(vma->vm_page_prot) & PROT_WRITE) &&
	    !(offset == 0xf0000 && ((vma->vm_end - vma->vm_start) <= 0x10000)) &&
	    !(offset == 0xa0000 && ((vma->vm_end - vma->vm_start) <= 0x20000))) {
		security_alert(GR_MEM_MMAP_MSG, DEFAULTSECARGS);
		return -EPERM;
	} else if (offset < __pa(high_memory))
		vma->vm_flags &= ~VM_MAYWRITE;

	return 0;
}
