/*******************************************************************************

  Copyright(c) 2002 - 2005 Promise Technology, Inc. All rights reserved.
  
  cam_exp.h - function prototypes provided by CAM

  This program is free software; you can redistribute it and/or modify it 
  under the terms of the GNU General Public License as published by the Free 
  Software Foundation; either version 2 of the License, or (at your option) 
  any later version.
  
  This program is distributed in the hope that it will be useful, but WITHOUT 
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
  more details.
  
  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
  The full GNU General Public License is included in this distribution in the
  file called LICENSE.
  
  Contact Information:
  Promise Technology, Inc.
  <support@promise.com.tw>	[TAIWAN]
  <support@promise.com>		[U.S.A]
  <support-china@promise.com>	[CHINA]

*******************************************************************************/
 
#ifndef CAM_EXP_H
#define CAM_EXP_H
 
/* 
 *	cam.c
 */
extern void CAM_GetInfo(PCAM_INFO pCAMInfo);
extern U8 CAM_Init(PADAPTER_CONFIG_INFO pAdapter);
extern U8 CAM_ReInit(PADAPTER_CONFIG_INFO pAdapter);
extern U8 CAM_Close(PADAPTER_CONFIG_INFO pAdapter);
extern U32 CAM_GetExtraData(U8 Adapter_ID, U8 bID);
extern void CAM_SetExtraData(U8 Adapter_ID, U8 bID, U32 value);
extern void CAM_GetPacketCount(U8 bAdapterNumber,PMODULE_PACKET_COUNT pCAM_Module);
extern void CAM_SetPacketCount(U8 bAdapterNumber,PMODULE_PACKET_COUNT pCAM_Module);
extern void CAM_GetTimeoutTime(U8 bAdapterNumber,PMODULE_TIMEOUT pCAM_Timeout);
extern void CAM_SetTimeoutTime(U8 bAdapterNumber,PMODULE_TIMEOUT pCAM_Timeout);
void WriteIndexUchar(U32 BaseAddress, U8 Index, U8 Data );
U8 ReadIndexUchar(U32 BaseAddress, U8 Index );

extern U8 CAMAllocSEQID(U8 card_no);
extern void CAMFreeSEQID(U8 card_no, U8 SEQID);
extern PVOID CAMAllocPacket(U8 card_no, PAC_Q_TYPE q_type);
extern void CAMFreePacket(U8 card_no, PAC_Q_TYPE q_type, PVOID PacketAddress);
extern PVOID CAMAllocSG(U8 card_no, PAC_Q_TYPE q_type);
extern void CAMFreeSG(U8 card_no, PAC_Q_TYPE q_type, PVOID PacketAddress);
extern void checkConvertSG(PCAMSG  source_sg,PCAMSG target_sg);
extern void Put2SeqIDQueue(U8 bAdapterNumber,PVOID PacketAddress,U8 SeqID);
extern void CAM_DisableBMRLongBurst(U8 Adapter_ID);

/* 
 *	cam_ata.c
 */
extern U8 CAM_InitATAChannel(U8 bChannelNumber);
extern U8 CAM_ResetATAChannel(U8 bChannelNumber);
extern U8 CAM_EnumATAChannel(PCHNL_CONFIG pChnlConfig);
extern U8 CAM_ConfigATAChannel(PCHNL_CONFIG pChnlConfig);
extern U8 CAM_EnumATADevice(PDEV_CONFIG pDevConfig);
extern U8 CAM_ConfigATADevice(PDEV_CONFIG pDevConfig);
extern U8 CAM_SubmitATA (PATA_TASK pATATask);
extern void ATASoftResetModule(U8 bChannelNumber);
extern void ATAErrorStatus(PATA_TASK pATATask);
extern void ATAPIErrorStatus(PATA_TASK pATATask);
extern void SubmitInternelSense(PATA_TASK pATATask);
extern void (*ATA_Timeout_Function[])(void);
extern void Abort_All_Undone_ATAPackets(U8 bCh,PCAM_ATA_PACKET pATAPacket);
extern void stopATAModule(U8 bChannelNumber);
extern U8 WaitForDrq(U32 IDEBaseAddress);

/* 
 *	cam_xor.c
 */
extern U8 CAM_SubmitXOR(PCAM_XOR_TASK pXORTask);
extern void XORSoftResetModule(U8 bAdapterNumber);
extern void (*XOR_Timeout_Function[])(void);
extern void Abort_All_Undone_XORPackets(U8 bAdapterNumber,PCAM_XOR_PACKET XORPacketAddress);
extern void stopXORModule(U8 bAdapterNumber);

/* 
 * cam_swap.c
 */
extern U8 CAM_EnumEnclosure(U8 bCh, PENCLOSURE_TYPE pBox);
extern U8 CAM_Get_Enclosure_Status(U8 bID, PENCLOSURE_STATUS pBoxStatus);
extern void CAM_CtrlLED(U8 bID, U8 bColor); 
extern void CAM_Enclosure_PowerOn(U8 bID);
extern void CAM_Enclosure_PowerOff(U8 bID);
extern void Check_Enclosure_PowerState(U8 bID);

/*
 *	cam_isr.c
 */
extern U32 CAM_ISR(U32 IRQHandle);
extern void StartATAOperation(U8 bChannelNumber);
extern void StartXOROperation(U8 bAdapterNumber);

/*
 *	cam_fm.c
 */
extern U8 CAM_Find_FlashMemory (U8 Adapter_ID, PU8 pModelName);
extern U8 CAM_Erase_FlashMemory(U8 Adapter_ID);
extern U8 CAM_Write_FlashMemory(U8 Adapter_ID, U32 Offset, U32 BufSize, PU8 pDatabuf);
extern U8 CAM_Read_FlashMemory(U8 Adapter_ID, U32 Offset, U32 BufSize, PU8 pDatabuf);

#endif
