/*******************************************************************
 * This file is part of the Emulex Linux Device Driver for         *
 * Enterprise Fibre Channel Host Bus Adapters.                     *
 * Refer to the README file included with this package for         *
 * driver version and adapter support.                             *
 * Copyright (C) 2003 Emulex Corporation.                          *
 * www.emulex.com                                                  *
 *                                                                 *
 * This program is free software; you can redistribute it and/or   *
 * modify it under the terms of the GNU General Public License     *
 * as published by the Free Software Foundation; either version 2  *
 * of the License, or (at your option) any later version.          *
 *                                                                 *
 * This program is distributed in the hope that it will be useful, *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of  *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   *
 * GNU General Public License for more details, a copy of which    *
 * can be found in the file COPYING included with this package.    *
 *******************************************************************/

/*
LOG Message Preamble Strings

Preamble strings are displayed at the start of LOG messages.
The 3rd letter of the preamble string identifies the 
message type as follows:

i = Information                 fc_msgPreamble??i where i = Information
w = Warning                     fc_msgPreamble??w where w = Warning
c = Error config                fc_msgPreamble??c where c = Error config
e = Error                       fc_msgPreamble??e where e = Error
p = Panic                       fc_msgPreamble??p where p = Panic
*/

/* ELS Log Message Preamble Strings - 100 */
char fc_msgPreambleELi[] = "ELi:"; /* ELS Information */
char fc_msgPreambleELw[] = "ELw:"; /* ELS Warning */
char fc_msgPreambleELe[] = "ELe:"; /* ELS Error */
char fc_msgPreambleELp[] = "ELp:"; /* ELS Panic */

/* DISCOVERY Log Message Preamble Strings - 200 */
char fc_msgPreambleDIi[] = "DIi:"; /* Discovery Information */
char fc_msgPreambleDIw[] = "DIw:"; /* Discovery Warning */
char fc_msgPreambleDIe[] = "DIe:"; /* Discovery Error */
char fc_msgPreambleDIp[] = "DIp:"; /* Discovery Panic */

/* MAIBOX Log Message Preamble Strings - 300 */
char fc_msgPreambleMBi[] = "MBi:"; /* Mailbox Information */
char fc_msgPreambleMBw[] = "MBw:"; /* Mailbox Warning */
char fc_msgPreambleMBe[] = "MBe:"; /* Mailbox Error */
char fc_msgPreambleMBp[] = "MBp:"; /* Mailbox Panic */

/* INIT Log Message Preamble Strings - 400, 500 */
char fc_msgPreambleINi[] = "INi:"; /* INIT Information */
char fc_msgPreambleINw[] = "INw:"; /* INIT Warning */
char fc_msgPreambleINc[] = "INc:"; /* INIT Error Config*/
char fc_msgPreambleINe[] = "INe:"; /* INIT Error */
char fc_msgPreambleINp[] = "INp:"; /* INIT Panic */

/* IP Log Message Preamble Strings - 600 */
char fc_msgPreambleIPi[] = "IPi:"; /* IP Information */
char fc_msgPreambleIPw[] = "IPw:"; /* IP Warning */
char fc_msgPreambleIPe[] = "IPe:"; /* IP Error */
char fc_msgPreambleIPp[] = "IPp:"; /* IP Panic */

/* FCP Log Message Preamble Strings - 700, 800 */
char fc_msgPreambleFPi[] = "FPi:"; /* FP Information */
char fc_msgPreambleFPw[] = "FPw:"; /* FP Warning */
char fc_msgPreambleFPe[] = "FPe:"; /* FP Error */
char fc_msgPreambleFPp[] = "FPp:"; /* FP Panic */

/* NODE Log Message Preamble Strings - 900 */
char fc_msgPreambleNDi[] = "NDi:"; /* Node Information */
char fc_msgPreambleNDe[] = "NDe:"; /* Node Error */
char fc_msgPreambleNDp[] = "NDp:"; /* Node Panic */



/* MISC Log Message Preamble Strings - 1200 */
char fc_msgPreambleMIi[] = "MIi:"; /* MISC Information */
char fc_msgPreambleMIw[] = "MIw:"; /* MISC Warning */
char fc_msgPreambleMIc[] = "MIc:"; /* MISC Error Config */
char fc_msgPreambleMIe[] = "MIe:"; /* MISC Error */
char fc_msgPreambleMIp[] = "MIp:"; /* MISC Panic */

/* Link Log Message Preamble Strings - 1300 */
char fc_msgPreambleLKi[] = "LKi:"; /* Link Information */
char fc_msgPreambleLKw[] = "LKw:"; /* Link Warning */
char fc_msgPreambleLKe[] = "LKe:"; /* Link Error */
char fc_msgPreambleLKp[] = "Lkp:"; /* Link Panic */

/* SLI Log Message Preamble Strings - 1400 */
char fc_msgPreambleSLe[] = "SLe:"; /* SLI Error */

/* CHECK CONDITION Log Message Preamble Strings - 1500 */
char fc_msgPreambleCKi[] = "CKi:"; /* Check Condition Information */
char fc_msgPreambleCKe[] = "CKe:"; /* Check Condition Error */
char fc_msgPreambleCKp[] = "CKp:"; /* Check Condition Panic */


/*
 *  Begin ELS LOG message structures
 */

/*
msgName: fc_mes0100
message:  Abort delay xmit clock
descript: The driver is canceling the delay timer for sending an ELS 
          command.
data:     (1) did (2) remoteID (3) ulpIoTag
severity: Warning
log:      LOG_ELS verbose
module:   fcclockb.c
action:   None required
*/
char      fc_mes0100[] = "%sAbort delay xmit clock Data: x%x x%x x%x"; 
msgLogDef fc_msgBlk0100 = {
          FC_LOG_MSG_EL_0100,            /* LOG message number */
          fc_mes0100,                    /* LOG message pointer */
          fc_msgPreambleELw,             /* LOG message preamble pointer */
          FC_MSG_OPUT_GLOB_CTRL,         /* LOG message output control */
          FC_LOG_MSG_TYPE_WARN,          /* LOG message type */
          LOG_ELS,                       /* LOG message mask & group */
          ERRID_LOG_UNEXPECT_EVENT };    /* LOG message error ID */

/*
msgName: fc_mes0101
message:  Abort delay xmit context
descript: The driver is canceling the delay timer for sending an ELS
          command.
data:     (1) did (2) remoteID (3) ulpIoTag
severity: Warning
log:      LOG_ELS verbose
module:   fcclockb.c
action:   None required
*/
char      fc_mes0101[] = "%sAbort delay xmit context Data: x%x x%x x%x"; 
msgLogDef fc_msgBlk0101 = {
          FC_LOG_MSG_EL_0101,
          fc_mes0101,
          fc_msgPreambleELw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0102
message:  Stray ELS completion
descript: Received an ELS command completion without issuing a 
          corresponding ELS Command (based on the IOTAG field 
          in the CMD_ELS_REQUEST_CR IOCB).
data:     (1) ulpCommand (2) ulpIoTag
severity: Error
log:      Always
module:   fcelsb.c
action:   This error could indicate a software driver or firmware 
          problem. If problems persist report these errors to 
          Technical Support.
*/
char      fc_mes0102[] = "%sStray ELS completion Data: x%x x%x"; 
msgLogDef fc_msgBlk0102 = {
          FC_LOG_MSG_EL_0102,
          fc_mes0102,
          fc_msgPreambleELe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0103
message:  Dropping ELS rsp
descript: Dropping ELS response because there is no node table entry.
data:     (1) ldata (2) ldid
severity: Error
log:      Always
module:   fcscsib.c
action:   This error could indicate a software driver or firmware 
          problem. If problems persist report these errors to 
          Technical Support.
*/
char      fc_mes0103[] = "%sDropping ELS rsp Data: x%x x%x"; 
msgLogDef fc_msgBlk0103 = {
          FC_LOG_MSG_EL_0103,
          fc_mes0103,
          fc_msgPreambleELe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0104
message:  Aborted ELS IOCB
descript: Driver decided to abort any action taken as a result of this ELS 
          command completing.
data:     (1) ulpCommand (2) ulpIoTag
severity: Information
log:      LOG_ELS verbose
module:   fcelsb.c
action:   None required. 
*/
char      fc_mes0104[] = "%sAborted ELS IOCB Data: x%x x%x"; 
msgLogDef fc_msgBlk0104 = {
          FC_LOG_MSG_EL_0104,
          fc_mes0104,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0105
message:  ELS completion
descript: Adapter has notified the driver of ELS command completion.
data:     (1) ulpCommand (2) ulpIoTag (3) ulpStatus (4) ulpWord[4]
severity: Information
log:      LOG_ELS verbose
module:   fcelsb.c
action:   None required.
*/
char      fc_mes0105[] = "%sELS completion Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0105 = {
          FC_LOG_MSG_EL_0105,
          fc_mes0105,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0106
message:  Unknown ELS command <elsCmd>
descript: Received an unknown ELS command completion.
data:     None
severity: Error
log:      Always
module:   fcelsb.c
action:   This error could indicate a software driver or firmware 
          problem. If problems persist report these errors to 
          Technical Support.
*/
char      fc_mes0106[] = "%sUnknown ELS command x%x"; 
msgLogDef fc_msgBlk0106 = {
          FC_LOG_MSG_EL_0106,
          fc_mes0106,
          fc_msgPreambleELe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0107
message:  ELS command completion error
descript: A driver initiated ELS command completed with an error status.
data:     (1) ulpCommand (2) ulpStatus (3) ulpWord[4] (4) ulpWord[5]
severity: Information
log:      LOG_ELS verbose
module:   fcelsb.c
action:   None required
*/
char      fc_mes0107[] = "%sELS command completion error Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0107 = {
          FC_LOG_MSG_EL_0107,
          fc_mes0107,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0108
message:  ELS response completion error
descript: An ELS response sent in response to a received ELS command 
          completed with an error status.
data:     (1) ulpCommand (2) ulpStatus (3) ulpWord[4] (4) ulpWord[5]
severity: Information
log:      LOG_ELS verbose
module:   fcelsb.c
action:   None required.
*/
char      fc_mes0108[] = "%sELS response completion error Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0108 = {
          FC_LOG_MSG_EL_0108,
          fc_mes0108,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0109
message:  ELS response completion
descript: An ELS response sent in response to a received ELS command 
          completed successfully.
data:     (1) nlp_DID (2) nlp_type (3) nlp_flag (4) nlp_state
severity: Information
log:      LOG_ELS verbose
module:   fcelsb.c
action:   None required
*/
char      fc_mes0109[] = "%sELS response completion Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0109 = {
          FC_LOG_MSG_EL_0109,
          fc_mes0109,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0110
message:  ELS command completion error 
descript: Adapter has notified the driver of ELS command completion.
data:     (1) command (2) ulpStatus (3) ulpWord[4] (4) ulpWord[5]
severity: Information
log:      LOG_ELS verbose
module:   fcelsb.c
action:   None required
*/
char      fc_mes0110[] = "%sELS command completion error Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0110 = {
          FC_LOG_MSG_EL_0110,
          fc_mes0110,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0111
message:  Unknown ELS command <elsCmd>
descript: Received an unknown ELS command completion.
data:     None
severity: Error
log:      Always
module:   fcelsb.c
action:   This error could indicate a software driver or firmware 
          problem. If problems persist report these errors to 
          Technical Support.
*/
char      fc_mes0111[] = "%sUnknown ELS command x%x"; 
msgLogDef fc_msgBlk0111 = {
          FC_LOG_MSG_EL_0111,
          fc_mes0111,
          fc_msgPreambleELe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0112
message:  PLOGI completes successfully
descript: A PLOGI to a Fibre Channel NPORT completed successfully
data:     (1) remoteID (2) ulpWord[4] (3) ulpWord[5] (4) fc_ffstate
severity: Information
log:      LOG_ELS verbose
module:   fcelsb.c
action:   None required
*/
char      fc_mes0112[] = "%sPLOGI completes successfully Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0112 = {
          FC_LOG_MSG_EL_0112,
          fc_mes0112,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0113
message:  PRLI completes successfully
descript: A PRLI to a FCP target completed successfully. 
data:     (1) remoteID (2) ulpWord[4] (3) ulpWord[5] (4) fc_ffstate
severity: Information
log:      LOG_ELS & LOG_DISCOVERY verbose
module:   fcelsb.c
action:   None required.
*/
char      fc_mes0113[] = "%sPRLI completes successfully Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0113 = {
          FC_LOG_MSG_EL_0113,
          fc_mes0113,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS | LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0114
message:  PRLO completes successfully
descript: A PRLO to a FCP target completed successfully. 
data:     (1) remoteID (2) ulpWord[4] (3) ulpWord[5] (4) fc_ffstate
severity: Information
severity: Information
log:      LOG_ELS ELS & LOG_DISCOVERY verbose
module:   fcelsb.c
action:   None required.
*/
char      fc_mes0114[] = "%sPRLO completes successfully Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0114 = {
          FC_LOG_MSG_EL_0114,
          fc_mes0114,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0115
message:  LOGO completes successfully
descript: A LOGO to a FCP target completed successfully. 
data:     (1) remoteID (2) ulpWord[4] (3) ulpWord[5] (4) fc_ffstate
severity: Information
log:      LOG_ELS ELS & LOG_DISCOVERY verbose
module:   fcelsb.c
action:   None required.
*/
char      fc_mes0115[] = "%sLOGO completes successfully Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0115 = {
          FC_LOG_MSG_EL_0115,
          fc_mes0115,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0116
message:  PDISC completes successfully
descript: A PDISC to a FCP target completed successfully. 
data:     (1) remoteID (2) ulpWord[4] (3) ulpWord[5] (4) fc_ffstate
severity: Information
log:      LOG_ELS ELS & LOG_DISCOVERY verbose
module:   fcelsb.c
action:   None required.
*/
char      fc_mes0116[] = "%sPDISC completes successfully Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0116 = {
          FC_LOG_MSG_EL_0116,
          fc_mes0116,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0117
message:  ADISC completes successfully
descript: A ADISC to a FCP target completed successfully. 
data:     (1) remoteID (2) ulpWord[4] (3) ulpWord[5] (4) fc_ffstate
severity: Information
log:      ELS or LOG_DISCOVERY verbose
module:   fcelsb.c
action:   None required.
*/
char      fc_mes0117[] = "%sADISC completes successfully Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0117 = {
          FC_LOG_MSG_EL_0117,
          fc_mes0117,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0118
message:  FARP completes successfully
descript: A FARP completed successfully. 
data:     (1) remoteID (2) ulpWord[4] (3) ulpWord[5] (4) command
severity: Information
log:      LOG_ELS verbose
module:   fcelsb.c
action:   None required.
*/
char      fc_mes0118[] = "%sFARP completes successfully Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0118 = {
          FC_LOG_MSG_EL_0118,
          fc_mes0118,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0119
message:  SCR completes successfully
descript: A SCR completed successfully. 
data:     (1) remoteID (2) ulpWord[4] (3) ulpWord[5] (4) fc_ffstate
severity: Information
log:      LOG_ELS verbose
module:   fcelsb.c
action:   None required.
*/
char      fc_mes0119[] = "%sSCR completes successfully Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0119 = {
          FC_LOG_MSG_EL_0119,
          fc_mes0119,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0120
message:  RNID completes successfully
descript: A RNID completed successfully. 
data:     (1) remoteID (2) ulpWord[4] (3) ulpWord[5] (4) fc_ffstate
severity: Information
log:      LOG_ELS verbose
module:   fcelsb.c
action:   None required.
*/
char      fc_mes0120[] = "%sRNID completes successfully Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0120 = {
          FC_LOG_MSG_EL_0120,
          fc_mes0120,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0121
message:  Unknown ELS command <elsCmd> completed
descript: Received an unknown ELS command completion.
data:     None
severity: Error
log:      Always
module:   fcelsb.c
action:   This error could indicate a software driver or firmware 
          problem. If problems persist report these errors to 
          Technical Support.
*/
char      fc_mes0121[] = "%sUnknown ELS command x%x completed"; 
msgLogDef fc_msgBlk0121 = {
          FC_LOG_MSG_EL_0121,
          fc_mes0121,
          fc_msgPreambleELe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0122
message:  Unknown ELS IOCB
descript: An unknown IOCB command completed in the ELS ring
data:     (1) ulpCommand
severity: Error
log:      Always
module:   fcelsb.c
action:   This error could indicate a software driver or firmware 
          problem. If problems persist report these errors to 
          Technical Support.
*/
char      fc_mes0122[] = "%sUnknown ELS IOCB Data: x%x"; 
msgLogDef fc_msgBlk0122 = {
          FC_LOG_MSG_EL_0122,
          fc_mes0122,
          fc_msgPreambleELe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0123
message:  Received ELS command <elsCmd>
descript: An ELS command was received.
data:     (1) ulpWord[5] (2) ulpStatus (3) fc_ffstate
severity: Information
log:      LOG_ELS verbose
module:   fcelsb.c
action:   None required
*/
char      fc_mes0123[] = "%sReceived ELS command x%x Data: x%x x%x x%x"; 
msgLogDef fc_msgBlk0123 = {
          FC_LOG_MSG_EL_0123,
          fc_mes0123,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0124
message:  An FLOGI ELS command <elsCmd> was received from DID <did> in Loop Mode
descript: While in Loop Mode an unknown or unsupported ELS commnad 
          was received.
data:     None
severity: Error
log:      Always
module:   fcelsb.c
action:   Check device DID
*/
char      fc_mes0124[] = "%sAn FLOGI ELS command x%x was received from DID x%x in Loop Mode"; 
msgLogDef fc_msgBlk0124 = {
          FC_LOG_MSG_EL_0124,
          fc_mes0124,
          fc_msgPreambleELe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0125
message:  Received PLOGI command
descript: A PLOGI command was received.
data:     (1) nlp_DID (2) nlp_state (3) nlp_flag (4) nlp_Rpi
severity: Information
log:      LOG_ELS verbose
module:   fcelsb.c
action:   None required
*/
char      fc_mes0125[] = "%sReceived PLOGI command Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0125 = {
          FC_LOG_MSG_EL_0125,
          fc_mes0125,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0126
message:  PLOGI chkparm OK
descript: Received a PLOGI from a remote NPORT and its Fibre Channel service 
          parameters match this HBA. Request can be accepted.
data:     (1) nlp_DID (2) nlp_state (3) nlp_flag (4) nlp_Rpi
severity: Information
log:      LOG_ELS verbose
module:   fcelsb.c
action:   None required
*/
char      fc_mes0126[] = "%sPLOGI chkparm OK Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0126 = {
          FC_LOG_MSG_EL_0126,
          fc_mes0126,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0127
message:  Unknown ELS command <elsCmd> received from NPORT <did> 
descript: Received an unsupported ELS command from a remote NPORT.
data:     None
severity: Error
log:      Always
module:   fcelsb.c
action:   Check remote NPORT for potential problem.
*/
char      fc_mes0127[] = "%sUnknown ELS command x%x received from NPORT x%x"; 
msgLogDef fc_msgBlk0127 = {
          FC_LOG_MSG_EL_0127,
          fc_mes0127,
          fc_msgPreambleELe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0128
message:  Xmit unknown ELS command <elsCmd>
descript: The Fibre Channel driver is attempting to send an 
          unsupported or unknown ELS command. 
data:     None
severity: Error
log:      Always
module:   fcelsb.c
action:   This error could indicate a software driver or firmware 
          problem. If problems persist report these errors to 
          Technical Support.
*/
char      fc_mes0128[] = "%sXmit unknown ELS command x%x"; 
msgLogDef fc_msgBlk0128 = {
          FC_LOG_MSG_EL_0128,
          fc_mes0128,
          fc_msgPreambleELe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0129
message:  Xmit ELS command <elsCmd> to remote NPORT <did>
descript: Xmit ELS command to remote NPORT 
data:     (1) icmd->ulpIoTag (2) binfo->fc_ffstate
severity: Information
log:      LOG_ELS verbose
module:   fcelsb.c
action:   None required
*/
char      fc_mes0129[] = "%sXmit ELS command x%x to remote NPORT x%x Data: x%x x%x"; 
msgLogDef fc_msgBlk0129 = {
          FC_LOG_MSG_EL_0129,
          fc_mes0129,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0130
message:  Xmit unknown ELS response (elsCmd>
descript: The Fibre Channel driver is attempting to send an 
          unsupported or unknown ELS response. 
data:     None
severity: Error
log:      Always
module:   fcelsb.c
action:   This error could indicate a software driver or firmware 
          problem. If problems persist report these errors to 
          Technical Support.
*/
char      fc_mes0130[] = "%sXmit unknown ELS response x%x"; 
msgLogDef fc_msgBlk0130 = {
          FC_LOG_MSG_EL_0130,
          fc_mes0130,
          fc_msgPreambleELe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0131
message:  Xmit ELS response <elsCmd> to remote NPORT <did>
descript: Xmit ELS response to remote NPORT 
data:     (1) icmd->ulpIoTag (2) size
severity: Information
log:      LOG_ELS verbose
module:   fcelsb.c
action:   None required
*/
char      fc_mes0131[] = "%sXmit ELS response x%x to remote NPORT x%x Data: x%x x%x"; 
msgLogDef fc_msgBlk0131 = {
          FC_LOG_MSG_EL_0131,
          fc_mes0131,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0132
message:  ELS Retry failed
descript: If an ELS command fails, it may be retried up 
          to 3 times. This message will be recorded if 
          the driver gives up retrying a specific ELS 
          command.
data:     (1) ELS command, (2) remote PortID
severity: Information
log:      LOG_ELS verbose
module:   fcelsb.c
action:   If the ELS command is a PRLI, and the destination 
          PortID is not an FCP Target, no action is required. 
          Otherwise, check physical connections to Fibre 
          Channel network and the state of the remote PortID.
*/
char      fc_mes0132[] = "%sELS Retry failed Data: x%x x%x"; 
msgLogDef fc_msgBlk0132 = {
          FC_LOG_MSG_EL_0132,
          fc_mes0132,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };
          
/*
msgName: fc_mes0133
message:  Xmit CT response on exchange <xid>
descript: Xmit a CT response on the appropriate exchange.
data:     (1) ulpIoTag (2) fc_ffstate
severity: Information
log:      LOG_ELS verbose
module:   fcelsb.c
action:   None required
*/
char      fc_mes0133[] = "%sXmit CT response on exchange x%x Data: x%x x%x"; 
msgLogDef fc_msgBlk0133 = {
          FC_LOG_MSG_EL_0133,
          fc_mes0133,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };
          
/*
msgName: fc_mes0134
message:  Issue GEN REQ IOCB for NPORT <did>
descript: Issue a GEN REQ IOCB for remote NPORT.  These are typically
          used for CT request. 
data:     (1) ulpIoTag (2) fc_ffstate
severity: Information
log:      LOG_ELS verbose
module:   fcelsb.c
action:   None required
*/
char      fc_mes0134[] = "%sIssue GEN REQ IOCB for NPORT x%x Data: x%x x%x"; 
msgLogDef fc_msgBlk0134 = {
          FC_LOG_MSG_EL_0134,
          fc_mes0134,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0135
message:  Issue GEN REQ IOCB for RNID
descript: Issue a GEN REQ IOCB to support an ELS RNID command
data:     (1) ulpWord[5] (2) ulpIoTag (3) fc_ffstate
severity: Information
log:      LOG_ELS verbose
module:   fcelsb.c
action:   None required
*/
char      fc_mes0135[] = "%sIssue GEN REQ IOCB for RNID Data: x%x x%x x%x"; 
msgLogDef fc_msgBlk0135 = {
          FC_LOG_MSG_EL_0135,
          fc_mes0135,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0136
message:  Delayxmit ELS command <cmd> timeout
descript: The delay for issuing an ELS command has expired. The ELS 
          command is queued to HBA to be xmitted. 
data:     (1) ulpIoTag (2) retry (3) remoteID
severity: Information
log:      LOG_ELS verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0136[] = "%sDelayxmit ELS command x%x timeout Data: x%x x%x x%x"; 
msgLogDef fc_msgBlk0136 = {
          FC_LOG_MSG_EL_0136,
          fc_mes0136,
          fc_msgPreambleELi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_ELS,
          ERRID_LOG_TIMEOUT };

/*
 *  Begin DSCOVERY LOG Message Structures
 */

/*
msgName: fc_mes0200
message:  Device Discovery Started
descript: Device discovery / rediscovery after FLOGI or FAN has started.
data:     None
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0200[] = "%sDevice Discovery Started"; 
msgLogDef fc_msgBlk0200 = {
          FC_LOG_MSG_DI_0200,
          fc_mes0200,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0201
message:  Device Discovery completion error
descript: This indicates an uncorrectable error was encountered 
          during device (re)discovery after a link up. Fibre 
          Channel devices will not be accessible if this message 
          is displayed.
data:     None
severity: Error
log:      Always
module:   fcrpib.c
action:   Reboot system. If problem persists, contact Technical 
          Support. Run with verbose mode on for more details.
*/
char      fc_mes0201[] = "%sDevice Discovery completion error"; 
msgLogDef fc_msgBlk0201 = {
          FC_LOG_MSG_DI_0201,
          fc_mes0201,
          fc_msgPreambleDIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0202
message:  Device Discovery Started
descript: Device discovery / rediscovery after FLOGI or FAN has started.
data:     None
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0202[] = "%sDevice Discovery Started"; 
msgLogDef fc_msgBlk0202 = {
          FC_LOG_MSG_DI_0202,
          fc_mes0202,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };
          
/*
msgName: fc_mes0203
message:  Device Discovery continues
descript: Device discovery in process
data:     (1) firstndlp (2) fc_ffstate
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0203[] = "%sDevice Discovery continues Data: x%x x%x"; 
msgLogDef fc_msgBlk0203 = {
          FC_LOG_MSG_DI_0203,
          fc_mes0203,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0204
message:  Device Discovery completion error
descript: This indicates an uncorrectable error was encountered 
          during device (re)discovery after a link up. Fibre 
          Channel devices will not be accessible if this message 
          is displayed.
data:     None
severity: Error
log:      Always
module:   fcrpib.c
action:   Reboot system. If problem persists, contact Technical 
          Support. Run with verbose mode on for more details.
*/
char      fc_mes0204[] = "%sDevice Discovery completion error"; 
msgLogDef fc_msgBlk0204 = {
          FC_LOG_MSG_DI_0204,
          fc_mes0204,
          fc_msgPreambleDIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };
 
/*
msgName: fc_mes0205
message:  Device Discovery authentication
descript: The driver has marked NPORTs in its none table that require ADISC
          for authentication.
data:     (1) cnt (2) cnt1 (3) cnt2
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0205[] = "%sDevice Discovery authentication Data: x%x x%x x%x"; 
msgLogDef fc_msgBlk0205 = {
          FC_LOG_MSG_DI_0205,
          fc_mes0205,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0206
message:  Device Discovery completion error
descript: This indicates an uncorrectable error was encountered 
          during device (re)discovery after a link up. Fibre 
          Channel devices will not be accessible if this message 
          is displayed.
data:     (1) ulpStatus (2) ulpWord[4] (3) ulpWord[5]
severity: Error
log:      Always
module:   fcelsb.c
action:   Reboot system. If problem persists, contact Technical 
          Support. Run with verbose mode on for more details.
*/
char      fc_mes0206[] = "%sDevice Discovery completion error Data: x%x x%x x%x"; 
msgLogDef fc_msgBlk0206 = {
          FC_LOG_MSG_DI_0206,
          fc_mes0206,
          fc_msgPreambleDIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0207
message:  Device Discovery completion error
descript: This indicates an uncorrectable error was encountered 
          during device (re)discovery after a link up. Fibre 
          Channel devices will not be accessible if this message 
          is displayed.
data:     None
severity: Error
log:      Always
module:   fcelsb.c
action:   Reboot system. If problem persists, contact Technical 
          Support. Run with verbose mode on for more details.
*/
char      fc_mes0207[] = "%sDevice Discovery completion error"; 
msgLogDef fc_msgBlk0207 = {
          FC_LOG_MSG_DI_0207,
          fc_mes0207,
          fc_msgPreambleDIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0208
message:  FLOGI completes successfully
descript: Fabric Login completed successfully.
data:     (1) ulpWord[4] (2) e_d_tov (3) r_a_tov (4) edtovResolution
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcelsb.c
action:   None required.
*/
char      fc_mes0208[] = "%sFLOGI completes successfully Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0208 = {
          FC_LOG_MSG_DI_0208,
          fc_mes0208,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0209
message:  Device Discovery completes
descript: This indicates successful completion of device 
          (re)discovery after a link up. 
data:     None
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcelsb.c
action:   None required
*/
char      fc_mes0209[] = "%sDevice Discovery completes"; 
msgLogDef fc_msgBlk0209 = {
          FC_LOG_MSG_DI_0209,
          fc_mes0209,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0210
message:  PRLI target assigned
descript: The driver has assigned a SCSI ID to the FCP target.
data:     (1) ulpWord[5] (2) nlp_pan (3) nlp_sid
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcelsb.c
action:   None required
*/
char      fc_mes0210[] = "%sPRLI target assigned Data: x%x x%x x%x"; 
msgLogDef fc_msgBlk0210 = {
          FC_LOG_MSG_DI_0210,
          fc_mes0210,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0211
message:  Received RSCN command
descript: The driver has received an RSCN command from the fabric. This 
          indicates a device was potentially added or removed from the 
          Fibre Channel network.
data:     (1) fc_flag (2) defer_rscn.q_cnt (3) fc_rscn.q_cnt (4) fc_mbox_active
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcelsb.c
action:   None required
*/
char      fc_mes0211[] = "%sReceived RSCN command Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0211 = {
          FC_LOG_MSG_DI_0211,
          fc_mes0211,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0212
message:  Device Discovery completes
descript: This indicates successful completion of device 
          (re)discovery after a link up. 
data:     None
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcelsb.c
action:   None required
*/
char      fc_mes0212[] = "%sDevice Discovery completes"; 
msgLogDef fc_msgBlk0212 = {
          FC_LOG_MSG_DI_0212,
          fc_mes0212,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0213
message:  FAN received
descript: A FAN ELS command was received from a Fabric.
data:     (1) ulpWord[4] (2) fc_ffstate
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcelsb.c
action:   None required.
*/
char      fc_mes0213[] = "%sFAN received Data: x%x x%x"; 
msgLogDef fc_msgBlk0213 = {
          FC_LOG_MSG_DI_0213,
          fc_mes0213,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0214
message:  RSCN received
descript: A RSCN ELS command was received from a Fabric. 
data:     (1) fc_flag (2) i (3) *lp (4) fc_rscn_id_cnt
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcelsb.c
action:   None required.
*/
char      fc_mes0214[] = "%sRSCN received Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0214 = {
          FC_LOG_MSG_DI_0214,
          fc_mes0214,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0215
message:  RSCN processed
descript: A RSCN ELS command was received from a Fabric and processed.
data:     (1) fc_flag (2) cnt (3) fc_rscn_id_cnt (4) fc_ffstate
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcelsb.c
action:   None required.
*/
char      fc_mes0215[] = "%sRSCN processed Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0215 = {
          FC_LOG_MSG_DI_0215,
          fc_mes0215,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0216
message:  Unknown Identifier in RSCN payload
descript: Typically the identifier in the RSCN payload specifies 
          a domain, area or a specific NportID. If neither of 
          these are specified, a warning will be recorded. 
data:     (1) didp->un.word
severity: Error
log:      Always
module:   fcelsb.c
action:   Potential problem with Fabric. Check with Fabric vendor.
*/
char      fc_mes0216[] = "%sUnknown Identifier in RSCN payload Data: x%x"; 
msgLogDef fc_msgBlk0216 = {
          FC_LOG_MSG_DI_0216,
          fc_mes0216,
          fc_msgPreambleDIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0217
message:  Device Discovery completion error
descript: This indicates an uncorrectable error was encountered 
          during device (re)discovery after a link up. Fibre 
          Channel devices will not be accessible if this message 
          is displayed.
data:     None
severity: Error
log:      Always
module:   fcelsb.c
action:   Reboot system. If problem persists, contact Technical 
          Support. Run with verbose mode on for more details.
*/
char      fc_mes0217[] = "%sDevice Discovery completion error"; 
msgLogDef fc_msgBlk0217 = {
          FC_LOG_MSG_DI_0217,
          fc_mes0217,
          fc_msgPreambleDIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0218
message:  FDMI Request
descript: The driver is sending an FDMI request to the fabric.
data:     (1) cmdcode (2) fc_flag
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcelsb.c
action:   None required.
*/
char      fc_mes0218[] = "%sFDMI Req Data: x%x x%x"; 
msgLogDef fc_msgBlk0218 = {
          FC_LOG_MSG_DI_0218,
          fc_mes0218,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };


/*
msgName: fc_mes0219
message:  Issue FDMI request failed
descript: Cannot issue FDMI request to HBA.
data:     (1) SLI_MGMT_DPRT
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0219[] = "%sIssue FDMI request failed Data: x%x"; 
msgLogDef fc_msgBlk0219 = {
          FC_LOG_MSG_DI_0219,
          fc_mes0219,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0220
message:  Device Discovery completion error
descript: This indicates an uncorrectable error was encountered 
          during device (re)discovery after a link up. Fibre 
          Channel devices will not be accessible if this message 
          is displayed.
data:     None
severity: Error
log:      Always
module:   fcscsib.c
action:   Reboot system. If problem persists, contact Technical 
          Support. Run with verbose mode on for more details.
*/
char      fc_mes0220[] = "%sDevice Discovery completion error"; 
msgLogDef fc_msgBlk0220 = {
          FC_LOG_MSG_DI_0220,
          fc_mes0220,
          fc_msgPreambleDIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0221
message:  FAN timeout
descript: A link up event was received without the login bit set, 
          so the driver waits E_D_TOV for the Fabric to send a FAN. 
          If no FAN if received, a FLOGI will be sent after the timeout. 
data:     None
severity: Warning
log:      LOG_DISCOVERY verbose
module:   fcscsib.c
action:   None required. The driver recovers from this condition by 
          issuing a FLOGI to the Fabric.
*/
char      fc_mes0221[] = "%sFAN timeout"; 
msgLogDef fc_msgBlk0221 = {
          FC_LOG_MSG_DI_0221,
          fc_mes0221,
          fc_msgPreambleDIw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_DISCOVERY,
          ERRID_LOG_TIMEOUT };

/*
msgName: fc_mes0222
message:  Initial FLOGI timeout
descript: The driver is sending initial FLOGI to fabric.
data:     None
severity: Error
log:      Always
module:   fcscsib.c
action:   Check Fabric configuration. The driver recovers from this and 
          continues with device discovery.
*/
char      fc_mes0222[] = "%sInitial FLOGI timeout"; 
msgLogDef fc_msgBlk0222 = {
          FC_LOG_MSG_DI_0222,
          fc_mes0222,
          fc_msgPreambleDIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_DISCOVERY,
          ERRID_LOG_TIMEOUT };

/*
msgName: fc_mes0223
message:  NameServer Registration timeout
descript: Our registration request to the Fabric was not acknowledged 
          within RATOV.
data:     (1) fc_ns_retry (2) fc_max_ns_retry
severity: Error
log:      Always
module:   fcscsib.c
action:   Check Fabric configuration. The driver recovers from this and 
          continues with device discovery.
*/
char      fc_mes0223[] = "%sNameServer Registration timeout Data: x%x x%x"; 
msgLogDef fc_msgBlk0223 = {
          FC_LOG_MSG_DI_0223,
          fc_mes0223,
          fc_msgPreambleDIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_DISCOVERY,
          ERRID_LOG_TIMEOUT };

/*
msgName: fc_mes0224
message:  NameServer Query timeout
descript: Node authentication timeout, node Discovery timeout. A NameServer 
          Query to the Fabric or discovery of reported remote NPorts is not 
          acknowledged within R_A_TOV. 
data:     (1) fc_ns_retry (2) fc_max_ns_retry
severity: Error
log:      Always
module:   fcscsib.c
action:   Check Fabric configuration. The driver recovers from this and 
          continues with device discovery.
*/
char      fc_mes0224[] = "%sNameServer Query timeout Data: x%x x%x"; 
msgLogDef fc_msgBlk0224 = {
          FC_LOG_MSG_DI_0224,
          fc_mes0224,
          fc_msgPreambleDIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_DISCOVERY,
          ERRID_LOG_TIMEOUT };

/*
msgName: fc_mes0225
message:  Device Discovery completes
descript: This indicates successful completion of device 
          (re)discovery after a link up. 
data:     None
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0225[] = "%sDevice Discovery completes"; 
msgLogDef fc_msgBlk0225 = {
          FC_LOG_MSG_DI_0225,
          fc_mes0225,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0226
message:  Device Discovery completion error
descript: This indicates an uncorrectable error was encountered 
          during device (re)discovery after a link up. Fibre 
          Channel devices will not be accessible if this message 
          is displayed.
data:     None
severity: Error
log:      Always
module:   fcscsib.c
action:   Reboot system. If problem persists, contact Technical 
          Support. Run with verbose mode on for more details.
*/
char      fc_mes0226[] = "%sDevice Discovery completion error"; 
msgLogDef fc_msgBlk0226 = {
          FC_LOG_MSG_DI_0226,
          fc_mes0226,
          fc_msgPreambleDIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0227
message:  Node Authentication timeout
descript: The driver has lost track of what NPORTs are being authenticated.
data:     None
severity: Error
log:      Always
module:   fcscsib.c
action:   None required. Driver should recover from this event.
*/
char      fc_mes0227[] = "%sNode Authentication timeout"; 
msgLogDef fc_msgBlk0227 = {
          FC_LOG_MSG_DI_0227,
          fc_mes0227,
          fc_msgPreambleDIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_DISCOVERY,
          ERRID_LOG_TIMEOUT };

/*
msgName: fc_mes0228
message:  Node Discovery timeout
descript: The driver has lost track of what NPORTs are being discovered.
data:     None
severity: Error
log:      Always
module:   fcscsib.c
action:   None required. Driver should recover from this event.
*/
char      fc_mes0228[] = "%sNode Discovery timeout"; 
msgLogDef fc_msgBlk0228 = {
          FC_LOG_MSG_DI_0228,
          fc_mes0228,
          fc_msgPreambleDIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_DISCOVERY,
          ERRID_LOG_TIMEOUT };

/*
msgName: fc_mes0229
message:  Node Discovery timeout
descript: The driver has lost track of what NPORTs are being discovered.
data:     (1) nlp_DID (2) nlp_flag (3) nlp_state (4) nlp_type
severity: Error
log:      Always
module:   fcscsib.c
action:   None required. Driver should recover from this event.
*/
char      fc_mes0229[] = "%sNode Discovery timeout Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0229 = {
          FC_LOG_MSG_DI_0229,
          fc_mes0229,
          fc_msgPreambleDIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_DISCOVERY,
          ERRID_LOG_TIMEOUT };

/*
msgName: fc_mes0230
message:  Device Discovery completion error
descript: This indicates an uncorrectable error was encountered 
          during device (re)discovery after a link up. Fibre 
          Channel devices will not be accessible if this message 
          is displayed.
data:     None
severity: Error
log:      Always
module:   fcscsib.c
action:   Reboot system. If problem persists, contact Technical 
          Support. Run with verbose mode on for more details.
*/
char      fc_mes0230[] = "%sDevice Discovery completion error"; 
msgLogDef fc_msgBlk0230 = {
          FC_LOG_MSG_DI_0230,
          fc_mes0230,
          fc_msgPreambleDIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0231
message:  RSCN timeout
descript: The driver has lost track of what NPORTs have RSCNs pending.
data:     (1) fc_ns_retry (2) fc_max_ns_retry
severity: Error
log:      Always
module:   fcscsib.c
action:   None required. Driver should recover from this event.
*/
char      fc_mes0231[] = "%sRSCN timeout Data: x%x x%x"; 
msgLogDef fc_msgBlk0231 = {
          FC_LOG_MSG_DI_0231,
          fc_mes0231,
          fc_msgPreambleDIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_DISCOVERY,
          ERRID_LOG_TIMEOUT };

/*
msgName: fc_mes0232
message:  Node RSCN timeout
descript: The driver is cleaning up the node table entry for a node
          that had a pending RSCN.
data:     (1) nlp_DID (2) nlp_flag (3) nlp_state (4) nlp_type
severity: Error
log:      Always
module:   fcscsib.c
action:   None required. Driver should recover from this event.
*/
char      fc_mes0232[] = "%sNode RSCN timeout Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0232 = {
          FC_LOG_MSG_DI_0232,
          fc_mes0232,
          fc_msgPreambleDIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_DISCOVERY,
          ERRID_LOG_TIMEOUT };

/*
msgName: fc_mes0233
message:  PT2PT link up timeout
descript: A PLOGI has not been received, within R_A_TOV, after a 
          successful FLOGI, which indicates our topology is 
          point-to-point with another NPort. Typically this PLOGI 
          is used to assign a NPortID.
data:     None           
severity: Warning
log:      LOG_DISCOVERY verbose
module:   fcscsib.c
action:   None required. Driver will recover by configuring NPortID as 0.
*/
char      fc_mes0233[] = "%sPT2PT link up timeout"; 
msgLogDef fc_msgBlk0233 = {
          FC_LOG_MSG_DI_0233,
          fc_mes0233,
          fc_msgPreambleDIw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_DISCOVERY,
          ERRID_LOG_TIMEOUT };

/*
msgName: fc_mes0234
message:  Device Discovery completes
descript: This indicates successful completion of device 
          (re)discovery after a link up. 
data:     None
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0234[] = "%sDevice Discovery completes"; 
msgLogDef fc_msgBlk0234 = {
          FC_LOG_MSG_DI_0234,
          fc_mes0234,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0235
message:  Device Discovery completion error
descript: This indicates an uncorrectable error was encountered 
          during device (re)discovery after a link up. Fibre 
          Channel devices will not be accessible if this message 
          is displayed.
data:     None
severity: Error
log:      Always
module:   fcscsib.c
action:   Reboot system. If problem persists, contact Technical 
          Support. Run with verbose mode on for more details.
*/
char      fc_mes0235[] = "%sDevice Discovery completion error"; 
msgLogDef fc_msgBlk0235 = {
          FC_LOG_MSG_DI_0235,
          fc_mes0235,
          fc_msgPreambleDIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0236
message:  NameServer Req
descript: The driver is issuing a nameserver request to the fabric.
data:     (1) cmdcode (2) fc_flag (3) fc_rscn_id_cnt
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0236[] = "%sNameServer Req Data: x%x x%x x%x"; 
msgLogDef fc_msgBlk0236 = {
          FC_LOG_MSG_DI_0236,
          fc_mes0236,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0237
message:  Unknown Identifier in RSCN list
descript: A RSCN list entry contains an unknown identifier.
data:     (1) rscn_did.un.word
severity: Error
log:      Always
module:   fcscsib.c
action:   Potential problem with Fabric. Check with Fabric vendor.
*/
char      fc_mes0237[] = "%sUnknown Identifier in RSCN list Data: x%x"; 
msgLogDef fc_msgBlk0237 = {
          FC_LOG_MSG_DI_0237,
          fc_mes0237,
          fc_msgPreambleDIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0238
message:  NameServer Rsp
descript: The driver received a nameserver response.
data:     (1) Did (2) nlp_flag (3) fc_flag (4) fc_rscn_id_cnt
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0238[] = "%sNameServer Rsp Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0238 = {
          FC_LOG_MSG_DI_0238,
          fc_mes0238,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0239
message:  NameServer Rsp
descript: The driver received a nameserver response.
data:     (1) Did (2) ndlp (3) fc_flag (4) fc_rscn_id_cnt
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0239[] = "%sNameServer Rsp Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0239 = {
          FC_LOG_MSG_DI_0239,
          fc_mes0239,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0240
message:  NameServer Rsp Error
descript: The driver received a nameserver response containig a status error.
data:     (1) CommandResponse.bits.CmdRsp (2) ReasonCode (3) Explanation 
          (4) fc_flag
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcscsib.c
action:   Check Fabric configuration. The driver recovers from this and 
          continues with device discovery.
*/
char      fc_mes0240[] = "%sNameServer Rsp Error Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0240 = {
          FC_LOG_MSG_DI_0240,
          fc_mes0240,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0241
message:  NameServer Rsp Error
descript: The driver received a nameserver response containing a status error.
data:     (1) CommandResponse.bits.CmdRsp (2) ReasonCode (3) Explanation 
          (4) fc_flag
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcscsib.c
action:   Check Fabric configuration. The driver recovers from this and 
          continues with device discovery.
*/
char      fc_mes0241[] = "%sNameServer Rsp Error Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0241 = {
          FC_LOG_MSG_DI_0241,
          fc_mes0241,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0242
message:  Device Discovery nextnode
descript: The driver continuing with discovery.
data:     (1) nlp_state (2) nlp_DID (3) nlp_flag (4) fc_ffstate
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0242[] = "%sDevice Discovery nextnode Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0242 = {
          FC_LOG_MSG_DI_0242,
          fc_mes0242,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0243
message:  Device Discovery nextdisc
descript: The driver continuing with NPORT discovery.
data:     (1) fc_nlp_cnt (2) sndcnt (3) fc_mbox_active
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0243[] = "%sDevice Discovery nextdisc Data: x%x x%x x%x"; 
msgLogDef fc_msgBlk0243 = {
          FC_LOG_MSG_DI_0243,
          fc_mes0243,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0244
message:  Device Discovery completion error
descript: This indicates an uncorrectable error was encountered 
          during device (re)discovery after a link up. Fibre 
          Channel devices will not be accessible if this message 
          is displayed.
data:     None
severity: Error
log:      Always
module:   fcscsib.c
action:   Reboot system. If problem persists, contact Technical 
          Support. Run with verbose mode on for more details.
*/
char      fc_mes0244[] = "%sDevice Discovery completion error"; 
msgLogDef fc_msgBlk0244 = {
          FC_LOG_MSG_DI_0244,
          fc_mes0244,
          fc_msgPreambleDIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0245
message:  Device Discovery next authentication
descript: The driver is continuing with NPORT authentication.
data:     (1) fc_nlp_cnt (2) sndcnt (3) fc_mbox_active
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0245[] = "%sDevice Discovery next authentication Data: x%x x%x x%x"; 
msgLogDef fc_msgBlk0245 = {
          FC_LOG_MSG_DI_0245,
          fc_mes0245,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0246
message:  Device Discovery next RSCN
descript: The driver is continuing with RSCN processing. 
data:     (1) fc_nlp_cnt (2) sndcnt (3) fc_mbox_active (4) fc_flag
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0246[] = "%sDevice Discovery next RSCN Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0246 = {
          FC_LOG_MSG_DI_0246,
          fc_mes0246,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0247
message:  Discovery RSCN
descript: The number / type of RSCNs has forced the driver to go to 
          the nameserver and re-discover all NPORTs.
data:     (1) fc_defer_rscn.q_cnt (2) fc_flag (3) fc_rscn_disc_wdt
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0247[] = "%sDiscovery RSCN Data: x%x x%x x%x"; 
msgLogDef fc_msgBlk0247 = {
          FC_LOG_MSG_DI_0247,
          fc_mes0247,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0248
message:  Deferred RSCN
descript: The driver has received multiple RSCNs and has deferred the 
          processing of the most recent RSCN.
data:     (1) fc_defer_rscn.q_cnt (2) fc_flag
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0248[] = "%sDeferred RSCN Data: x%x x%x"; 
msgLogDef fc_msgBlk0248 = {
          FC_LOG_MSG_DI_0248,
          fc_mes0248,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0249
message:  Device Discovery completes
descript: This indicates successful completion of device 
          (re)discovery after a link up. 
data:     (1) fc_flag
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0249[] = "%sDevice Discovery completes Data: x%x"; 
msgLogDef fc_msgBlk0249 = {
          FC_LOG_MSG_DI_0249,
          fc_mes0249,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0250
message:  Pending Link Event during Discovery
descript: Received link event during discovery. Causes discovery restart.
data:     (1) ulpCommand (2) ulpIoTag (3) ulpStatus (4) ulpWord[4]
severity: Warning
log:      LOG_DISCOVERY verbose
module:   fcelsb.c
action:   None required unless problem persist. If problems persist, check 
          cabling.
*/
char      fc_mes0250[] = "%sPending Link Event during Discovery Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0250 = {
          FC_LOG_MSG_DI_0250,
          fc_mes0250,
          fc_msgPreambleDIw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0251
message:  FDMI rsp failed
descript: An error response was received to FDMI request
data:     (1) SWAP_DATA16(fdmi_cmd)
severity: Information
log:      LOG_DISCOVERY verbose
module:   fcelsb.c
action:   The fabric does not support FDMI, check fabric configuration.
*/
char      fc_mes0251[] = "%sFDMI rsp failed Data: x%x"; 
msgLogDef fc_msgBlk0251 = {
          FC_LOG_MSG_DI_0251,
          fc_mes0251,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0252
message:  EXPIRED RSCN disc timer
descript: The driver timed out when processing an RSCN command from the 
          fabric.
data:     (1) fc_flag
severity: Information
log:      LOG_DISCOVERY | LOG_ELS verbose
module:   fcscsib.c
action:   This error could indicate a software driver or firmware 
          problem. If problems persist report these errors to 
          Technical Support.
*/
char      fc_mes0252[] = "%sEXPIRED RSCN disc timer Data: x%x"; 
msgLogDef fc_msgBlk0252 = {
          FC_LOG_MSG_DI_0252,
          fc_mes0252,
          fc_msgPreambleDIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_DISCOVERY | LOG_ELS,
          ERRID_LOG_UNEXPECT_EVENT };

/*
 *  Begin MAILBOX LOG Message Structures
 */

/*
msgName: fc_mes0300
message:  READ_LA: no buffers
descript: The driver attempted to issue READ_LA mailbox command to the HBA
          but there were no buffer available.
data:     None
severity: Warning
log:      LOG_MBOX verbose
module:   fcmboxb.c
action:   This message indicates (1) a possible lack of memory resources. Try 
          increasing the lpfc 'num_bufs' configuration parameter to allocate 
          more buffers. (2) A possble driver buffer management problem. If 
          this problem persists, report these errors to Technical Support.
*/
char      fc_mes0300[] = "%sREAD_LA: no buffers"; 
msgLogDef fc_msgBlk0300 = {
          FC_LOG_MSG_MB_0300,
          fc_mes0300,
          fc_msgPreambleMBw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_MBOX,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0301
message:  READ_SPARAM: no buffers
descript: The driver attempted to issue READ_SPARAM mailbox command to the 
          HBA but there were no buffer available.
data:     None
severity: Warning
log:      LOG_MBOX verbose
module:   fcmboxb.c
action:   This message indicates (1) a possible lack of memory resources. Try 
          increasing the lpfc 'num_bufs' configuration parameter to allocate 
          more buffers. (2) A possble driver buffer management problem. If 
          this problem persists, report these errors to Technical Support.
*/
char      fc_mes0301[] = "%sREAD_SPARAM: no buffers";
msgLogDef fc_msgBlk0301 = {
          FC_LOG_MSG_MB_0301,
          fc_mes0301,
          fc_msgPreambleMBw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_MBOX,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0302
message:  REG_LOGIN: no buffers
descript: The driver attempted to issue REG_LOGIN mailbox command to the HBA
          but there were no buffer available.
data:     None
severity: Warning
log:      LOG_MBOX verbose
module:   fcmboxb.c
action:   This message indicates (1) a possible lack of memory resources. Try 
          increasing the lpfc 'num_bufs' configuration parameter to allocate 
          more buffers. (2) A possble driver buffer management problem. If 
          this problem persists, report these errors to Technical Support.
*/
char      fc_mes0302[] = "%sREG_LOGIN: no buffers Data x%x x%x";
msgLogDef fc_msgBlk0302 = {
          FC_LOG_MSG_MB_0302,
          fc_mes0302,
          fc_msgPreambleMBw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_MBOX,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0303
message:  Adapter initialization error, mbxCmd <cmd> READ_NVPARM, 
          mbxStatus <status>
descript: A mailbox command failed during initialization.
data:     None
severity: Error
log:      Always
module:   fcLINUX.c
action:   This error could indicate a hardware or firmware problem. If 
          problems persist report these errors to Technical Support.
*/
char      fc_mes0303[] = "%sAdapter init error, mbxCmd x%x READ_NVPARM, mbxStatus x%x";
msgLogDef fc_msgBlk0303 = {
          FC_LOG_MSG_MB_0303,
          fc_mes0303,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0304
message:  Stray Mailbox Interrupt, mbxCommand <cmd> mbxStatus <status>.
descript: Received a mailbox completion interrupt and there are no 
          outstanding mailbox commands.
data:     None
severity: Error
log:      Always
module:   lp6000.c
action:   This error could indicate a hardware or firmware problem. If 
          problems persist report these errors to Technical Support.
*/
char      fc_mes0304[] = "%sStray Mailbox Interrupt mbxCommand x%x mbxStatus x%x";
msgLogDef fc_msgBlk0304 = {
          FC_LOG_MSG_MB_0304,
          fc_mes0304,
          fc_msgPreambleMBe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_MBOX,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0305
message:  Mbox cmd cmpl error - RETRYing
descript: A mailbox command completed with an error status that causes the 
          driver to reissue the mailbox command.
data:     (1) mbxCommand (2) word0 (3) fc_ffstate (4) fc_flag
severity: Information
log:      LOG_MBOX verbose
module:   lp6000.c
action:   None required
*/
char      fc_mes0305[] = "%sMbox cmd cmpl error - RETRYing Data: x%x x%x x%x x%x";
msgLogDef fc_msgBlk0305 = {
          FC_LOG_MSG_MB_0305,
          fc_mes0305,
          fc_msgPreambleMBi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_MBOX,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0306
message:  Mbox cmd cmpl error
descript: A mailbox command completed with an error status. 
data:     (1) mbxCommand (2) word0 (3) ff_state (4) fc_flag
severity: Information
log:      LOG_MBOX verbose
module:   lp6000.c
action:   None required
*/
char      fc_mes0306[] = "%sMbox cmd cmpl error Data: x%x x%x x%x x%x";
msgLogDef fc_msgBlk0306 = {
          FC_LOG_MSG_MB_0306,
          fc_mes0306,
          fc_msgPreambleMBi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_MBOX,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0307
message:  Mbox cmd cmpl
descript: A mailbox command completed.. 
data:     (1) mbxCommand (2) word0 (3) ff_state (4) fc_flag
severity: Information
log:      LOG_MBOX verbose
module:   lp6000.c
action:   None required
*/
char      fc_mes0307[] = "%sMbox cmd cmpl Data: x%x x%x x%x x%x";
msgLogDef fc_msgBlk0307 = {
          FC_LOG_MSG_MB_0307,
          fc_mes0307,
          fc_msgPreambleMBi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_MBOX,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0308
message:  Mbox cmd issue - BUSY
descript: The driver attempted to issue a mailbox command while the mailbox 
          was busy processing the previous command. The processing of the 
          new command will be deferred until the mailbox becomes available.
data:     (1) mbxCommand (2) ff_state (3) fc_flag (4) flag
severity: Information
log:      LOG_MBOX verbose
module:   lp6000.c
action:   None required
*/
char      fc_mes0308[] = "%sMbox cmd issue - BUSY Data: x%x x%x x%x x%x";
msgLogDef fc_msgBlk0308 = {
          FC_LOG_MSG_MB_0308,
          fc_mes0308,
          fc_msgPreambleMBi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_MBOX,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0309
message:  Mailbox cmd <cmd> issue
descript: The driver is in the process of issuing a mailbox command.
data:     (1) ff_state (2) fc_flag (3) flag
severity: Information
log:      LOG_MBOX verbose
module:   lp6000.c
action:   None required
*/
char      fc_mes0309[] = "%sMailbox cmd x%x issue Data: x%x x%x x%x";
msgLogDef fc_msgBlk0309 = {
          FC_LOG_MSG_MB_0309,
          fc_mes0309,
          fc_msgPreambleMBi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_MBOX,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0310
message:  Mailbox command <cmd> timeout, status <status>
descript: A Mailbox command was posted to the adapter and did 
          not complete within 30 seconds.
data:     None
severity: Error
log:      Always
module:   fcscsib.c
action:   This error could indicate a software driver or firmware 
          problem. If no I/O is going through the adapter, reboot 
          the system. If these problems persist, report these 
          errors to Technical Support.
*/
char      fc_mes0310[] = "%sMailbox command x%x timeout, status x%x";
msgLogDef fc_msgBlk0310 = {
          FC_LOG_MSG_MB_0310,
          fc_mes0310,
          fc_msgPreambleMBe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_MBOX,
          ERRID_LOG_TIMEOUT };

/*
msgName: fc_mes0311
message:  REG_LOGIN cmpl
descript: REG LOGIN mailbox command completed successfully.
data:     (1) nlp_DID (2) nlp_state (3) nlp_flag (4) nlp_Rpi
severity: Information
log:      LOG_MBOX verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0311[] = "%sREG_LOGIN cmpl Data: x%x x%x x%x x%x";
msgLogDef fc_msgBlk0311 = {
          FC_LOG_MSG_MB_0311,
          fc_mes0311,
          fc_msgPreambleMBi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_MBOX,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0312
message:  Unknown Mailbox command <mbxCmd> completion
descript: An unsupported or illegal Mailbox command completed.
data:     None
severity: Error
log:      Always
module:   fcscsib.c
action:   This error could indicate a software driver or firmware 
          problem. If problems persist report these errors to 
          Technical Support.
*/
char      fc_mes0312[] = "%sUnknown Mailbox command x%x completion";
msgLogDef fc_msgBlk0312 = {
          FC_LOG_MSG_MB_0312,
          fc_mes0312,
          fc_msgPreambleMBe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_MBOX,
          ERRID_LOG_UNEXPECT_EVENT };

/*
 *  Begin INIT LOG Message Structures
 */

/*
msgName: fc_mes0400
message:  dfc_ioctl entry
descript: Entry point for processing diagnostic ioctl.
data:     (1) c_cmd (2) c_arg1 (3) c_arg2 (4) c_outsz
severity: Information
log:      LOG_INIT verbose
module:   dfcdd.c
action:   None required
*/
char      fc_mes0400[] = "%sdfc_ioctl entry Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0400 = {
          FC_LOG_MSG_IN_0400,
          fc_mes0400,
          fc_msgPreambleINi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_INIT,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0401
message:  dfc_ioctl exit
descript: Exit point for processing diagnostic ioctl.
data:     (1) rc (2) c_outsz (3) c_dataout
severity: Information
log:      LOG_INIT verbose
module:   dfcdd.c
action:   None required
*/
char      fc_mes0401[] = "%sdfc_ioctl exit Data: x%x x%x x%x"; 
msgLogDef fc_msgBlk0401 = {
          FC_LOG_MSG_IN_0401,
          fc_mes0401,
          fc_msgPreambleINi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_INIT,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0402
message:  dfc_data_alloc
descript: Allocating data buffer to process dfc ioct.
data:     (1) fc_dataout (2) fc_outsz
severity: Iniformation
log:      LOG_INIT verbose
module:   dfcdd.c
action:   None required
*/
char      fc_mes0402[] = "%sdfc_data_alloc Data: x%x x%x"; 
msgLogDef fc_msgBlk0402 = {
          FC_LOG_MSG_IN_0402,
          fc_mes0402,
          fc_msgPreambleINi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_INIT,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0403
message:  dfc_data_free
descript: Freeing data buffer to process dfc ioct.
data:     (1) fc_dataout (2) fc_outsz
severity: Information
log:      LOG_INIT verbose
module:   dfcdd.c
action:   None required
*/
char      fc_mes0403[] = "%sdfc_data_free Data: x%x x%x"; 
msgLogDef fc_msgBlk0403 = {
          FC_LOG_MSG_IN_0403,
          fc_mes0403,
          fc_msgPreambleINi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_INIT,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0404
message:  Service Level Interface (SLI) 1 selected
descript: A PART_SLIM (SLI1) mailbox command was issued. 
data:     None
severity: Information
log:      LOG_INIT verbose
module:   fcmboxb.c
action:   None required.
*/
char      fc_mes0404[] = "%sService Level Interface (SLI) 1 selected";
msgLogDef fc_msgBlk0404 = {
          FC_LOG_MSG_IN_0404,
          fc_mes0404,
          fc_msgPreambleINi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_INIT,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0405
message:  Service Level Interface (SLI) 2 selected
descript: A CONFIG_PORT (SLI2) mailbox command was issued. 
data:     None
severity: Information
log:      LOG_INIT verbose
module:   fcmboxb.c
action:   None required.
*/
char      fc_mes0405[] = "%sService Level Interface (SLI) 2 selected";
msgLogDef fc_msgBlk0405 = {
          FC_LOG_MSG_IN_0405,
          fc_mes0405,
          fc_msgPreambleINi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_INIT,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0406
message:  Memory Buffer Pool is below low water mark
descript: A driver memory buffer pool is low on buffers. 
data:     (1) seg (2) fc_lowmem (3) low
severity: Warning
log:      LOG_INIT verbose
module:   fcmemb.c
action:   None required. Driver will recover as buffers are returned to pool.
*/
char      fc_mes0406[] = "%sMem Buf Pool is below low water mark Data: x%x x%x x%x";
msgLogDef fc_msgBlk0406 = {
          FC_LOG_MSG_IN_0406,
          fc_mes0406,
          fc_msgPreambleINw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_INIT,
          ERRID_LOG_NO_RESOURCE };

/*
msgName: fc_mes0407
message:  Memory Buffer Pool is corrupted
descript: The buffer address received from the pool is outside 
          the range of the pool and is therefore corrupt.
data:     (1) seg (2) bp (3) fc_memhi (4) fc_memlo
severity: Error
log:      Always
module:   fcmemb.c
action:   This error could indicate a software driver or firmware 
          problem. If problems persist report these errors to 
          Technical Support.
*/
char      fc_mes0407[] = "%sMemory Buffer Pool is corrupted Data x%x x%x x%x x%x";
msgLogDef fc_msgBlk0407 = {
          FC_LOG_MSG_IN_0407,
          fc_mes0407,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_NO_RESOURCE };

/*
msgName: fc_mes0408
message:  Memory Buffer Pool is corrupted
descript: The buffer address returned to the pool is outside 
          the range of the pool and is therefore corrupt.
data:     (1) seg (2) bp (3) fc_memhi (4) fc_memlo
severity: Error
log:      Always
module:   fcmemb.c
action:   This error could indicate a software driver or firmware 
          problem. If problems persist report these errors to 
          Technical Support.
*/
char      fc_mes0408[] = "%sMemory Buffer Pool is corrupted Data x%x x%x x%x x%x";
msgLogDef fc_msgBlk0408 = {
          FC_LOG_MSG_IN_0408,
          fc_mes0408,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_NO_RESOURCE };

/*
msgName: fc_mes0409
message:  Memory Buffer Pool is out of buffers
descript: A driver memory buffer pool is exhausted.
data:     (1) seg (2) fc_free (3) fc_mbox.q_cnt (4) fc_memhi
severity: Error
log:      Always
module:   fcmemb.c
action:   Configure more resources for that buffer pool. If 
          problems persist report these errors to Technical 
          Support.
*/
char      fc_mes0409[] = "%sMemory Buffer Pool is out of buffers Data x%x x%x x%x x%x";
msgLogDef fc_msgBlk0409 = {
          FC_LOG_MSG_IN_0409,
          fc_mes0409,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_NO_RESOURCE };

/*
msgName: fc_mes0410
message:  Cannot find virtual addr for mapped buf on ring <num>
descript: The driver cannot find the specified buffer in its 
          mapping table. Thus it cannot find the virtual address 
          needed to access the data.
data:     (1) mapbp (2) fc_mpoff (3) fc_mpon
severity: Error
log:      Always
module:   fcmemb.c
action:   This error could indicate a software driver or firmware 
          problem. If problems persist report these errors to 
          Technical Support.
*/
char      fc_mes0410[] = "%sCannot find virtual addr for mapped buf on ring %d Data x%x x%x x%x";
msgLogDef fc_msgBlk0410 = {
          FC_LOG_MSG_IN_0410,
          fc_mes0410,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_NO_RESOURCE };

/*
msgName: fc_mes0411
message:  Scan-down is 2 with Persistent binding - ignoring scan-down
descript: The configuration parameter for Scan-down conflicts with 
          Persistent binding parameter.
data:     (1) a_current (2) fcp_mapping
severity: Error config
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file.
*/
char      fc_mes0411[] = "%sScan-down is 2 with Persistent binding - ignoring scan-down Data: x%x x%x";
msgLogDef fc_msgBlk0411 = {
          FC_LOG_MSG_IN_0411,
          fc_mes0411,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0412
message:  Scan-down is out of range - ignoring scan-down
descript: The configuration parameter for Scan-down is out  of range.
data:     (1) clp[CFG_SCAN_DOWN].a_current (2) fcp_mapping
severity: Error
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file.
*/
char      fc_mes0412[] = "%sScan-down is out of range - ignoring scan-down Data: x%x x%x";
msgLogDef fc_msgBlk0412 = {
          FC_LOG_MSG_IN_0412,
          fc_mes0412,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0413
message:  Num-iocbs too low, resetting
descript: The configuration parameter for Num-iocs is too low, resetting 
          parameter to default value.
data:     (1) a_current (2) LPFC_MIN_NUM_IOCBS
severity: Error config
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file.
*/
char      fc_mes0413[] = "%sNum-iocbs too low, resetting Data: x%x x%x";
msgLogDef fc_msgBlk0413 = {
          FC_LOG_MSG_IN_0413,
          fc_mes0413,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0414
message:  Num-iocbs too high, resetting
descript: The configuration parameter for Num-iocs is too high, resetting 
          parameter to default value.
data:     (1) clp[CFG_NUM_IOCBS].a_current (2) LPFC_MAX_NUM_IOCBS
severity: Error config
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file.
*/
char      fc_mes0414[] = "%sNum-iocbs too high, resetting Data: x%x x%x";
msgLogDef fc_msgBlk0414 = {
          FC_LOG_MSG_IN_0414,
          fc_mes0414,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0415
message:  Num-bufs too low, resetting
descript: The configuration parameter for Num-bufs is too low, resetting 
          parameter to default value.
data:     (1) a_current (2) LPFC_MIN_NUM_BUFS
severity: Error config
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file.
*/
char      fc_mes0415[] = "%sNum-bufs too low, resetting Data: x%x x%x";
msgLogDef fc_msgBlk0415 = {
          FC_LOG_MSG_IN_0415,
          fc_mes0415,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0416
message:  Num-bufs too high, resetting
descript: The configuration parameter for Num-bufs is too high, resetting 
          parameter to default value.
data:     (1) a_current (2) LPFC_MAX_NUM_BUFS
severity: Error config
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file.
*/
char      fc_mes0416[] = "%sNum-bufs too high, resetting Data: x%x x%x";
msgLogDef fc_msgBlk0416 = {
          FC_LOG_MSG_IN_0416,
          fc_mes0416,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0417
message:  Target qdepth too high, resetting to max
descript: The configuration parameter for Target queue depth is too high, 
          resetting parameter to default value.
data:     (1) a_current (2) LPFC_MAX_TGT_Q_DEPTH
severity: Error config
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file.
*/
char      fc_mes0417[] = "%sTarget qdepth too high, resetting to max Data: x%x x%x";
msgLogDef fc_msgBlk0417 = {
          FC_LOG_MSG_IN_0417,
          fc_mes0417,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0418
message:  LUN qdepth too high, resetting to max
descript: The configuration parameter for LUN queue depth is too high, 
          resetting parameter to maximum default value.
data:     (1) a_current (2) LPFC_MAX_LUN_Q_DEPTH
severity: Error config
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file.
*/
char      fc_mes0418[] = "%sLUN qdepth too high, resetting to max Data: x%x x%x";
msgLogDef fc_msgBlk0418 = {
          FC_LOG_MSG_IN_0418,
          fc_mes0418,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0419
message:  LUN qdepth cannot be <zero>, resetting to 1
descript: The configuration parameter for LUN queue depth is set to 0. 
          Resetting parameter to default value of 1.
data:     (1) a_current
severity: Error config
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file.
*/
char      fc_mes0419[] = "%sLUN qdepth cannot be %d, resetting to 1";
msgLogDef fc_msgBlk0419 = {
          FC_LOG_MSG_IN_0419,
          fc_mes0419,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0420
message:  Fcpfabric_tmo too high, resetting
descript: The configuration parameter for Fcpfabric_tmo is too high, 
          resetting parameter to default value.
data:     (1) a_current (2) LPFC_MAX_FABRIC_TIMEOUT
severity: Error config
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file.
*/
char      fc_mes0420[] = "%sFcpfabric_tmo too high, resetting Data: x%x x%x";
msgLogDef fc_msgBlk0420 = {
          FC_LOG_MSG_IN_0420,
          fc_mes0420,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0421
message:  Fcp-class is illegal, resetting to default
descript: The configuration parameter for Fcp-class is illegal, resetting 
          parameter to default value.
data:     (1) a_current (2) CLASS3
severity: Error config
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file.
*/
char      fc_mes0421[] = "%sFcp-class is illegal, resetting Data: x%x x%x";
msgLogDef fc_msgBlk0421 = {
          FC_LOG_MSG_IN_0421,
          fc_mes0421,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0422
message:  No-device-delay too high, resetting to max
descript: The configuration parameter for No-device-delay is too high, 
          resetting parameter to maximum default value.
data:     (1) a_current (2) LPFC_MAX_NO_DEVICE_DELAY
severity: Error config
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file.
*/
char      fc_mes0422[] = "%sNo-device-delay too high, resetting to max Data: x%x x%x";
msgLogDef fc_msgBlk0422 = {
          FC_LOG_MSG_IN_0422,
          fc_mes0422,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0423
message:  Post_ip_buf too low, resetting
descript: The configuration parameter for Post_ip_buf is too low, resetting 
          parameter to default value.
data:     (1) a_current (2) LPFC_MIN_POST_IP_BUF
severity: Error config
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file.
*/
char      fc_mes0423[] = "%sPost_ip_buf too low, resetting Data: x%x x%x";
msgLogDef fc_msgBlk0423 = {
          FC_LOG_MSG_IN_0423,
          fc_mes0423,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0424
message:  Post_ip_buf too high, resetting
descript: The configuration parameter for Post_ip_buf is too high, resetting 
          parameter to default value.
data:     (1) a_current (2) LPFC_MAX_POST_IP_BUF
severity: Error config
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file.
*/
char      fc_mes0424[] = "%sPost_ip_buf too high, resetting Data: x%x x%x";
msgLogDef fc_msgBlk0424 = {
          FC_LOG_MSG_IN_0424,
          fc_mes0424,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0425
message:  Xmt-que_size too low, resetting
descript: The configuration parameter for Xmt-que_size is too low, resetting 
          parameter to default value.
data:     (1) a_current (2) LPFC_MIN_XMT_QUE_SIZE
severity: Error config
log:      Always
module:   fcLINUXcp.c
action:   Make neccessary changes to lpfc configuration file.
*/
char      fc_mes0425[] = "%sXmt-que_size too low, resetting Data: x%x x%x";
msgLogDef fc_msgBlk0425 = {
          FC_LOG_MSG_IN_0425,
          fc_mes0425,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0426
message:  Xmt-que_size too high, resetting
descript: The configuration parameter for Xmt-que_size is too high, resetting 
          parameter to default value.
data:     (1) a_current (2) LPFC_MAX_XMT_QUE_SIZE
severity: Error config
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file.
*/
char      fc_mes0426[] = "%sXmt-que_size too high, resetting Data: x%x x%x";
msgLogDef fc_msgBlk0426 = {
          FC_LOG_MSG_IN_0426,
          fc_mes0426,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0427
message:  Ip-class is illegal, resetting
descript: The configuration parameter for Ip-class is illegal, resetting 
          parameter to default value.
data:     (1) a_current (2) CLASS3
severity: Error config
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file.
*/
char      fc_mes0427[] = "%sIp-class is illegal, resetting Data: x%x x%x";
msgLogDef fc_msgBlk0427 = {
          FC_LOG_MSG_IN_0427,
          fc_mes0427,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0428
message:  Topology is illegal, resetting
descript: The configuration parameter for Topology is illegal, resetting 
          parameter to default value.
data:     (1) a_current (2) LPFC_DFT_TOPOLOGY
severity: Error config
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file.
*/
char      fc_mes0428[] = "%sTopology is illegal, resetting Data: x%x x%x";
msgLogDef fc_msgBlk0428 = {
          FC_LOG_MSG_IN_0428,
          fc_mes0428,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0429
message:  Linkdown_tmo too high, resetting
descript: The configuration parameter for Linkdown_tmo is too high, resetting 
          parameter to default value.
data:     (1) a_current (2) LPFC_MAX_LNKDWN_TIMEOUT
severity: Error config
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file.
*/
char      fc_mes0429[] = "%sLinkdown_tmo too high, resetting Data: x%x x%x";
msgLogDef fc_msgBlk0429 = {
          FC_LOG_MSG_IN_0429,
          fc_mes0429,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0430
message:  WWPN binding entry <num>: Syntax error code <code>
descript: A syntax error occured while parsing WWPN binding 
          configuraion information.
data:     None
detail:   Binding syntax error codes
          0  FC_SYNTAX_OK
          1  FC_SYNTAX_OK_BUT_NOT_THIS_BRD
          2  FC_SYNTAX_ERR_ASC_CONVERT
          3  FC_SYNTAX_ERR_EXP_COLON
          4  FC_SYNTAX_ERR_EXP_LPFC
          5  FC_SYNTAX_ERR_INV_LPFC_NUM
          6  FC_SYNTAX_ERR_EXP_T
          7  FC_SYNTAX_ERR_INV_TARGET_NUM
          8  FC_SYNTAX_ERR_EXP_D
          9  FC_SYNTAX_ERR_INV_DEVICE_NUM
          10 FC_SYNTAX_ERR_INV_RRATIO_NUM
          11 FC_SYNTAX_ERR_EXP_NULL_TERM
severity: Error config
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file.
*/
char      fc_mes0430[] = "%sWWPN binding entry %d: Syntax error code %d";
msgLogDef fc_msgBlk0430 = {
          FC_LOG_MSG_IN_0430,
          fc_mes0430,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0431
message:  WWNN binding entry <num>: Syntax error code <code>
descript: A syntax error occured while parsing WWNN binding 
          configuraion information.
data:     None
detail:   Binding syntax error codes
          0  FC_SYNTAX_OK
          1  FC_SYNTAX_OK_BUT_NOT_THIS_BRD
          2  FC_SYNTAX_ERR_ASC_CONVERT
          3  FC_SYNTAX_ERR_EXP_COLON
          4  FC_SYNTAX_ERR_EXP_LPFC
          5  FC_SYNTAX_ERR_INV_LPFC_NUM
          6  FC_SYNTAX_ERR_EXP_T
          7  FC_SYNTAX_ERR_INV_TARGET_NUM
          8  FC_SYNTAX_ERR_EXP_D
          9  FC_SYNTAX_ERR_INV_DEVICE_NUM
          10 FC_SYNTAX_ERR_INV_RRATIO_NUM
          11 FC_SYNTAX_ERR_EXP_NULL_TERM
severity: Error config
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file.
*/
char      fc_mes0431[] = "%sWWNN binding entry %d: Syntax error code %d";
msgLogDef fc_msgBlk0431 = {
          FC_LOG_MSG_IN_0431,
          fc_mes0431,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0432
message:  WWPN binding entry: node table full
descript: More bindings entries were configured than the driver can handle. 
data:     None
severity: Error config
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file such that 
          fewer bindings are configured.
*/
char      fc_mes0432[] = "%sWWPN binding entry: node table full";
msgLogDef fc_msgBlk0432 = {
          FC_LOG_MSG_IN_0432,
          fc_mes0432,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0433
message:  WWNN binding entry: node table full
descript: More bindings entries were configured than the driver can handle. 
data:     None
severity: Error config
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file such that 
          fewer bindings are configured.
*/
char      fc_mes0433[] = "%sWWNN binding entry: node table full";
msgLogDef fc_msgBlk0433 = {
          FC_LOG_MSG_IN_0433,
          fc_mes0433,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0434
message:  DID binding entry <num>: Syntax error code <code>
descript: A syntax error occured while parsing DID binding 
          configuraion information.
data:     None
detail:   Binding syntax error codes
          0  FC_SYNTAX_OK
          1  FC_SYNTAX_OK_BUT_NOT_THIS_BRD
          2  FC_SYNTAX_ERR_ASC_CONVERT
          3  FC_SYNTAX_ERR_EXP_COLON
          4  FC_SYNTAX_ERR_EXP_LPFC
          5  FC_SYNTAX_ERR_INV_LPFC_NUM
          6  FC_SYNTAX_ERR_EXP_T
          7  FC_SYNTAX_ERR_INV_TARGET_NUM
          8  FC_SYNTAX_ERR_EXP_D
          9  FC_SYNTAX_ERR_INV_DEVICE_NUM
          10 FC_SYNTAX_ERR_INV_RRATIO_NUM
          11 FC_SYNTAX_ERR_EXP_NULL_TERM
severity: Error config
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file.
*/
char      fc_mes0434[] = "%sDID binding entry %d: Syntax error code %d";
msgLogDef fc_msgBlk0434 = {
          FC_LOG_MSG_IN_0434,
          fc_mes0434,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0435
message:  DID binding entry: node table full
descript: More bindings entries were configured than the driver can handle. 
data:     None
severity: Error config
log:      Always
module:   fcLINUXfcp.c
action:   Make neccessary changes to lpfc configuration file such that 
          fewer bindings are configured.
*/
char      fc_mes0435[] = "%sDID binding entry: node table full";
msgLogDef fc_msgBlk0435 = {
          FC_LOG_MSG_IN_0435,
          fc_mes0435,
          fc_msgPreambleINc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_INIT,
          ERRID_LOG_INIT };
/*
msgName: fc_mes0436
message:  Adapter failed to init, timeout, status reg <status>
descript: The adapter failed during powerup diagnostics after it was reset.
data:     None
severity: Error
log:      Always
module:   lp6000.c
action:   This error could indicate a hardware or firmware problem. If 
          problems persist report these errors to Technical Support.
*/
char      fc_mes0436[] = "%sAdapter failed to init, timeout, status reg x%x"; 
msgLogDef fc_msgBlk0436 = {
          FC_LOG_MSG_IN_0436,
          fc_mes0436,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0437
message:  Adapter failed to init, chipset, status reg <status>
descript: The adapter failed during powerup diagnostics after it was reset.
data:     None
severity: Error
log:      Always
module:   lp6000.c
action:   This error could indicate a hardware or firmware problem. If 
          problems persist report these errors to Technical Support.
*/
char      fc_mes0437[] = "%sAdapter failed to init, chipset, status reg x%x"; 
msgLogDef fc_msgBlk0437 = {
          FC_LOG_MSG_IN_0437,
          fc_mes0437,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0438
message:  Adapter failed to init, chipset, status reg <status>
descript: The adapter failed during powerup diagnostics after it was reset.
data:     None
severity: Error
log:      Always
module:   lp6000.c
action:   This error could indicate a hardware or firmware problem. If 
          problems persist report these errors to Technical Support.
*/
char      fc_mes0438[] = "%sAdapter failed to init, chipset, status reg x%x"; 
msgLogDef fc_msgBlk0438 = {
          FC_LOG_MSG_IN_0438,
          fc_mes0438,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0439
message:  Adapter failed to init, mbxCmd <cmd> READ_REV, mbxStatus <status>
descript: Adapter initialization failed when issuing READ_REV mailbox command.
data:     None
severity: Error
log:      Always
module:   lp6000.c
action:   This error could indicate a hardware or firmware problem. If 
          problems persist report these errors to Technical Support.
*/
char      fc_mes0439[] = "%sAdapter failed to init, mbxCmd x%x READ_REV, mbxStatus x%x";
msgLogDef fc_msgBlk0439 = {
          FC_LOG_MSG_IN_0439,
          fc_mes0439,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0440
message:  Adapter failed to init, mbxCmd <cmd> READ_REV detected outdated firmware
descript: Outdated firmware was detected during initialization. 
data:     (1) read_rev_reset
severity: Error
log:      Always
module:   lp6000.c
action:   This error could indicate a hardware or firmware problem. Update 
          firmware. If problems persist report these errors to Technical 
          Support.
*/
char      fc_mes0440[] = "%sAdapter failed to init, mbxCmd x%x READ_REV detected outdated firmware Data: x%x"; 
msgLogDef fc_msgBlk0440 = {
          FC_LOG_MSG_IN_0440,
          fc_mes0440,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0441
message:  Adapter failed to init, mbxCmd <cmd> DUMP VPD, mbxStatus <status>
descript: Adapter initialization failed when issuing DUMP_VPD mailbox command.
data:     None
severity: Error
log:      Always
module:   lp6000.c
action:   This error could indicate a hardware or firmware problem. If 
          problems persist report these errors to Technical Support.
*/
char      fc_mes0441[] = "%sAdapter failed to init, mbxCmd x%x DUMP VPD, mbxStatus x%x";
msgLogDef fc_msgBlk0441 = {
          FC_LOG_MSG_IN_0441,
          fc_mes0441,
          fc_msgPreambleINw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0442
message:  Adapter failed to init, mbxCmd <cmd> CONFIG_PORT, mbxStatus <status>
descript: Adapter initialization failed when issuing CONFIG_PORT mailbox 
          command.
data:     0
severity: Error
log:      Always
module:   lp6000.c
action:   This error could indicate a hardware or firmware problem. If 
          problems persist report these errors to Technical Support.
*/
char      fc_mes0442[] = "%sAdapter failed to init, mbxCmd x%x CONFIG_PORT, mbxStatus x%x Data: x%x"; 
msgLogDef fc_msgBlk0442 = {
          FC_LOG_MSG_IN_0442,
          fc_mes0442,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0443
message:  SLI1 not supported, mbxCmd <cmd>, mbxStatus <status>
descript: The driver no longer support SLI-1 mode.
data:     0
severity: Error
log:      Always
module:   lp6000.c
action:   This error could indicate a driver problem. If problems persist 
          report these errors to Technical Support.
*/
char      fc_mes0443[] = "%sSLI1 not supported, mbxCmd x%x, mbxStatus x%x Data: x%x"; 
msgLogDef fc_msgBlk0443 = {
          FC_LOG_MSG_IN_0443,
          fc_mes0443,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0444
message:  Adapter failed to init, no buffers for RUN_BIU_DIAG 
descript: The driver attempted to issue RUN_BIU_DIAG mailbox command to 
          the HBA but there were no buffer available.
data:     None
severity: Error
log:      Always
module:   lp6000.c
action:   This message indicates (1) a possible lack of memory resources. 
          Try increasing the lpfc 'num_bufs' configuration parameter to 
          allocate more buffers. (2) A possble driver buffer management 
          problem. If this problem persists, report these errors to 
          Technical Support.
*/
char      fc_mes0444[] = "%sAdapter failed to init, no buffers for RUN_BIU_DIAG";
msgLogDef fc_msgBlk0444 = {
          FC_LOG_MSG_IN_0444,
          fc_mes0444,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0445
message:  RUN_BIU_DIAG failed
descript: Adapter failed to init properly because a PCI bus DMA 
          test failed. 
data:     None
severity: Error
log:      Always
module:   lp6000.c
action:   This error usually indicates a hardware problem with the 
          adapter. Run diagnostics.
*/
char      fc_mes0445[] = "%sRUN_BIU_DIAG failed"; 
msgLogDef fc_msgBlk0445 = {
          FC_LOG_MSG_IN_0445,
          fc_mes0445,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0446
message:  Adapter failed to init, mbxCmd <cmd> CFG_RING, mbxStatus <status>, ring <num>
descript: Adapter initialization failed when issuing CFG_RING mailbox command.
data:     None
severity: Error
log:      Always
module:   lp6000.c
action:   This error could indicate a hardware or firmware problem. If 
          problems persist report these errors to Technical Support.
*/
char      fc_mes0446[] = "%sAdapter failed to init, mbxCmd x%x CFG_RING, mbxStatus x%x, ring %d";
msgLogDef fc_msgBlk0446 = {
          FC_LOG_MSG_IN_0446,
          fc_mes0446,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0447
message:  Adapter failed init, mbxCmd <cmd> rubBIUdiag mbxStatus <status>
descript: Adapter initialization failed when issuing runBIUdiag mailbox 
          command.
data:     None
severity: Error
log:      Always
module:   lp6000.c
action:   This error could indicate a hardware or firmware problem. If 
          problems persist report these errors to Technical Support.
*/
char      fc_mes0447[] = "%sAdapter failed init, mbxCmd x%x CONFIG_LINK mbxStatus x%x"; 
msgLogDef fc_msgBlk0447 = {
          FC_LOG_MSG_IN_0447,
          fc_mes0447,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0448
message:  Adapter failed to init, mbxCmd <cmd> READ_SPARM, mbxStatus <status>
descript: Adapter initialization failed when issuing READ_SPARM mailbox 
          command.
data:     None
severity: Error
log:      Always
module:   lp6000.c
action:   This error could indicate a hardware or firmware problem. If 
          problems persist report these errors to Technical Support.
*/
char      fc_mes0448[] = "%sAdapter failed init, mbxCmd x%x READ_SPARM mbxStatus x%x"; 
msgLogDef fc_msgBlk0448 = {
          FC_LOG_MSG_IN_0448,
          fc_mes0448,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0449
message:  WorldWide PortName Type <type> doesn't conform to IP Profile
descript: In order to run IP, the WorldWide PortName must be of type 
          IEEE (NAA = 1). This message displays if the adapter WWPN 
          doesn't conform with the standard.
data:     None
severity: Error
log:      Always
module:   lp6000.c
action:   Turn off the network-on configuration parameter or configure 
          a different WWPN.
*/
char      fc_mes0449[] = "%sWorldWide PortName Type x%x doesn't conform to IP Profile"; 
msgLogDef fc_msgBlk0449 = {
          FC_LOG_MSG_IN_0449,
          fc_mes0449,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0450
message:  Adapter failed to init, mbxCmd <cmd> FARP, mbxStatus <status> 
descript: Adapter initialization failed when issuing FARP mailbox command.
data:     None
severity: Warning
log:      LOG_INIT verbose
module:   lp6000.c
action:   None required
*/
char      fc_mes0450[] = "%sAdapter failed to init, mbxCmd x%x FARP, mbxStatus x%x"; 
msgLogDef fc_msgBlk0450 = {
          FC_LOG_MSG_IN_0450,
          fc_mes0450,
          fc_msgPreambleINw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0451
message:  Enable interrupt handler failed
descript: The driver attempted to register the HBA interrupt service 
          routine with the host operating system but failed.
data:     None
severity: Error
log:      Always
module:   lp6000.c
action:   This error could indicate a hardware or driver problem. If 
          problems persist report these errors to Technical Support.
*/
char      fc_mes0451[] = "%sEnable interrupt handler failed"; 
msgLogDef fc_msgBlk0451 = {
          FC_LOG_MSG_IN_0451,
          fc_mes0451,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0452
message:  Bring Adapter offline
descript: The FC driver has received a request to bring the adapter 
          offline. This may occur when running lputil.
data:     None
severity: Warning
log:      LOG_INIT verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0452[] = "%sBring Adapter offline"; 
msgLogDef fc_msgBlk0452 = {
          FC_LOG_MSG_IN_0452,
          fc_mes0452,
          fc_msgPreambleINw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_INIT,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0453
message:  Adapter failed to init, mbxCmd <cmd> READ_CONFIG, mbxStatus <status>
descript: Adapter initialization failed when issuing READ_CONFIG mailbox 
          command.
data:     None
severity: Error
log:      Always
module:   lp6000.c
action:   This error could indicate a hardware or firmware problem. If 
          problems persist report these errors to Technical Support.
*/
char      fc_mes0453[] = "%sAdapter failed to init, mbxCmd x%x READ_CONFIG, mbxStatus x%x"; 
msgLogDef fc_msgBlk0453 = {
          FC_LOG_MSG_IN_0453,
          fc_mes0453,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0454
message:  Adapter failed to init, mbxCmd <cmd> INIT_LINK, mbxStatus <status>
descript: Adapter initialization failed when issuing INIT_LINK mailbox command.
data:     None
severity: Error
log:      Always
module:   lp6000.c
action:   This error could indicate a hardware or firmware problem. If 
          problems persist report these errors to Technical Support.
*/
char      fc_mes0454[] = "%sAdapter failed to init, mbxCmd x%x INIT_LINK, mbxStatus x%x";
msgLogDef fc_msgBlk0454 = {
          FC_LOG_MSG_IN_0454,
          fc_mes0454,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0455
message:  Vital Product
descript: Vital Product Data (VPD) contained in HBA flash.
data:     (1) vpd[0] (2) vpd[1] (3) vpd[2] (4) vpd[3]
severity: Information
log:      LOG_INIT verbose
module:   lp6000.c
action:   None required
*/
char      fc_mes0455[] = "%sVital Product Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0455 = {
          FC_LOG_MSG_IN_0455,
          fc_mes0455,
          fc_msgPreambleINi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0457
message:  Adapter Hardware Error
descript: The driver received an interrupt indicting a possible hardware 
          problem.
data:     (1) status (2) status1 (3) status2
severity: Error
log:      Always
module:   lp6000.c
action:   This error could indicate a hardware or firmware problem. If 
          problems persist report these errors to Technical Support.
*/
char      fc_mes0457[] = "%sAdapter Hardware Error Data: x%x x%x x%x"; 
msgLogDef fc_msgBlk0457 = {
          FC_LOG_MSG_IN_0457,
          fc_mes0457,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
msgName: fc_mes0458
message:  Bring Adapter online
descript: The FC driver has received a request to bring the adapter 
          online. This may occur when running lputil.
data:     None
severity: Warning
log:      LOG_INIT verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0458[] = "%sBring Adapter online"; 
msgLogDef fc_msgBlk0458 = {
          FC_LOG_MSG_IN_0458,
          fc_mes0458,
          fc_msgPreambleINw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_INIT,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0459
message:  Bring Adapter online
descript: The FC driver has received a request to bring the adapter 
          online. This may occur when running lputil.
data:     None
severity: Warning
log:      LOG_INIT verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0459[] = "%sBring Adapter online"; 
msgLogDef fc_msgBlk0459 = {
          FC_LOG_MSG_IN_0459,
          fc_mes0459,
          fc_msgPreambleINw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_INIT,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0460
message:  Bring Adapter offline
descript: The FC driver has received a request to bring the adapter 
          offline. This may occur when running lputil.
data:     None
severity: Warning
log:      LOG_INIT verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0460[] = "%sBring Adapter offline"; 
msgLogDef fc_msgBlk0460 = {
          FC_LOG_MSG_IN_0460,
          fc_mes0460,
          fc_msgPreambleINw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_INIT,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0461
message:  Adapter failed init, mbxCmd <cmd> CONFIG_LINK mbxStatus <status>
descript: Adapter initialization failed when issuing CONFIG_LINK mailbox 
          command.
data:     None
severity: Error
log:      Always
module:   lp6000.c
action:   This error could indicate a hardware or firmware problem. If 
          problems persist report these errors to Technical Support.
*/
char      fc_mes0461[] = "%sAdapter failed init, mbxCmd x%x CONFIG_LINK mbxStatus x%x"; 
msgLogDef fc_msgBlk0461 = {
          FC_LOG_MSG_IN_0461,
          fc_mes0461,
          fc_msgPreambleINe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_INIT,
          ERRID_LOG_INIT };

/*
 *  UNUSED 0500
 */

/*
 *  Begin IP LOG Message Structures
 */

/*
msgName: fc_mes0600
message:  FARP-RSP received from DID <did>.
descript: A FARP ELS command response was received.
data:     None
severity: Information
log:      LOG_IP verbose
module:   fcelsb.c
action:   None required
*/
char      fc_mes0600[] = "%sFARP-RSP received from DID x%x"; 
msgLogDef fc_msgBlk0600 = {
          FC_LOG_MSG_IP_0600,
          fc_mes0600,
          fc_msgPreambleIPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_IP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0601
message:  FARP-REQ received fron DID <did>
descript: A FARP ELS command request was received.  .
data:     None
severity: Information
log:      LOG_IP verbose
module:   fcelsb.c
action:   None required
*/
char      fc_mes0601[] = "%sFARP-REQ received from DID x%x"; 
msgLogDef fc_msgBlk0601 = {
          FC_LOG_MSG_IP_0601,
          fc_mes0601,
          fc_msgPreambleIPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_IP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0602
message:  IP Response Ring <num> out of posted buffers
descript: The IP ring returned all posted buffers to the driver 
          and is waiting for the driver to post new buffers. This 
          could mean the host system is out of TCP/IP buffers. 
data:     (1) fc_missbufcnt (2) NoRcvBuf
severity: Warning
log:      LOG_IP verbose
module:   fcscsib.c
action:   Try allocating more IP buffers (STREAMS buffers or mbufs) 
          of size 4096 and/or increasing the post-ip-buf lpfc 
          configuration parameter. Reboot the system.
*/
char      fc_mes0602[] = "%sIP Response Ring %d out of posted buffers Data: x%x x%x"; 
msgLogDef fc_msgBlk0602 = {
          FC_LOG_MSG_IP_0602,
          fc_mes0602,
          fc_msgPreambleIPw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_IP,
          ERRID_LOG_NO_RESOURCE };

/*
msgName: fc_mes0603
message:  Rcv Ring <num> out of posted buffers
descript: The ring returned all posted buffers to the driver 
          and is waiting for the driver to post new buffers. This 
          could mean the host system is out of ELS or CT buffers. 
data:     (1) fc_missbufcnt (2) NoRcvBuf
severity: Error
log:      Always
module:   fcscsib.c
action:   Try allocating more buffers by increasing the num-buf lpfc 
          configuration parameter. Reboot the system.
*/
char      fc_mes0603[] = "%sRcv Ring %d out of posted buffers Data: x%x x%x"; 
msgLogDef fc_msgBlk0603 = {
          FC_LOG_MSG_IP_0603,
          fc_mes0603,
          fc_msgPreambleIPe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_IP,
          ERRID_LOG_NO_RESOURCE };

/*
msgName: fc_mes0604
message:  Post buffer for IP ring <num> failed
descript: The driver cannot allocate a buffer to post to the IP ring. 
          This usually means the host system is out of TCP/IP buffers. 
data:     (1) missbufcnt
severity: Error
log:      Always
module:   fcscsib.c
action:   Try allocating more IP buffers (STREAMS buffers or mbufs) 
          of size 4096. Reboot the system.
*/
char      fc_mes0604[] = "%sPost buffer for IP ring %d failed Data: x%x"; 
msgLogDef fc_msgBlk0604 = {
          FC_LOG_MSG_IP_0604,
          fc_mes0604,
          fc_msgPreambleIPe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_IP,
          ERRID_LOG_NO_RESOURCE };

/*
msgName: fc_mes0605
message:  No room on IP xmit queue
descript: The system is generating IOCB commands to be processed 
          faster than the adapter can process them. 
data:     (1) xmitnoroom
severity: Warning
log:      LOG_IP verbose
module:   fcxmitb.c
action:   Check the state of the link. If the link is up and running, 
          reconfigure the xmit queue size to be larger. Note, a larger 
          queue size may require more system IP buffers. If the link 
          is down, check physical connections to Fibre Channel network.
*/
char      fc_mes0605[] = "%sNo room on IP xmit queue Data: x%x"; 
msgLogDef fc_msgBlk0605 = {
          FC_LOG_MSG_IP_0605,
          fc_mes0605,
          fc_msgPreambleIPw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_IP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0606
message:  Stray XmitSequence completion
descript: Received an XMIT_SEQUENCE IOCB completion without issuing 
          a corresponding XMIT_SEQUENCE Command (based on the IOTAG 
          field in the XMIT_SEQUENCE_CR iocb).
data:     (1) ulpCommand (2) ulpIoTag
severity: Error
log:      Always
module:   fcxmitb.c
action:   This error could indicate a software driver or firmware 
          problem. If problems persist report these errors to 
          Technical Support.
*/
char      fc_mes0606[] = "%sStray XmitSequence completion Data: x%x x%x"; 
msgLogDef fc_msgBlk0606 = {
          FC_LOG_MSG_IP_0606,
          fc_mes0606,
          fc_msgPreambleIPe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_IP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0607
message:  Xmit Sequence completion error
descript: A XMIT_SEQUENCE command completed with a status error 
          in the IOCB.
data:     (1) ulpStatus (2) ulpToTag (3) ulpWord[4] (4) did
severity: Warning
log:      LOG_IP verbose
module:   fcxmitb.c
action:   If there are many errors to one device, check physical 
          connections to Fibre Channel network and the state of 
          the remote PortID.  The driver attempts to recover by 
          creating a new exchange to the remote device.
*/
char      fc_mes0607[] = "%sXmit Sequence completion error Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0607 = {
          FC_LOG_MSG_IP_0607,
          fc_mes0607,
          fc_msgPreambleIPw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_IP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0608
message:  Stray CreateXRI completion
descript: Received a CREATE_XRI command completion without 
          issuing a corresponding CREATE_XRI Command (based 
          on the IOTAG field in the CREATE_XRI_CR iocb).
data:     (1) ulpCommad (2) ulpToTag
severity: Error
log:      Always
module:   fcxmitb.c
action:   This error could indicate a software driver or 
          firmware problem. If problems persist report these 
          errors to Technical Support.
*/
char      fc_mes0608[] = "%sStray CreateXRI completion Data: x%x x%x"; 
msgLogDef fc_msgBlk0608 = {
          FC_LOG_MSG_IP_0608,
          fc_mes0608,
          fc_msgPreambleIPe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_IP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
 *  Begin FCP LOG Message Structures
 */

/*
msgName: fc_mes0700
message:  Start nodev timer
descript: A target disappeared from the Fibre Channel network. If the 
          target does not return within nodev-tmo timeout all I/O to 
          the target will fail.
data:     (1) nlp (2) nlp_flag (3) nlp_state (4) nlp_DID
severity: Information
log:      LOG_FCP verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0700[] = "%sSTART nodev timer Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0700 = {
          FC_LOG_MSG_FP_0700,
          fc_mes0700,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0701
message:  Issue Abort Task Set I/O for LUN <num>
descript: The SCSI layer detected that it needs to abort all I/O 
          to a specific device. This results in an FCP Task 
          Management command to abort the I/O in progress. 
data:     (1) did (2) sid (3) flags
severity: Information
log:      LOG_FCP verbose
module:   fcstratb.c
action:   Check state of device in question. 
*/
char      fc_mes0701[] = "%sIssue Abort Task Set I/O for LUN %d Data: x%x x%x x%x"; 
msgLogDef fc_msgBlk0701 = {
          FC_LOG_MSG_FP_0701,
          fc_mes0701,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0702
message:  Issue Target Reset I/O
descript: The SCSI layer detected that it needs to abort all I/O 
          to a specific target. This results in an FCP Task 
          Management command to abort the I/O in progress. 
data:     (1) lun (2) did (3) sid (4) flags
severity: Information
log:      LOG_FCP verbose
module:   fcstratb.c
action:   Check state of target in question. 
*/
char      fc_mes0702[] = "%sIssue Target Reset I/O Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0702 = {
          FC_LOG_MSG_FP_0702,
          fc_mes0702,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0703
message:  Issue LUN Reset I/O for LUN <num>
descript: The SCSI layer detected that it needs to abort all I/O 
          to a specific device. This results in an FCP Task 
          Management command to abort the I/O in progress. 
data:     (1) did (2) sid (3) flags
severity: Information
log:      LOG_FCP verbose
module:   fcstratb.c
action:   Check state of device in question. 
*/
char      fc_mes0703[] = "%sIssue LUN Reset I/O for LUN %d Data: x%x x%x x%x"; 
msgLogDef fc_msgBlk0703 = {
          FC_LOG_MSG_FP_0703,
          fc_mes0703,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0704
message:  STOP nodev timer
descript: The FCP target was rediscovered and I/O can be resumed.
data:     (1) ndlp (2) nlp_flag (3) nlp_state (4) nlp_DID
severity: Information
log:      LOG_FCP verbose
module:   fcstratb.c
action:   None required
*/
char      fc_mes0704[] = "%sSTOP nodev timer Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0704 = {
          FC_LOG_MSG_FP_0704,
          fc_mes0704,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0705
message:  STOP nodev timer
descript: The FCP target was rediscovered and I/O can be resumed.
data:     (1) ndlp (2) nlp_flag (3) nlp_state (4) nlp_DID
severity: Information
log:      LOG_FCP verbose
module:   fcstratb.c
action:   None required
*/
char      fc_mes0705[] = "%sSTOP nodev timer Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0705 = {
          FC_LOG_MSG_FP_0705,
          fc_mes0705,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0706
message:  Cannot issue FCP command
descript: A valid ELS login with the FCP target no longer exists.
data:     (1) did (2) sid
severity: Warning
log:      LOG_FCP verbose
module:   fcstratb.c
action:   Check the state of the target in question.
*/
char      fc_mes0706[] = "%sCannot issue FCP command Data: x%x x%x"; 
msgLogDef fc_msgBlk0706 = {
          FC_LOG_MSG_FP_0706,
          fc_mes0706,
          fc_msgPreambleFPw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0707
message:  Bad SCSI CDB length for LUN <num> DID <num>
descript: This error indicates a SCSI command sent to the 
          FC driver from the SCSI layer has an invalid length.
data:     (1) cmd_cdblen (2) fcpCdb
severity: Error
log:      Always
module:   fcstratb.c
action:   This error could indicate a host operating system SCSI 
          layer problem. If problems persist report these errors 
          to Technical Support.
*/
char      fc_mes0707[] = "%sBad SCSI CDB length for LUN %d DID x%x Data: x%x x%x"; 
msgLogDef fc_msgBlk0707 = {
          FC_LOG_MSG_FP_0707,
          fc_mes0707,
          fc_msgPreambleFPe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0708
message:  NULL sp in flush_done
descript: This error indicates a potential FC driver problem 
          related to a FCP command iodone
data:     (1) cmnd[0] (2) serial_number (3) retries (4) result
severity: Error
log:      Always
module:   fcLINUXfcp.c
action:   This error could indicate a driver problem. If problems 
          persist report these errors to Technical Support.
*/
char      fc_mes0708[] = "%sNULL sp in flush_done Data: x%x x%x x%x x%x";
msgLogDef fc_msgBlk0708 = {
          FC_LOG_MSG_FP_0708,
          fc_mes0708,
          fc_msgPreambleFPe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0709
message:  NULL sp in DPC flush_done
descript: This error indicates a potential FC driver problem 
          related to a FCP command iodone
data:     (1) cmnd[0] (2) serial_number (3) retries (4) result
severity: Error
log:      Always
module:   fcLINUXfcp.c
action:   This error could indicate a driver problem. If problems 
          persist report these errors to Technical Support.
*/
char      fc_mes0709[] = "%sNULL sp in DPC flush_done Data: x%x x%x x%x x%x";
msgLogDef fc_msgBlk0709 = {
          FC_LOG_MSG_FP_0709,
          fc_mes0709,
          fc_msgPreambleFPe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0710
message:  iodone error return
descript: This error indicates the FC driver is returning SCSI 
          command to the SCSI layer in error or with sense data.
data:     (1) target (2) retries (3) result (4) *iptr
severity: Information
log:      LOG_FCP verbose
module:   fcLINUXfcp.c
action:   None required
*/
char      fc_mes0710[] = "%siodone error return Data: x%x x%x x%x x%x";
msgLogDef fc_msgBlk0710 = {
          FC_LOG_MSG_FP_0710,
          fc_mes0710,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0711
message:  iodone error return
descript: This error indicates the FC driver is returning SCSI 
          command to the SCSI layer in error or with sense data.
data:     (1) target (2) retries (3) result (4) *iptr
severity: Information
log:      LOG_FCP verbose
module:   fcLINUXfcp.c
action:   None required
*/
char      fc_mes0711[] = "%siodone error return Data: x%x x%x x%x x%x";
msgLogDef fc_msgBlk0711 = {
          FC_LOG_MSG_FP_0711,
          fc_mes0711,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0712
message:  SCSI layer issued abort device
descript: The SCSI layer is requesting the driver to abort 
          I/O to a specific device.
data:     (1) target (2) lun (3) cmnd[0] (4) serial_number
severity: Error
log:      Always
module:   fcLINUXfcp.c
action:   Check state of device in question.
*/
char      fc_mes0712[] = "%sSCSI layer issued abort device Data: x%x x%x x%x x%x";
msgLogDef fc_msgBlk0712 = {
          FC_LOG_MSG_FP_0712,
          fc_mes0712,
          fc_msgPreambleFPe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0713
message:  SCSI layer issued target reset
descript: The SCSI layer is requesting the driver to abort 
          I/O to a specific target.
data:     (1) target (2) lun (3) dev_index
severity: Error
log:      Always
module:   fcLINUXfcp.c
action:   Check state of target in question.
*/
char      fc_mes0713[] = "%sSCSI layer issued target reset Data: x%x x%x x%x";
msgLogDef fc_msgBlk0713 = {
          FC_LOG_MSG_FP_0713,
          fc_mes0713,
          fc_msgPreambleFPe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0714
message:  SCSI layer issued Bus Reset
descript: The SCSI layer is requesting the driver to abort 
          all I/Os to all targets on this HBA.
data:     (1) target (2) lun     
severity: Error
log:      Always
module:   fcLINUXfcp.c
action:   Check state of targets in question.
*/
char      fc_mes0714[] = "%sSCSI layer issued Bus Reset Data: x%x x%x";
msgLogDef fc_msgBlk0714 = {
          FC_LOG_MSG_FP_0714,
          fc_mes0714,
          fc_msgPreambleFPe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0715
message:  SCSI layer issued Host Reset
descript: The SCSI layer is requesting the driver to reset the link 
          on this HBA.
data:     (1) target (2) lun     
severity: Error
log:      Always
module:   fcLINUXfcp.c
action:   Check state of HBA link.
*/
char      fc_mes0715[] = "%sSCSI layer issued Host Reset Data: x%x x%x";
msgLogDef fc_msgBlk0715 = {
          FC_LOG_MSG_FP_0715,
          fc_mes0715,
          fc_msgPreambleFPe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0716
message:  FCP residual underrun, expected <len>, residual <resid>
descript: FCP device provided less data than was requested.
data:     (1) cmnd[0] (2) underflow 
severity: Information
log:      LOG_FCP verbose
module:   fcLINUXfcp.c
action:   None required
*/
char      fc_mes0716[] = "%sFCP residual underrun, expected %d, residual %d Data: x%x x%x";
msgLogDef fc_msgBlk0716 = {
          FC_LOG_MSG_FP_0716,
          fc_mes0716,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0717
message:  FCP command <cmd> residual underrun converted to error
descript: The driver converts this underrun condition to an error based 
          on the underflow field in the SCSI cmnd.
data:     (1) underflow (2) len (3) resid 
severity: Information
log:      LOG_FCP verbose
module:   fcLINUXfcp.c
action:   None required
*/
char      fc_mes0717[] = "%sFCP cmd x%x resid urun convrt'd to err Data: x%x x%x x%x";
msgLogDef fc_msgBlk0717 = {
          FC_LOG_MSG_FP_0717,
          fc_mes0717,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0718
message:  LUN address out of range
descript: Invalid LUN number in the SCSI command passed to the driver.
data:     (1) target (2) lun
severity: Error
log:      Always
module:   fcLINUXfcp.c
action:   This error could indicate a host operating system SCSI 
          layer problem. If problems persist report these errors 
          to Technical Support.
*/
char      fc_mes0718[] = "%sLUN address out of range Data: x%x x%x";
msgLogDef fc_msgBlk0718 = {
          FC_LOG_MSG_FP_0718,
          fc_mes0718,
          fc_msgPreambleFPe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0719
message:  Waiting for REPORT LUN cmpl before issuing INQUIRY SN
descript: Waiting for REPORT LUN completion before issuing INQUIRY SN
data:     (1) scsi_id (2) lun_id (3) flags
severity: Information
log:      LOG_FCP verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0719[] = "%sWaiting for REPORT LUN cmpl before issuing INQUIRY SN Data: x%x x%x x%x"; 
msgLogDef fc_msgBlk0719 = {
          FC_LOG_MSG_FP_0719,
          fc_mes0719,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0720
message: Stray FCP completion
descript: Received an FCP command completion without issuing a 
          corresponding FCP Command (based on the IOTAG field 
          in the FCP IOCB).
data:     (1) ulpCommand (2) ulpIoTag (3) ulpStatus (4) ulpWord[4]
severity: Error
log:      Always
module:   fcscsib.c
action:   This error could indicate a software driver or firmware 
          problem. If problems persist report these errors to 
          Technical Support.
*/
char      fc_mes0720[] = "%sStray FCP completion Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0720 = {
          FC_LOG_MSG_FP_0720,
          fc_mes0720,
          fc_msgPreambleFPe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0721
message:  INQUIRY SN cmpl
descript: An INQUIRY Serial Number (page x83) completed. This information
          is saved by the driver. 
data:     (1) scsi_id (2) lun_id (3) statLocalError (4) cmd + WD7
severity: Information
log:      LOG_FCP verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0721[] = "%sINQUIRY SN cmpl Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0721 = {
          FC_LOG_MSG_FP_0721,
          fc_mes0721,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0722
message:  INQUIRY SN info
descript: This is the serial number of the device that will be saved.
data:     (1) *datap (2) *datap + 3 (3) datap + 7 (4) rspResId
severity: Information
log:      LOG_FCP verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0722[] = "%sINQUIRY SN info Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0722 = {
          FC_LOG_MSG_FP_0722,
          fc_mes0722,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0723
message:  Issue INQUIRY SN
descript: Issuing an INQUIRY Serial Number (page x83) FCP command.
data:     (1) scsi_id (2) lun_id
severity: Information
log:      LOG_FCP verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0723[] = "%sIssue INQUIRY SN Data: x%x x%x"; 
msgLogDef fc_msgBlk0723 = {
          FC_LOG_MSG_FP_0723,
          fc_mes0723,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0724
message:  Issue INQUIRY Page 0
descript: Issuing an INQUIRY (page x0) FCP command.
data:     (1) scsi_id (2) lun_id
severity: Information
log:      LOG_FCP verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0724[] = "%sIssue INQUIRY Page 0 Data: x%x x%x"; 
msgLogDef fc_msgBlk0724 = {
          FC_LOG_MSG_FP_0724,
          fc_mes0724,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0725
message:  Inquiry Serial Number: invalid length
descript: An INQUIRY SN command completed with an invalid serial number length.
data:     (1) sizeSN (2) j (3) scsi_id (4) lun_id
severity: Error
log:      Always
module:   fcscsib.c
action:   Check remote NPORT for potential problem.
*/
char      fc_mes0725[] = "%sINQ Serial Number: invalid length Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0725= {
          FC_LOG_MSG_FP_0725,
          fc_mes0725,
          fc_msgPreambleFPe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_FCP,
          ERRID_LOG_HDW_ERR };

/*
msgName: fc_mes0726
message:  INQUIRY SN cmd failed
descript: The INQUIRY Serial Number (page x83) failed.
data:     (1) ulpStatus (2) fcpi_parm (3) m_target (4) m_lun
severity: Error
log:      Always
module:   fcscsib.c
action:   Check if target device supports this command
*/
char      fc_mes0726[] = "%sINQUIRY SN cmd failed Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0726= {
          FC_LOG_MSG_FP_0726,
          fc_mes0726,
          fc_msgPreambleFPe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_FCP,
          ERRID_LOG_HDW_ERR };

/*
msgName: fc_mes0727
message:  INQUIRY Page 0 cmpl
descript: An INQUIRY (page 0) completed. This information is saved by 
          the driver. 
data:     (1) scsi_id (2) lun_id (3) statLocalError (4) cmd + WD7
severity: Information
log:      LOG_FCP verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0727[] = "%sINQUIRY Page 0 cmpl Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0727 = {
          FC_LOG_MSG_FP_0727,
          fc_mes0727,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0728
message:  INQUIRY Page 0 cmd failed
descript: The INQUIRY (page 0) failed.
data:     (1) ulpStatus (2) fcpi_parm (3) scsi_id (4) lun_id
severity: Error
log:      Always
module:   fcscsib.c
action:   Check if target device supports this command
*/
char      fc_mes0728[] = "%sINQUIRY Page 0 cmd failed Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0728= {
          FC_LOG_MSG_FP_0728,
          fc_mes0728,
          fc_msgPreambleFPe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_FCP,
          ERRID_LOG_HDW_ERR };

/*
msgName: fc_mes0729
message:  FCP cmd <Cbd0> failed on device (<sid>, <lun_id>) DID <did>
descript: The specifed device failed an FCP command. 
data:     (1) rspInfo3 (2) statLocalError (3) *cmd + WD6 (4) *cmd + WD7 
severity: Warning
log:      LOG_FCP verbose
module:   fcscsib.c
action:   Check the state of the target in question.
*/
char      fc_mes0729[] = "%sFCP cmd x%x failed on device (%d, %d), DID x%x Data: x%x x%x x%x x%x";
msgLogDef fc_msgBlk0729= {
          FC_LOG_MSG_FP_0729,
          fc_mes0729,
          fc_msgPreambleFPw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0730
message:  FCP command failed: RSP
descript: The FCP command failed with a response error.
data:     (1) lp[2] (2) lp[3] (3) lp[4] (4) lp[5]
severity: Warning
log:      LOG_FCP verbose
module:   fcscsib.c
action:   Check the state of the target in question.
*/
char      fc_mes0730[] = "%sFCP command failed: RSP Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0730= {
          FC_LOG_MSG_FP_0730,
          fc_mes0730,
          fc_msgPreambleFPw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0731
message:  FCP command failed: SNS
descript: The FCP command failed with sense information.
data:     (1) lp[0] (2) lp[1] (3) lp[2] (4) lp[3] 
          (5) lp[4] (6) lp[5] (7) lp6[6] (8) lp[7]
severity: Warning
log:      LOG_FCP verbose
module:   fcscsib.c
action:   Check the state of the target in question.
*/
char      fc_mes0731[] = "%sFCP command failed: SNS Data: x%x x%x x%x x%x x%x x%x x%x x%x";
msgLogDef fc_msgBlk0731= {
          FC_LOG_MSG_FP_0731,
          fc_mes0731,
          fc_msgPreambleFPw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0732
message:  Retry FCP command due to 29,00 check condition
descript: The issued FCP command got a 29,00 check condition and will 
          be retried by the driver.
data:     (1) *lp (2) *lp+1 (3) *lp+2 (4) *lp+3
severity: Information
log:      LOG_FCP verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0732[] = "%sRetry FCP command due to 29,00 check condition Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0732 = {
          FC_LOG_MSG_FP_0732,
          fc_mes0732,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0733
message:  FCP Read Underrun
descript: The issued FCP command returned a Read Underrun
data:     (1) *cmd + WD7 (2) ulpContext (3) rspResId (4) fcpi_parm
severity: Information
log:      LOG_FCP verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0733[] = "%sFCP Read Underrun Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0733 = {
          FC_LOG_MSG_FP_0733,
          fc_mes0733,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0734
message:  FCP Read Check Error
descript: The issued FCP command returned a Read Check Error
data:     (1) *cmd + WD7 (2) ulpContext (3) rspResId (4) fcpi_parm
severity: Error
log:      Always
module:   fcscsib.c
action:   Check the state of the target in question.
*/
char      fc_mes0734[] = "%sFCP Read Check Error Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0734= {
          FC_LOG_MSG_FP_0734,
          fc_mes0734,
          fc_msgPreambleFPe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_FCP,
          ERRID_LOG_HDW_ERR };

/*
msgName: fc_mes0735
message:  FCP Read Check Error with Check Condition
descript: The issued FCP command returned a Read Check Error and a 
          Check condition.
data:     (1) *cmd + WD7 (2) ulpContext (3) rspResId (4) fcpi_parm
severity: Error
log:      Always
module:   fcscsib.c
action:   Check the state of the target in question.
*/
char      fc_mes0735[] = "%sFCP Read Check Error with Check Condition Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0735= {
          FC_LOG_MSG_FP_0735,
          fc_mes0735,
          fc_msgPreambleFPe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_FCP | LOG_CHK_COND,
          ERRID_LOG_HDW_ERR };

/*
msgName: fc_mes0736
message:  FCP QUEUE Full
descript: Received a Queue Full status from the FCP device.
data:     (1) fcp_cur_queue_depth (2) active_io_count (3) flags (4) a_current
severity: Information
log:      LOG_FCP verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0736[] = "%sFCP QUEUE Full Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0736 = {
          FC_LOG_MSG_FP_0736,
          fc_mes0736,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0737
message:  FCP error: Check condition
descript: The issued FCP command resulted in a Check Condition.
data:     (1) *cmd + WD7 (2) ulpIoTag (3) ulpContext (4) statLocalError
severity: Information
log:      LOG_FCP | LOG_CHK_COND verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0737[] = "%sFCP error: Check condition Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0737 = {
          FC_LOG_MSG_FP_0737,
          fc_mes0737,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP | LOG_CHK_COND,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0738
message:  29,00 Check condition received
descript: The received check condition indicates the device was powered 
          on or reset.
data:     (1) lp[0] (2) lp[1] (3) lp[2] (4) lp[3]
severity: Information
log:      LOG_FCP | LOG_CHK_COND verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0738[] = "%s29,00 Check condition received Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0738 = {
          FC_LOG_MSG_FP_0738,
          fc_mes0738,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP | LOG_CHK_COND,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0739
message:  Check condition received ERR1
descript: The command SCSI3_PERSISTENT_RESERVE_IN resulted in a Invalid 
          Command operation code check condition.
data:     (1) lp[0] (2) lp[1] (3) lp[2] (4) lp[3]
severity: Information
log:      LOG_FCP | LOG_CHK_COND verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0739[] = "%sCheck condition received ERR1 Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0739 = {
          FC_LOG_MSG_FP_0739,
          fc_mes0739,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP | LOG_CHK_COND,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0740
message:  Check condition received ERR2
descript: The check condition meets the criteria for the configuration 
          parameters lpfc_check_cond_err and lpfc_delay_rsp_err.
data:     (1) lp[0] (2) lp[1] (3) lp[2] (4) lp[3]
severity: Information
log:      LOG_FCP | LOG_CHK_COND verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0740[] = "%sCheck condition received ERR2 Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0740 = {
          FC_LOG_MSG_FP_0740,
          fc_mes0740,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP | LOG_CHK_COND,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0741
message:  Check condition received
descript: The issued FCP command resulted in a Check Condition.
data:     (1) lp[0] (2) lp[1] (3) lp[2] (4) lp[3]
severity: Information
log:      LOG_FCP | LOG_CHK_COND verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0741[] = "%sCheck condition received Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0741 = {
          FC_LOG_MSG_FP_0741,
          fc_mes0741,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP | LOG_CHK_COND,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0742
message:  FCP completion error
descript: An FCP command completed with a status error in the IOCB. 
data:     (1) ulpStatus (2) ulpWord[4] (3) did.
severity: Information
log:      LOG_FCP verbose
module:   fcscsib.c
action:   If there are many errors to one device, check physical 
          connections to Fibre Channel network and the state of the 
          remote PortID.
*/
char      fc_mes0742[] = "%sFCP completion error Data: x%x x%x x%x"; 
msgLogDef fc_msgBlk0742 = {
          FC_LOG_MSG_FP_0742,
          fc_mes0742,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0743
message:  FCP completion error
descript: An FCP command completed with a status error in the IOCB. 
data:     (1) ulpStatus (2) ulpWord[4] (3) did.
severity: Information
log:      LOG_FCP verbose
module:   fcscsib.c
action:   If there are many errors to one device, check physical 
          connections to Fibre Channel network and the state of the 
          remote PortID.
*/
char      fc_mes0743[] = "%sFCP completion error Data: x%x x%x x%x"; 
msgLogDef fc_msgBlk0743 = {
          FC_LOG_MSG_FP_0743,
          fc_mes0743,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_HDW_ERR };

/*
msgName: fc_mes0744
message:  FCP completion error
descript: An FCP command completed with a status error in the IOCB. 
data:     (1) did (2) *lp (3) *(lp+2) (4) *(lp+3)
severity: Information
log:      LOG_FCP verbose
module:   fcscsib.c
action:   If there are many errors to one device, check physical 
          connections to Fibre Channel network and the state of the 
          remote PortID.
*/
char      fc_mes0744[] = "%sFCP completion error Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0744 = {
          FC_LOG_MSG_FP_0744,
          fc_mes0744,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0745
message:  FCP completion error
descript: An FCP command completed with a status error in the IOCB. 
data:     (1) ulpStatus (2) ulpWord[4] (3) did.
severity: Information
log:      LOG_FCP verbose
module:   fcscsib.c
action:   If there are many errors to one device, check physical 
          connections to Fibre Channel network and the state of the 
          remote PortID.
*/
char      fc_mes0745[] = "%sFCP completion error Data: x%x x%x x%x"; 
msgLogDef fc_msgBlk0745 = {
          FC_LOG_MSG_FP_0745,
          fc_mes0745,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_HDW_ERR };

/*
msgName: fc_mes0746
message:  FCP completion error
descript: An FCP command completed with a status error in the IOCB. 
data:     (1) ulpStatus (2) ulpWord[4] (3) did.
severity: Information
log:      LOG_FCP verbose
module:   fcscsib.c
action:   If there are many errors to one device, check physical 
          connections to Fibre Channel network and the state of the 
          remote PortID.
*/
char      fc_mes0746[] = "%sFCP completion error Data: x%x x%x x%x"; 
msgLogDef fc_msgBlk0746 = {
          FC_LOG_MSG_FP_0746,
          fc_mes0746,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0747
message:  Cmpl Target Reset
descript: A driver initiated Target Reset completed.
data:     (1) scsi_id (2) lun_id (3) statLocalError (4) *cmd + WD7
severity: Information
log:      LOG_FCP verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0747[] = "%sCmpl Target Reset Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0747 = {
          FC_LOG_MSG_FP_0747,
          fc_mes0747,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0748
message:  Cmpl LUN Reset
descript: A driver initiated LUN Reset completed.
data:     (1) scsi_id (2) lun_id (3) statLocalError (4) *cmd + WD7
severity: Information
log:      LOG_FCP verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0748[] = "%sCmpl LUN Reset Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0748 = {
          FC_LOG_MSG_FP_0748,
          fc_mes0748,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0749
message:  Cmpl Abort Task Set
descript: A driver initiated Abort Task Set completed.
data:     (1) scsi_id (2) lun_id (3) statLocalError (4) *cmd + WD7
severity: Information
log:      LOG_FCP verbose
module:   fcscsib.c
action:   None required
*/
char      fc_mes0749[] = "%sCmpl Abort Task Set Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0749 = {
          FC_LOG_MSG_FP_0749,
          fc_mes0749,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0750
message:  EXPIRED linkdown timer
descript: The link was down for greater than the configuration parameter 
          (lpfc_linkdown_tmo) seconds. All I/O associated with the devices
          on this link will be failed.  
data:     (1) fc_ffstate
severity: Information
log:      LOG_FCP | LOG_LINK_EVENT verbose
module:   fcscsib.c
action:   Check HBA cable/connection to Fibre Channel network.
*/
char      fc_mes0750[] = "%sEXPIRED linkdown timer Data: x%x"; 
msgLogDef fc_msgBlk0750 = {
          FC_LOG_MSG_FP_0750,
          fc_mes0750,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP | LOG_LINK_EVENT,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0751
message:  EXPIRED nodev timer
descript: A device disappeared for greater than the configuration parameter 
          (lpfc_nodev_tmo) seconds. All I/O associated with this device 
          will be failed.  
data:     (1) ndlp (2) nlp_flag (3) nlp_state (4) nlp_DID
severity: Information
log:      LOG_FCP verbose
module:   fcscsib.c
action:   Check physical connections to Fibre Channel network and the 
          state of the remote PortID.
*/
char      fc_mes0751[] = "%sEXPIRED nodev timer Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0751 = {
          FC_LOG_MSG_FP_0751,
          fc_mes0751,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0752
message:  Device disappeared, nodev timeout
descript: A device disappeared for greater than the configuration 
          parameter (lpfc_nodev_tmo) seconds. All I/O associated with 
          this device will be failed.  
data:     (1) did (2) sid (3) pan (4) a_current
severity: Information
log:      LOG_FCP verbose
module:   fcscsib.c
action:   Check physical connections to Fibre Channel network and the 
          state of the remote PortID.
*/
char      fc_mes0752[] = "%sDevice disappeared, nodev timeout Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0752 = {
          FC_LOG_MSG_FP_0752,
          fc_mes0752,
          fc_msgPreambleFPi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0753
message:  Inquiry Serial Number: invalid length
descript: An INQUIRY SN command completed with an invalid serial number length.
data:     (1) sizeSN (2) j (3) scsi_id (4) lun_id
severity: Error
log:      Always
module:   fcscsib.c
action:   Check state of target in question.  
*/
char      fc_mes0753[] = "%sInquiry Serial Number: invalid length Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0753= {
          FC_LOG_MSG_FP_0753,
          fc_mes0753,
          fc_msgPreambleFPe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_FCP,
          ERRID_LOG_HDW_ERR };

/*
msgName: fc_mes0754
message:  SCSI timeout 
descript: An FCP IOCB command was posted to a ring and did not complete 
          within ULP timeout seconds.
data:     (1) did (2) sid
severity: Warning
log:      LOG_FCP verbose
module:   fcscsib.c
action:   If no I/O is going through the adapter, reboot the system; 
          otherwise check the state of the target in question. 
*/
char      fc_mes0754[] = "%sSCSI timeout Data: x%x x%x"; 
msgLogDef fc_msgBlk0754 = {
          FC_LOG_MSG_FP_0754,
          fc_mes0754,
          fc_msgPreambleFPw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_FCP,
          ERRID_LOG_TIMEOUT };

/*
msgName: fc_mes0756
message:  Local_timeout Skipping clock tick
descript: The DPC thread has not been scheduled within several seconds
data:     (1) dpc_ha_copy (2) ha_copy (3) dpc_cnt (4) fc_ffstate
severity: Warning
log:      LOG_FCP verbose
module:   fcLINUXfcp.c
action:   Check the state of the target in question.
*/
char      fc_mes0756[] = "%sLocal_timeout Skipping clock tick Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0756= {
          FC_LOG_MSG_FP_0756,
          fc_mes0756,
          fc_msgPreambleFPw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_FCP,
          ERRID_LOG_UNEXPECT_EVENT };

/*
 *  UNUSED 0800
 */

/*
 *  Begin NODE LOG Message Structures
 */

/*
msgName: fc_mes0900
message:  FIND node rpi
descript: The driver is looking up the node table entry for a remote 
          NPORT based on its RPI.
data:     (1) ndlp (2) rpi
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None requird
*/
char      fc_mes0900[] = "%sFIND node rpi Data: x%x x%x"; 
msgLogDef fc_msgBlk0900 = {
          FC_LOG_MSG_ND_0900,
          fc_mes0900,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0901
message:  Free node tbl
descript: The driver is freeing a node table entry.
data:     (1) nlp_DID (2) nlp_flag (3) nlp_Rpi (4) data1
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0901[] = "%sFree node tbl Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0901 = {
          FC_LOG_MSG_ND_0901,
          fc_mes0901,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0902
message:  Free node IEEE
descript: The driver freeing a node table entry.
data:     (1) IEEE[2] (2) IEEE[3] (3) IEEE[4] (4) IEEE[5] 
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0902[] = "%sFree node IEEE Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0902 = {
          FC_LOG_MSG_ND_0902,
          fc_mes0902,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0903
message:  BIND node tbl 
descript: The driver is putting the node table entry on the binding list.
data:     (1) nlp (2) nlp_DID (3) nlp_flag (4) data1
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0903[] = "%sBIND node tbl Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0903= {
          FC_LOG_MSG_ND_0903,
          fc_mes0903,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0904
message:  UNMAP node tbl
descript: The driver is putting the node table entry on the unmapped node list.
data:     (1) nlp (2) nlp_DID (3) nlp_flag (4) data1
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0904[] = "%sUNMAP node tbl Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0904 = {
          FC_LOG_MSG_ND_0904,
          fc_mes0904,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0905
message:  MAP node tbl
descript: The driver is putting the node table entry on the mapped node list.
data:     (1) nlp (2) nlp_DID (3) nlp_flag (4) data1
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0905[] = "%sMAP node tbl Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0905 = {
          FC_LOG_MSG_ND_0905,
          fc_mes0905,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0906
message:  FIND node DID unmapped
descript: The driver is searching for a node table entry, on the 
          unmapped node list, based on DID.
data:     (1) nlp (2) nlp_DID (3) nlp_flag (4) data1
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0906[] = "%sFIND node DID unmapped Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0906 = {
          FC_LOG_MSG_ND_0906,
          fc_mes0906,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0907
message:  FIND node DID mapped
descript: The driver is searching for a node table entry, on the 
          mapped node list, based on DID.
data:     (1) nlp (2) nlp_DID (3) nlp_flag (4) data1
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0907[] = "%sFIND node DID mapped Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0907 = {
          FC_LOG_MSG_ND_0907,
          fc_mes0907,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0908
message:  FIND node DID bind
descript: The driver is searching for a node table entry, on the 
          binding list, based on DID.
data:     (1) nlp (2) nlp_DID (3) nlp_flag (4) data1
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0908[] = "%sFIND node DID bind Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0908 = {
          FC_LOG_MSG_ND_0908,
          fc_mes0908,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0909
message:  FIND node did <did> NOT FOUND
descript: The driver was searching for a node table entry based on DID 
          and the entry was not found.
data:     (1) order
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0909[] = "%sFIND node did x%x NOT FOUND Data: x%x"; 
msgLogDef fc_msgBlk0909 = {
          FC_LOG_MSG_ND_0909,
          fc_mes0909,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0910
message:  FIND node scsi_id unmapped
descript: The driver is searching for a node table entry, on the 
          unmapped node list, based on the SCSI ID.
data:     (1) nlp (2) nlp_DID (3) nlp_flag (4) data1
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0910[] = "%sFIND node scsi_id unmapped Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0910 = {
          FC_LOG_MSG_ND_0910,
          fc_mes0910,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0911
message:  FIND node scsi_id mapped
descript: The driver is searching for a node table entry, on the 
          mapped node list, based on the SCSI ID.
data:     (1) nlp (2) nlp_DID (3) nlp_flag (4) data1
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0911[] = "%sFIND node scsi_id mapped Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0911 = {
          FC_LOG_MSG_ND_0911,
          fc_mes0911,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0912
message:  FIND node scsi_id bind
descript: The driver is searching for a node table entry, on the 
          binding list, based on the SCSI ID.
data:     (1) nlp (2) nlp_DID (3) nlp_flag (4) data1
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0912[] = "%sFIND node scsi_id bind Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0912 = {
          FC_LOG_MSG_ND_0912,
          fc_mes0912,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0913
message:  FIND node scsi_id NOT FOUND
descript: The driver was searching for a node table entry based on SCSI ID 
          and the entry was not found.
data:     (1) scsid (2) order
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0913[] = "%sFIND node scsi_id NOT FOUND Data: x%x x%x"; 
msgLogDef fc_msgBlk0913 = {
          FC_LOG_MSG_ND_0913,
          fc_mes0913,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0914
message:  FIND node wwnn unmapped
descript: The driver is searching for a node table entry, on the 
          unmapped port list, based on the WWNN.
data:     (1) nlp (2) nlp_DID (3) nlp_flag (4) data1
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0914[] = "%sFIND node wwnn unmapped Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0914 = {
          FC_LOG_MSG_ND_0914,
          fc_mes0914,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0915
message:  FIND node wwnn mapped
descript: The driver is searching for a node table entry, on the 
          mapped port list, based on the WWNN.
data:     (1) nlp (2) nlp_DID (3) nlp_flag (4) data1
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0915[] = "%sFIND node wwnn mapped Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0915 = {
          FC_LOG_MSG_ND_0915,
          fc_mes0915,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0916
message:  FIND node wwnn bind
descript: The driver is searching for a node table entry, on the 
          binding list, based on the WWNN.
data:     (1) nlp (2) nlp_DID (3) nlp_flag (4) data1
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0916[] = "%sFIND node wwnn bind Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0916 = {
          FC_LOG_MSG_ND_0916,
          fc_mes0916,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0917
message:  PUT END nodelist
descript: The driver is freeing a node table entry buffer.
data:     (1) bp (2) fc_free
severity: Information
log:      LOG_NODE verbose
module:   fcmemb.c
action:   None required
*/
char      fc_mes0917[] = "%sPUT END nodelist Data: x%x x%x"; 
msgLogDef fc_msgBlk0917 = {
          FC_LOG_MSG_ND_0917,
          fc_mes0917,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0918
message:  FIND node wwnn NOT FOUND
descript: The driver was searching for a node table entry based on WWNN 
          and the entry was not found.
data:     (1) order
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0918[] = "%sFIND node wwnn NOT FOUND Data: x%x"; 
msgLogDef fc_msgBlk0918 = {
          FC_LOG_MSG_ND_0918,
          fc_mes0918,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0919
message:  FIND node wwpn unmapped
descript: The driver is searching for a node table entry, on the 
          unmapped port list, based on the WWPN.
data:     (1) nlp (2) nlp_DID (3) nlp_flag (4) data1
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0919[] = "%sFIND node wwpn unmapped Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0919 = {
          FC_LOG_MSG_ND_0919,
          fc_mes0919,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0920
message:  FIND node wwpn mapped
descript: The driver is searching for a node table entry, on the 
          mapped port list, based on the WWPN.
data:     (1) nlp (2) nlp_DID (3) nlp_flag (4) data1
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0920[] = "%sFIND node wwpn mapped Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0920 = {
          FC_LOG_MSG_ND_0920,
          fc_mes0920,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0921
message:  FIND node wwpn bind
descript: The driver is searching for a node table entry, on the 
          binding list, based on the WWPN.
data:     (1) nlp (2) nlp_DID (3) nlp_flag (4) data1
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0921[] = "%sFIND node wwpn bind Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0921 = {
          FC_LOG_MSG_ND_0921,
          fc_mes0921,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0922
message:  FIND node wwpn NOT FOUND
descript: The driver was searching for a node table entry based on WWPN 
          and the entry was not found.
data:     (1) order
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0922[] = "%sFIND node wwpn NOT FOUND Data: x%x"; 
msgLogDef fc_msgBlk0922 = {
          FC_LOG_MSG_ND_0922,
          fc_mes0922,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0923
message:  FIND node xri unmapped
descript: The driver is searching for a node table entry, on the 
          unmapped port list, based on the XRI.
data:     (1) nlp (2) nlp_Xri (3) nlp_flag (4) data1
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0923[] = "%sFIND node xri unmapped Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0923 = {
          FC_LOG_MSG_ND_0923,
          fc_mes0923,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0924
message:  FIND node xri mapped
descript: The driver is searching for a node table entry, on the 
          mapped port list, based on the XRI.
data:     (1) nlp (2) nlp_Xri (3) nlp_flag (4) data1
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0924[] = "%sFIND node xri mapped Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0924 = {
          FC_LOG_MSG_ND_0924,
          fc_mes0924,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0925
message:  FIND node xri bind
descript: The driver is searching for a node table entry, on the 
          binding list, based on the XRI.
data:     (1) nlp (2) nlp_Xri (3) nlp_flag (4) data1
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0925[] = "%sFIND node xri bind Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk0925 = {
          FC_LOG_MSG_ND_0925,
          fc_mes0925,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0926
message:  FIND node xri NOT FOUND
descript: The driver was searching for a node table entry based on the 
          XRI and the entry was not found.
data:     (1) xri (2) order
severity: Information
log:      LOG_NODE verbose
module:   fcrpib.c
action:   None required
*/
char      fc_mes0926[] = "%sFIND node xri NOT FOUND Data: x%x x%x"; 
msgLogDef fc_msgBlk0926 = {
          FC_LOG_MSG_ND_0926,
          fc_mes0926,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0927
message:  GET nodelist
descript: The driver is allocating a buffer to hold a node table entry.
data:     (1) bp (2) fc_free
severity: Information
log:      LOG_NODE verbose
module:   fcmemb.c
action:   None required
*/
char      fc_mes0927[] = "%sGET nodelist Data: x%x x%x"; 
msgLogDef fc_msgBlk0927 = {
          FC_LOG_MSG_ND_0927,
          fc_mes0927,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes0928
message:  PUT nodelist
descript: The driver is freeing a node table entry buffer.
data:     (1) bp (2) fc_free
severity: Information
log:      LOG_NODE verbose
module:   fcmemb.c
action:   None required
*/
char      fc_mes0928[] = "%sPUT nodelist Data: x%x x%x"; 
msgLogDef fc_msgBlk0928 = {
          FC_LOG_MSG_ND_0928,
          fc_mes0928,
          fc_msgPreambleNDi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_NODE,
          ERRID_LOG_UNEXPECT_EVENT };



/*
 *  Begin MISC LOG message structures
 */

/*
msgName: fc_mes1200
message:  Cannot unload driver while lpfcdiag Interface is active Data
descript: An attempt was made to unload the driver while the DFC 
          interface was active.
data:     (1) lpfcdiag_cnt (2) instance
severity: Error
log:      Always
module:   fcLINUXfcp.c
action:   Exit any application that uses the DFC diagnostic interface 
          before attempting to unload the driver.
*/
char      fc_mes1200[] = "%sCannot unload driver while lpfcdiag Interface is active Data: x%x x%x";
msgLogDef fc_msgBlk1200 = {
          FC_LOG_MSG_MI_1200,
          fc_mes1200,
          fc_msgPreambleMIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_MISC,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes1201
message:  lpfc_kmalloc: Bad p_dev_ctl
descript: The driver manages its own memory for internal usage. This 
          error indicates a problem occurred in the driver memory 
          management routines. This error could also indicate the host 
          system in low on memory resources.
data:     (1) size (2) type (3) fc_idx_dmapool
severity: Error
log:      Always
module:   fcLINUXfcp.c
action:   This error could indicate a driver or host operating system 
          problem. If problems persist report these errors to Technical 
          Support.
*/
char      fc_mes1201[] = "%slpfc_kmalloc: Bad p_dev_ctl Data: x%x x%x x%x";
msgLogDef fc_msgBlk1201 = {
          FC_LOG_MSG_MI_1201,
          fc_mes1201,
          fc_msgPreambleMIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_MISC,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes1202
message:  lpfc_kmalloc: Bad size
descript: The driver manages its own memory for internal usage. This 
          error indicates a problem occurred in the driver memory 
          management routines. This error could also indicate the host 
          system in low on memory resources.
data:     (1) size (2) type (3) fc_idx_dmapool
severity: Error
log:      Always
module:   fcLINUXfcp.c
action:   This error could indicate a driver or host operating system 
          problem. If problems persist report these errors to Technical 
          Support.
*/
char      fc_mes1202[] = "%slpfc_kmalloc: Bad size Data: x%x x%x x%x";
msgLogDef fc_msgBlk1202 = {
          FC_LOG_MSG_MI_1202,
          fc_mes1202,
          fc_msgPreambleMIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_MISC,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes1203
message:  lpfc_kmalloc: Virt addr failed to alloc
descript: The driver manages its own memory for internal usage. This 
          error indicates a problem occurred in the driver memory 
          management routines. This error could also indicate the host 
          system in low on memory resources.
data:     (1) size (2) type
severity: Error
log:      Always
module:   fcLINUXfcp.c
action:   This error could indicate a driver or host operating system 
          problem. If problems persist report these errors to Technical 
          Support.
*/
char      fc_mes1203[] = "%slpfc_kmalloc: Virt addr failed to alloc Data: x%x x%x";
msgLogDef fc_msgBlk1203 = {
          FC_LOG_MSG_MI_1203,
          fc_mes1203,
          fc_msgPreambleMIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_MISC,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes1204
message:  lpfc_kmalloc: Bad virtual addr
descript: The driver manages its own memory for internal usage. This 
          error indicates a problem occurred in the driver memory 
          management routines. This error could also indicate the host 
          system in low on memory resources.
data:     (1) i (2) size ( 3) type (4) fc_idx_dmapool
severity: Error
log:      Always
module:   fcLINUXfcp.c
action:   This error could indicate a driver or host operating system 
          problem. If problems persist report these errors to Technical 
          Support.
*/
char      fc_mes1204[] = "%slpfc_kmalloc: Bad virtual addr Data: x%x x%x x%x x%x";
msgLogDef fc_msgBlk1204 = {
          FC_LOG_MSG_MI_1204,
          fc_mes1204,
          fc_msgPreambleMIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_MISC,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes1205
message:  lpfc_kmalloc: dmapool FULL
descript: The driver manages its own memory for internal usage. This 
          error indicates a problem occurred in the driver memory 
          management routines. This error could also indicate the host 
          system in low on memory resources.
data:     (1) i (2) size (3) type (4) fc_idx_dmapool
severity: Error
log:      Always
module:   fcLINUXfcp.c
action:   This error could indicate a driver or host operating system 
          problem. If problems persist report these errors to Technical 
          Support.
*/
char      fc_mes1205[] = "%slpfc_kmalloc: dmapool FULL Data: x%x x%x x%x x%x";
msgLogDef fc_msgBlk1205 = {
          FC_LOG_MSG_MI_1205,
          fc_mes1205,
          fc_msgPreambleMIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_MISC,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes1206
message:  lpfc_kfree: Bad p_dev_ctl
descript: The driver manages its own memory for internal usage. This 
          error indicates a problem occurred in the driver memory 
          management routines. This error could also indicate the host 
          system in low on memory resources.
data:     (1) size (2) fc_idx_dmapool
severity: Error
log:      Always
module:   fcLINUXfcp.c
action:   This error could indicate a driver or host operating system 
          problem. If problems persist report these errors to Technical 
          Support.
*/
char      fc_mes1206[] = "%slpfc_kfree: Bad p_dev_ctl Data: x%x x%x";
msgLogDef fc_msgBlk1206 = {
          FC_LOG_MSG_MI_1206,
          fc_mes1206,
          fc_msgPreambleMIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_MISC,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes1207
message:  lpfc_kfree: NOT in dmapool
descript: The driver manages its own memory for internal usage. This 
          error indicates a problem occurred in the driver memory 
          management routines. This error could also indicate the host 
          system in low on memory resources.
data:     (1) virt (2) size (3) fc_idx_dmapool
severity: Error
log:      Always
module:   fcLINUXfcp.c
action:   This error could indicate a driver or host operating system 
          problem. If problems persist report these errors to Technical 
          Support.
*/
char      fc_mes1207[] = "%slpfc_kfree: NOT in dmapool Data: x%x x%x x%x";
msgLogDef fc_msgBlk1207 = {
          FC_LOG_MSG_MI_1207,
          fc_mes1207,
          fc_msgPreambleMIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_MISC,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes1208
descript: The CT response returned more data than the user buffer could hold. 
message:  C_CT Request error
data:     (1) dfc_flag (2) 4096
severity: Information
log:      LOG_MISC verbose
module:   dfcdd.c
action:   Modify user application issuing CT request to allow for a larger 
          response buffer.
*/
char      fc_mes1208[] = "%sC_CT Request error Data: x%x x%x"; 
msgLogDef fc_msgBlk1208 = {
          FC_LOG_MSG_MI_1208,
          fc_mes1208,
          fc_msgPreambleMIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_MISC,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes1209
message:  RNID Request error
descript: RNID sent back a response that was larger than the driver supports.
data:     (1) fc_mptr (2) 4096
severity: Information
log:      LOG_MISC verbose
module:   dfcdd.c
action:   None required
*/
char      fc_mes1209[] = "%sRNID Request error Data: x%x x%x"; 
msgLogDef fc_msgBlk1209 = {
          FC_LOG_MSG_MI_1209,
          fc_mes1209,
          fc_msgPreambleMIi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_MISC,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes1210
message:  Convert ASC to hex. Input byte cnt < 1
descript: ASCII string to hex conversion failed. Input byte count < 1.
data:     none
severity: Error
log:      Always
action:   This error could indicate a software driver problem. 
          If problems persist report these errors to Technical Support.
*/
char      fc_mes1210[] = "%sConvert ASC to hex. Input byte cnt < 1"; 
msgLogDef fc_msgBlk1210 = {
          FC_LOG_MSG_MI_1210,
          fc_mes1210,
          fc_msgPreambleMIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_MISC,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes1211
message:  Convert ASC to hex. Input byte cnt > max <num>
descript: ASCII string to hex conversion failed. Input byte count > max <num>.
data:     none
severity: Error
log:      Always
action:   This error could indicate a software driver problem. 
          If problems persist report these errors to Technical Support.
*/
char      fc_mes1211[] = "%sConvert ASC to hex. Input byte cnt > max %d"; 
msgLogDef fc_msgBlk1211 = {
          FC_LOG_MSG_MI_1211,
          fc_mes1211,
          fc_msgPreambleMIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_MISC,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes1212
message:  Convert ASC to hex. Output buffer to small 
descript: ASCII string to hex conversion failed. The output buffer byte 
          size is less than 1/2 of input byte count. Every 2 input chars 
          (bytes) require 1 output byte.
data:     none
severity: Error
log:      Always
action:   This error could indicate a software driver problem. 
          If problems persist report these errors to Technical Support.
*/
char      fc_mes1212[] = "%sConvert ASC to hex. Output buffer too small"; 
msgLogDef fc_msgBlk1212 = {
          FC_LOG_MSG_MI_1212,
          fc_mes1212,
          fc_msgPreambleMIe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_MISC,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes1213
message:  Convert ASC to hex. Input char seq not ASC hex.
descript: The ASCII hex input string contains a non-ASCII hex characters
data:     none
severity: Error configuration
log:      Always
action:   Make neccessary changes to lpfc configuration file.
*/
char      fc_mes1213[] = "%sConvert ASC to hex. Input char seq not ASC hex."; 
msgLogDef fc_msgBlk1213 = {
          FC_LOG_MSG_MI_1213,
          fc_mes1213,
          fc_msgPreambleMIc,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR_CFG,
          LOG_MISC,
          ERRID_LOG_UNEXPECT_EVENT };

/*
 *  Begin LINK LOG Message Structures
 */

/*
msgName: fc_mes1300
message:  Re-establishing Link, timer expired
descript: The driver detected a condition where it had to re-initialize 
          the link.
data:     (1) fc_flag (2) fc_ffstate
severity: Error
log:      Always
module:   fcclockb.c
action:   If numerous link events are occurring, check physical 
          connections to Fibre Channel network.
*/
char      fc_mes1300[] = "%sRe-establishing Link, timer expired Data: x%x x%x"; 
msgLogDef fc_msgBlk1300 = {
          FC_LOG_MSG_LK_1300,
          fc_mes1300,
          fc_msgPreambleLKe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_LINK_EVENT,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes1301
message:  Re-establishing Link
descript: The driver detected a condition where it had to re-initialize 
          the link.
data:     (1) status (2) status1 (3) status2
severity: Information
log:      LOG_LINK_EVENT verbose
module:   lp6000.c
action:   If numerous link events are occurring, check physical 
          connections to Fibre Channel network.
*/
char      fc_mes1301[] = "%sRe-establishing Link Data: x%x x%x x%x"; 
msgLogDef fc_msgBlk1301 = {
          FC_LOG_MSG_LK_1301,
          fc_mes1301,
          fc_msgPreambleLKi,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_INFO,
          LOG_LINK_EVENT,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes1302
message:  Reset link speed to auto. 1G node detected in loop. 
descript: The driver is reinitializing the link speed to auto-detect.
          This acton results if a 2G HBA is configured for a link 
          speed of 2G and the HBA detects a node that does NOT 
          support 2G link speed. All nodes on that loop will come 
          up with a link speed equal to 1G.
data:     none
severity: Warning
log:      LOG_LINK_EVENT verbose
module:   lp6000.c
action:   None required
*/
char      fc_mes1302[] = "%sReset link speed to auto. 1G node detected in loop."; 
msgLogDef fc_msgBlk1302 = {
          FC_LOG_MSG_LK_1302,
          fc_mes1302,
          fc_msgPreambleLKw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_LINK_EVENT,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes1303
message:  Reset link speed to auto. 1G HBA cfg'd for 2G. 
descript: The driver is reinitializing the link speed to auto-detect.
          This acton results if a 1G HBA is configured for 2G 
          link speed operation. All nodes on that loop will come 
          up with a link speed equal to 1G.
data:     none
severity: Warning
log:      LOG_LINK_EVENT verbose
module:   fc<HOST>fcp.c
action:   None required
*/
char      fc_mes1303[] = "%sReset link speed to auto. 1G HBA cfg'd for 2G"; 
msgLogDef fc_msgBlk1303 = {
          FC_LOG_MSG_LK_1303,
          fc_mes1303,
          fc_msgPreambleLKw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_LINK_EVENT,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes1304
message:  Link Up Event received
descript: A link up event was received. It is also possible for 
          multiple link events to be received together. 
data:     (1) eventTag (2) fc_eventTag (3) granted_AL_PA (4) alpa_map[0]
detail:   If multiple link events received, log (1) current event 
          number, (2) last event number received, (3) ALPA granted, 
          (4) number of entries in the loop init LILP ALPA map. 
          An ALPA map message is also recorded if LINK_EVENT 
          verbose mode is set. Each ALPA map message contains 
          16 ALPAs. 
severity: Error
log:      Always
module:   fcscsib.c
action:   If numerous link events are occurring, check physical 
          connections to Fibre Channel network.
*/
char      fc_mes1304[] = "%sLink Up Event received Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk1304 = {
          FC_LOG_MSG_LK_1304,
          fc_mes1304,
          fc_msgPreambleLKe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_LINK_EVENT,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes1305
message:  Link Up Event ALPA map
descript: A link up event was received.
data:     (1) wd1 (2) wd2 (3) wd3 (4) wd4
severity: Warning
log:      LOG_LINK_EVENT verbose
module:   fcscsib.c
action:   If numerous link events are occurring, check physical 
          connections to Fibre Channel network.
*/
char      fc_mes1305[] = "%sLink Up Event ALPA map Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk1305 = {
          FC_LOG_MSG_LK_1305,
          fc_mes1305,
          fc_msgPreambleLKw,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_WARN,
          LOG_LINK_EVENT,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes1306
message:  Link Down Event received
descript: A link down event was received.
data:     (1) eventTag (2) fc_eventTag (3) granted_AL_PA (4) alpa_map[0] 
severity: Error
log:      Always
module:   fcscsib.c
action:   If numerous link events are occurring, check physical 
          connections to Fibre Channel network.
*/
char      fc_mes1306[] = "%sLink Down Event received Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk1306 = {
          FC_LOG_MSG_LK_1306,
          fc_mes1306,
          fc_msgPreambleLKe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_LINK_EVENT,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes1307
message:  SCSI Link Reset
descript: The SCSI layer has determined the link needs to be reset. 
          A LIP is sent to restart loop initialization. 
data:     None
severity: Error
log:      Always
module:   fcscsib.c
action:   None required
*/
char      fc_mes1307[] = "%sSCSI Link Reset";
msgLogDef fc_msgBlk1307 = {
          FC_LOG_MSG_LK_1307,
          fc_mes1307,
          fc_msgPreambleLKe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_LINK_EVENT,
          ERRID_LOG_UNEXPECT_EVENT };

/*
 *  Begin SLI LOG Message Structures
 */

/*
msgName: fc_mes1400
message:  Unknown IOCB command
descript: Received an unknown IOCB command completion.
data:     (1) ulpCommand (2) ulpStatus (3) ulpIoTag (4) ulpContext)
severity: Error
log:      Always
module:   lp6000.c
action:   This error could indicate a software driver or firmware 
          problem. If these problems persist, report these errors 
          to Technical Support.
*/
char      fc_mes1400[] = "%sUnknown IOCB command Data: x%x x%x x%x x%x"; 
msgLogDef fc_msgBlk1400 = {
          FC_LOG_MSG_LK_1400,
          fc_mes1400,
          fc_msgPreambleSLe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_SLI,
          ERRID_LOG_UNEXPECT_EVENT };

/*
msgName: fc_mes1401
message:  Command ring <num> timeout
descript: An IOCB command was posted to a ring and did not complete 
          within a timeout based on RATOV.
data:     (1) IOCB command (2) ulpCommand
severity: Error
log:      Always
module:   fcscsib.c
action:   This error could indicate a software driver or firmware 
          problem. If no I/O is going through the adapter, reboot 
          the system. If these problems persist, report these errors 
          to Technical Support.
*/
char      fc_mes1401[] = "%sCommand ring %d timeout Data: x%x"; 
msgLogDef fc_msgBlk1401 = {
          FC_LOG_MSG_LK_1401,
          fc_mes1401,
          fc_msgPreambleSLe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_SLI,
          ERRID_LOG_TIMEOUT };

/*
msgName: fc_mes1402
message:  Command ring <num> timeout
descript: An IOCB command was posted to a ring and did not complete 
          within a timeout based on RATOV.
data:     None
severity: Error
log:      Always
module:   fcscsib.c
action:   This error could indicate a software driver or firmware 
          problem. If no I/O is going through the adapter, reboot 
          the system. If these problems persist, report these errors 
          to Technical Support.
*/
char      fc_mes1402[] = "%sCommand ring %d timeout";
msgLogDef fc_msgBlk1402 = {
          FC_LOG_MSG_LK_1402,
          fc_mes1402,
          fc_msgPreambleSLe,
          FC_MSG_OPUT_GLOB_CTRL,
          FC_LOG_MSG_TYPE_ERR,
          LOG_SLI,
          ERRID_LOG_TIMEOUT };


