#define __UWSREM_H_

//*********************************************************************
// uwsrem.h                                                           *
//                                                                    *
// Written by Pete Reynolds                                           *
// (C) Copyright IBM Corporation, 1998-2001                           *
//                                                                    *
//  This software may be used and distributed according to the terms  *
//  of the GNU Public License, incorporated herein by reference.      *
//                                                                    *
// Description - This header file provides all global constants and   *
//               data structs for remote graphics support for the     *
//               Service processor device driver.                     *
//                                                                    *
// Changes                                                            *
// -------                                                            *
// 11/08/2001 - Created file.                                         *
//*********************************************************************

//------------------------------------------------------
//  PCI OFFSETS
//------------------------------------------------------
#define CONDOR_MOUSE_DATA_PCI_OFFSET            0x000AC000
#define CONDOR_MOUSE_ISR_CONTROL_OFFSET         0x00
#define CONDOR_MOUSE_ISR_STATUS_OFFSET          0x04
#define CONDOR_MOUSE_Q_READ_PTR_OFFSET          0x08
#define CONDOR_MOUSE_Q_WRITE_PTR_OFFSET         0x0C
#define CONDOR_MOUSE_Q_BEGIN_OFFSET             0x10
#define CONDOR_MOUSE_MAX_X_OFFSET               0x14
#define CONDOR_MOUSE_MAX_Y_OFFSET               0x18

#define CONDOR_INPUT_DESKTOP_INFO_OFFSET        0x1F0
#define CONDOR_INPUT_DISPLAY_RESX_OFFSET        0x1F4
#define CONDOR_INPUT_DISPLAY_RESY_OFFSET        0x1F8
#define CONDOR_INPUT_DISPLAY_BITS_OFFSET        0x1FC
#define CONDOR_OUTPUT_VNC_STATUS_OFFSET         0x200

//------------------------------------------------------
//  MASK DEFINITIONS
//------------------------------------------------------
#define CONDOR_MOUSE_INTR_STATUS_MASK     0x00000001

//------------------------------------------------------
//  TYPES OF REMOTE INPUT DATA
//------------------------------------------------------
#define INPUT_TYPE_MOUSE                  0x01
#define INPUT_TYPE_KEYBD                  0x02

//------------------------------------------------------
//  REMOTE DATA THRESHOLDS AND SIZE DECLARATIONS 
//------------------------------------------------------
#define CONDOR_MOUSE_QUEUE_ENTRY_SIZE    (0x08 * sizeof(UCHAR))
#define MAX_Q_ENTRIES                     0x3C                   // 60 entries
#define MAX_QUEUE_LENGTH                 (4 * MAX_Q_ENTRIES * sizeof(REMOTE_INPUT_DATA) )

//------------------------------------------------------
//  REMOTE MOUSE INDICATOR FLAGS.
//------------------------------------------------------
#define MOUSE_MOVE_RELATIVE               0
#define MOUSE_MOVE_ABSOLUTE               1

//------------------------------------------------------
//  REMOTE MOUSE BUTTONS.
//------------------------------------------------------
#define REMOTE_LEFT                       0x0001
#define REMOTE_MIDDLE                     0x0002
#define REMOTE_RIGHT                      0x0004

//------------------------------------------------------
//  REMOTE MOUSE BUTTON STATE INDICATORS.
//------------------------------------------------------
#define MOUSE_DOUBLE_CLICK_EVENT          0xF0
#define MOUSE_LEFT_BUTTON_DOWN            0x0001                 // Left Button changed to down.
#define MOUSE_LEFT_BUTTON_UP              0x0002                 // Left Button changed to up.
#define MOUSE_RIGHT_BUTTON_DOWN           0x0004                 // Right Button changed to down.
#define MOUSE_RIGHT_BUTTON_UP             0x0008                 // Right Button changed to up.
#define MOUSE_MIDDLE_BUTTON_DOWN          0x0010                 // Middle Button changed to down.
#define MOUSE_MIDDLE_BUTTON_UP            0x0020                 // Middle Button changed to up.

//------------------------------------------------------
// STRUCTURE DECLARATIONS
//------------------------------------------------------
typedef struct _MOUSE_INPUT
{
   unsigned short  mouse_y;               // Bytes 2 and 3 
   unsigned short  mouse_x;               // Bytes 0 and 1 
} MOUSE_INPUT, *PMOUSE_INPUT;



typedef struct _KEYBD_INPUT
{
   unsigned short  keySym;                // Bytes 2 and 3 
   unsigned char  keyFlag;                // Bytes 0 and 1 
   unsigned char  keyDown;
} KEYBD_INPUT, *PKEYBD_INPUT;



typedef struct _INPUT_MESSAGE_HEADER  
{ 
  // DWORD 0  
  union                          
  {
     MOUSE_INPUT m_data;
     KEYBD_INPUT k_data;
  } in_data;

  //DWORD 1
  unsigned char   input_type;          // Byte 3
  unsigned char   pad1;                //
  unsigned char   mouse_buttons;       // Byte 1
  unsigned char   pad3;                // 
                                 
}INPUT_MESSAGE_HEADER, *PINPUT_MESSAGE_HEADER;

typedef struct _MOUSE_INPUT_DATA
{
    unsigned short  UnitId;                    // Unit number. For \Device\PointerPort0  the unit is '0', and so on 
    unsigned short  Flags;                     // Indicator flags. 

   // Start of PHR_186364
   unsigned short   ButtonFlags;
   unsigned short   ButtonData;
   // union                             // This union contains the transition state of the mouse buttons. 
   // {
   //     unsigned long  Buttons;
   //     struct
   //     {
   //         unsigned short   ButtonFlags;
   //         unsigned short   ButtonData;
   //     };
   // };
   // End of PHR_186364

    unsigned long    RawButtons;                 // The raw state of the mouse buttons. 
    long             LastX;                      // The signed relative or absolute motion in the X direction. 
    long             LastY;                      // The signed relative or absolute motion in the Y direction. 
    unsigned long    ExtraInformation;           // Device-specific additional information for the event. 
    unsigned short   EventType;                  // event type  
    unsigned short   Pad0;
} MOUSE_INPUT_DATA, *PMOUSE_INPUT_DATA;


typedef struct _KEYBD_INPUT_DATA
{
    unsigned short  UnitId;                    // Unit number. For \Device\PointerPort0  the unit is '0', and so on
    unsigned short  Flags;                     // Indicator flags. 
    unsigned long  Buttons;                    // The transition state of ??? 
    unsigned long  RawButtons;                 // The raw state of ???? 
    unsigned long  Keysym_code;                // keysym code 
    unsigned char  Keybd_flags;                // flags for special situtations e.g. C-A-D 
    unsigned char  Keybd_down;                 // flags for Up/Down 
    unsigned short  Pad0;
    unsigned long   Pad1;
    unsigned long  ExtraInformation;           // Device-specific additional information for the event. 
} KEYBD_INPUT_DATA, *PKEYBD_INPUT_DATA;



typedef struct _REMOTE_INPUT_DATA
{
   unsigned long  InputType;                   // event type  

   union 
   {
      MOUSE_INPUT_DATA m_input;
      KEYBD_INPUT_DATA k_input;
   } remote_input;

} REMOTE_INPUT_DATA, *PREMOTE_INPUT_DATA;



typedef struct _DISPLAY_DATA
{
    unsigned long   max_x;                     // Maximum x screen resoltion in pixels
    unsigned long   max_y;                     // Maximum y screen resoltion in pixel
    unsigned long   bits_per_pixel;            // Number of bits used to specify color of a pixel
} DISPLAY_DATA, *PDISPLAY_DATA;


typedef struct _REMOTE_CONNECTION_DATA 
{
    unsigned long   isconnected;               // 1 if connection in progress, 0 otherwise
} REMOTE_CONNECTION_DATA, *PREMOTE_CONNECTION_DATA;


//------------------------------------------------------
// MACRO DECLARATIONS 
//------------------------------------------------------
#define TRANSITION_UP(button)     _TRANSITION_UP(PrevMouseButtonState, CurrMouseButtonState, button)
#define TRANSITION_DOWN(button) _TRANSITION_DOWN(PrevMouseButtonState, CurrMouseButtonState, button)

#define _TRANSITION_DOWN(previous, current, button) \
           ((!(previous & button)) && (current & button))

#define _TRANSITION_UP(previous, current, button) \
           ((previous & button) && (!(current & button)))

