#ifndef CM_H
#define CM_H

#include "iobuf.h"
#include "mpi.h"
#include "cipher.h"
#include "keydb.h"
#include <elf.h>

#ifndef TRUE
        #define TRUE    (1)
#endif
#ifndef FALSE
        #define FALSE   (0)
#endif

#define CRYPTOMARK_NAME "CM_MD5Sig"

#define WORDSIZE 4
static inline int
round_up_word (int size)
{
	return (size + ((WORDSIZE - (size % WORDSIZE)) % WORDSIZE));
}

/* cm_sign.c */
int cm_sign_data( const unsigned char *buffer, long length, 
		  unsigned char **outbuf, long *outlen, STRLIST locusr);

/* cm_mainproc.c */
int cm_verify_data( unsigned char *inp, unsigned long size, 
		    unsigned char **data );

/* cm_plaintext.c */
int cm_handle_plaintext_data( PKT_plaintext *pt, md_filter_context_t *mfx,
                   int nooutput, int clearsig, unsigned char **data );

/* cm.c */
int compute_phdr_digest (unsigned long *checkoff, unsigned char digest[],
		                     Elf32_Ehdr * elf_ex, FILE *file);
int read_elf_hdr (Elf32_Ehdr * elf_ex, FILE *fp);
int write_elf_hdr (Elf32_Ehdr * elf_ex, FILE * file);
int read_section_hdr (Elf32_Shdr ** elf_shdata, Elf32_Ehdr * elf_ex, 
			     FILE * file, int bogus_header);
int write_section_hdr (Elf32_Shdr * elf_shdata, Elf32_Ehdr * elf_ex, 
			     FILE * file);
int read_elf_note (Elf32_Nhdr * note, Elf32_Shdr * elf_shdata, FILE * file);
int read_string_table (char ** strtab, Elf32_Shdr * elf_shdr, FILE * file);
int read_enc_digest (unsigned char * encdigest[], Elf32_Nhdr * note, 
			    Elf32_Shdr * elf_shdata, FILE * file);
int is_note_a_signature (Elf32_Nhdr * note, Elf32_Shdr * elf_shdata, 
			 FILE * file);
long shift_and_write (void *data, size_t size, long position, FILE * file);

#endif /* CM_H */
