iconName = 'colorize'
labelText = 'KColorDialog'


from qt import QFrame, QHBoxLayout, QVBoxLayout, SIGNAL
from kdecore import i18n
from kdeui import KPushButton, KColorDialog, KColorPatch, KTextEdit


helpText = ("KDE provides a nifty common color selection dialog."
            "The color selection in the dialog is tracked via a SIGNAL "
            "connected to the KColorPatch area below.")


class MainFrame(QFrame):
    def __init__(self, parent=None):
        QFrame.__init__(self, parent)
        self.button = KPushButton(i18n('Show Color Dialog'), self)
        self.help = KTextEdit(helpText, '', self)
        self.patch = KColorPatch(self)
        layout = QVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = QHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addWidget(self.patch, 10)
        layout.addStretch(1)
        self.connect(self.button, SIGNAL('clicked()'), self.showColorDialog)

    def showColorDialog(self):
        dlg = KColorDialog(self)

        ## this connection is made so that there's a default color
        self.connect(dlg, SIGNAL('colorSelected(const QColor &)'), 
                     self.patch.setPaletteBackgroundColor)
        dlg.setColor(self.patch.paletteBackgroundColor())

        ## this connection is the one that changes the patch color to match 
        ## the color selected in the dialog
        self.connect(dlg, SIGNAL('colorSelected(const QColor &)'), 
                     self.patch.setColor)
        dlg.exec_loop()
