/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import com.hp.hpl.jena.graph.impl.TransactionHandlerBase;
import com.hp.hpl.jena.shared.JenaException;
import java.sql.Connection;
import java.sql.SQLException;
import virtuoso.jena.driver.VirtGraph;

public class VirtTransactionHandler
extends TransactionHandlerBase {
    private VirtGraph graph = null;
    private Boolean m_transactionsSupported = null;

    public VirtTransactionHandler(VirtGraph virtGraph) {
        this.graph = virtGraph;
    }

    public boolean transactionsSupported() {
        if (this.m_transactionsSupported != null) {
            return this.m_transactionsSupported;
        }
        try {
            Connection connection = this.graph.getConnection();
            if (connection != null) {
                this.m_transactionsSupported = new Boolean(connection.getMetaData().supportsMultipleTransactions());
                return this.m_transactionsSupported;
            }
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void begin() {
        if (this.transactionsSupported()) {
            try {
                Connection connection = this.graph.getConnection();
                if (connection.getTransactionIsolation() != 2) {
                    connection.setTransactionIsolation(2);
                }
                if (!connection.getAutoCommit()) return;
                connection.setAutoCommit(false);
                return;
            }
            catch (SQLException sQLException) {
                throw new JenaException("Transaction begin failed: ", (Throwable)sQLException);
            }
        } else {
            this.notSupported("begin transaction");
        }
    }

    public void abort() {
        if (this.transactionsSupported()) {
            try {
                Connection connection = this.graph.getConnection();
                connection.rollback();
                connection.setAutoCommit(true);
            }
            catch (SQLException sQLException) {
                throw new JenaException("Transaction rollback failed: ", (Throwable)sQLException);
            }
        } else {
            this.notSupported("abort transaction");
        }
    }

    public void commit() {
        if (this.transactionsSupported()) {
            try {
                Connection connection = this.graph.getConnection();
                connection.commit();
                connection.setAutoCommit(true);
            }
            catch (SQLException sQLException) {
                throw new JenaException("Transaction commit failed: ", (Throwable)sQLException);
            }
        } else {
            this.notSupported("commit transaction");
        }
    }

    private void notSupported(String string) {
        throw new UnsupportedOperationException(string);
    }
}

