/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import virtuoso.jdbc3.VirtuosoConnection;
import virtuoso.jdbc3.VirtuosoException;
import virtuoso.jdbc3.VirtuosoOutputStream;

public class VirtuosoExplicitString {
    private int dtp;
    private byte[] bytes;
    private String str;
    private VirtuosoConnection con;

    protected VirtuosoExplicitString(byte[] byArray, int n) {
        this.dtp = n;
        this.bytes = byArray;
        this.str = null;
    }

    protected VirtuosoExplicitString(String string, int n, VirtuosoConnection virtuosoConnection) throws VirtuosoException {
        try {
            this.dtp = n;
            this.con = virtuosoConnection;
            if (n == 225 || n == 226 || n == 132) {
                this.bytes = string.getBytes("UTF8");
                this.dtp = this.bytes.length < 256 ? 225 : 226;
                this.str = string;
            } else if (n == 182 || n == 181 || n == 238 || n == 183 || n == 125) {
                if (virtuosoConnection != null && virtuosoConnection.charset_utf8) {
                    this.bytes = string.getBytes("UTF8");
                } else if (virtuosoConnection != null && virtuosoConnection.charset != null) {
                    this.bytes = virtuosoConnection.charsetBytes(string);
                } else {
                    this.cli_wide_to_narrow(string, virtuosoConnection != null ? virtuosoConnection.client_charset_hash : null);
                }
                this.dtp = this.bytes.length < 256 ? 181 : 182;
            } else if (n == 131 || n == 222) {
                this.bytes = string.getBytes("8859_1");
                this.dtp = this.bytes.length < 256 ? 181 : 182;
            } else if (!this.cli_wide_to_narrow(string, virtuosoConnection != null ? virtuosoConnection.client_charset_hash : null)) {
                this.bytes = string.getBytes("UTF8");
                this.dtp = this.bytes.length < 256 ? 225 : 226;
                this.str = string;
            } else {
                if (virtuosoConnection != null && virtuosoConnection.charset != null) {
                    this.bytes = virtuosoConnection.charsetBytes(string);
                }
                this.dtp = this.bytes.length < 256 ? 181 : 182;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (virtuosoConnection != null && virtuosoConnection.charset != null) {
                this.bytes = virtuosoConnection.charsetBytes(string);
            } else {
                this.cli_wide_to_narrow(string, virtuosoConnection != null ? virtuosoConnection.client_charset_hash : null);
            }
            n = this.bytes.length < 256 ? 181 : 182;
        }
    }

    protected boolean cli_wide_to_narrow(String string, Hashtable hashtable) {
        boolean bl = true;
        if (string == null) {
            this.bytes = new byte[0];
            return true;
        }
        this.bytes = new byte[string.length()];
        if (hashtable == null) {
            for (int i = 0; i < string.length(); ++i) {
                this.bytes[i] = (byte)string.charAt(i);
            }
        } else {
            for (int i = 0; i < string.length(); ++i) {
                Byte by;
                Character c = new Character(string.charAt(i));
                Byte by2 = by = hashtable != null ? hashtable.get(c) : new Byte((byte)c.charValue());
                if (by == null) {
                    this.bytes[i] = 63;
                    bl = false;
                    continue;
                }
                this.bytes[i] = (byte)by.intValue();
            }
        }
        return bl;
    }

    protected boolean cli_wide_to_escaped(String string, Hashtable hashtable) {
        int n;
        boolean bl = true;
        if (string == null) {
            this.bytes = new byte[0];
            this.dtp = 181;
            return true;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            Byte by = null;
            if (hashtable != null) {
                Character c2 = new Character(c);
                by = (Byte)hashtable.get(c2);
                if (by == null) {
                    stringBuffer.append("\\x");
                    stringBuffer.append(Integer.toString(c2.charValue(), 16));
                    continue;
                }
                stringBuffer.append((char)by.intValue());
                continue;
            }
            if (c > '\u0100') {
                stringBuffer.append("\\x");
                stringBuffer.append(Integer.toString(c, 16));
                continue;
            }
            stringBuffer.append(c);
        }
        this.bytes = new byte[stringBuffer.length() + 1];
        for (n = 0; n < stringBuffer.length(); ++n) {
            this.bytes[n] = (byte)stringBuffer.charAt(n);
        }
        stringBuffer = null;
        this.dtp = this.bytes.length < 256 ? 181 : 182;
        return true;
    }

    protected int getDtp() {
        return this.dtp;
    }

    protected void write(VirtuosoOutputStream virtuosoOutputStream) throws IOException {
        virtuosoOutputStream.write(this.dtp);
        if (this.bytes.length < 256) {
            virtuosoOutputStream.write(this.bytes.length);
        } else {
            virtuosoOutputStream.writelongint(this.bytes.length);
        }
        if ((this.dtp == 225 || this.dtp == 226) && this.str != null) {
            for (int i = 0; i < this.str.length(); ++i) {
                byte[] byArray = this.str.substring(i, i + 1).getBytes("UTF8");
                if (byArray == null) continue;
                virtuosoOutputStream.write(byArray, 0, byArray.length);
                virtuosoOutputStream.flush();
            }
        } else {
            virtuosoOutputStream.write(this.bytes, 0, this.bytes.length);
        }
    }

    public String toString() {
        if (this.str != null) {
            return this.str;
        }
        try {
            if (this.dtp == 225 || this.dtp == 226) {
                return new String(this.bytes, "UTF8");
            }
            if (this.con != null && this.con.charset != null) {
                return this.con.uncharsetBytes(new String(this.bytes, "8859_1"));
            }
            return new String(this.bytes, "8859_1");
        }
        catch (Exception exception) {
            char[] cArray = new char[this.bytes.length];
            for (int i = 0; i < this.bytes.length; ++i) {
                cArray[i] = (char)(this.bytes[i] & 0xFF);
            }
            return new String(cArray);
        }
    }

    public String toParamString() {
        return this.toString().trim();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof VirtuosoExplicitString) {
            VirtuosoExplicitString virtuosoExplicitString = (VirtuosoExplicitString)object;
            if (virtuosoExplicitString.dtp != this.dtp) {
                return false;
            }
            return virtuosoExplicitString.bytes.equals(this.bytes);
        }
        return false;
    }
}

