/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc2;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import virtuoso.jdbc2.VirtuosoConnection;
import virtuoso.jdbc2.VirtuosoException;
import virtuoso.jdbc2.VirtuosoFuture;

public class Driver
implements java.sql.Driver {
    protected static final int major = 3;
    protected static final int minor = 42;
    private String host = "localhost";
    private String port = "1111";
    private String user;
    private String password;
    private String database;
    private String charset;
    private String pwdclear;
    private Integer timeout;
    private Integer log_enable;
    private Integer fbs;
    private Integer sendbs;
    private Integer recvbs;
    private final String VirtPrefix = "jdbc:virtuoso://";

    public Driver() throws SQLException {
        try {
            String string = System.getProperty("JDBC2_LOG");
            if (string != null) {
                System.err.println("RPC logfile=" + string);
                try {
                    VirtuosoFuture.rpc_log = new PrintStream(new BufferedOutputStream(new FileOutputStream(string), 4096));
                }
                catch (Exception exception) {
                    VirtuosoFuture.rpc_log = System.out;
                }
            }
        }
        catch (Exception exception) {
            VirtuosoFuture.rpc_log = null;
        }
    }

    public Connection connect(String string, Properties properties) throws VirtuosoException {
        try {
            if (this.acceptsURL(string)) {
                Properties properties2 = this.urlToInfo(string, properties);
                return new VirtuosoConnection(string, this.host, Integer.parseInt(this.port), properties2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new VirtuosoException("Wrong port number : " + numberFormatException.getMessage(), -11);
        }
        return null;
    }

    public boolean acceptsURL(String string) throws VirtuosoException {
        return string.startsWith("jdbc:virtuoso://");
    }

    protected Properties urlToInfo(String string, Properties properties) {
        char c;
        String string2;
        this.host = "localhost";
        this.port = "1111";
        this.fbs = new Integer(100);
        this.sendbs = new Integer(32768);
        this.recvbs = new Integer(32768);
        Properties properties2 = new Properties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            string2 = properties.getProperty(string3);
            properties2.setProperty(string3.toLowerCase(), string2);
        }
        char c2 = '\u0000';
        string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = string.substring("jdbc:virtuoso://".length());
        boolean bl = true;
        int n = 0;
        while (n < string4.length()) {
            char c3 = string4.charAt(n);
            switch (c3) {
                case '\"': 
                case '\'': {
                    if (c2 == c3) {
                        c2 = '\u0000';
                        break;
                    }
                    if (c2 != '\u0000') break;
                    c2 = c3;
                    break;
                }
                case '/': {
                    if (c2 == '\u0000') {
                        String string5 = stringBuffer.toString().trim();
                        if (string2 == null) {
                            string2 = string5;
                            string5 = "";
                        }
                        if (string2 != null && string2.length() > 0) {
                            if (bl) {
                                bl = false;
                                properties2.setProperty("_vhost", string2);
                            } else {
                                properties2.setProperty(string2.toLowerCase(), string5);
                            }
                        }
                        string2 = null;
                        stringBuffer.setLength(0);
                        break;
                    }
                    stringBuffer.append(c3);
                    break;
                }
                case '=': {
                    if (c2 == '\u0000') {
                        string2 = stringBuffer.toString().trim();
                        stringBuffer.setLength(0);
                        break;
                    }
                    stringBuffer.append(c3);
                    break;
                }
                default: {
                    stringBuffer.append(c3);
                }
            }
            ++n;
        }
        String string6 = stringBuffer.toString().trim();
        if (string2 == null) {
            string2 = string6;
            string6 = "";
        }
        if (string2 != null && string2.length() > 0) {
            if (bl) {
                ((Hashtable)properties2).put("_vhost", string2);
            } else {
                ((Hashtable)properties2).put(string2.toLowerCase(), string6);
            }
        }
        if ((string6 = properties2.getProperty("kpath")) != null && (c = System.getProperty("file.separator").charAt(0)) != '\\') {
            string6 = string6.replace('\\', c);
            ((Hashtable)properties2).put("kpath", string6);
        }
        if ((string6 = properties2.getProperty("ssl")) != null && properties2.getProperty("cert") == null) {
            properties2.setProperty("cert", "");
        }
        if ((string6 = properties2.getProperty("pwdtype")) != null) {
            properties2.setProperty("pwdclear", string6);
        }
        if ((string6 = properties2.getProperty("uid")) != null) {
            properties2.setProperty("user", string6);
        }
        if ((string6 = properties2.getProperty("pwd")) != null) {
            properties2.setProperty("password", string6);
        }
        if ((string6 = properties2.getProperty("cert")) != null) {
            properties2.setProperty("certificate", string6);
        }
        if ((string6 = properties2.getProperty("pass")) != null) {
            properties2.setProperty("keystorepass", string6);
        }
        if ((string6 = properties2.getProperty("kpath")) != null) {
            properties2.setProperty("keystorepath", string6);
        }
        return properties2;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws VirtuosoException {
        if (this.acceptsURL(string)) {
            DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[7];
            if (((Hashtable)properties).get("user") == null) {
                driverPropertyInfoArray[0] = new DriverPropertyInfo("user", null);
                driverPropertyInfoArray[0].required = true;
            }
            if (((Hashtable)properties).get("password") == null) {
                driverPropertyInfoArray[1] = new DriverPropertyInfo("password", null);
                driverPropertyInfoArray[1].required = true;
            }
            if (((Hashtable)properties).get("database") == null) {
                driverPropertyInfoArray[2] = new DriverPropertyInfo("database", null);
                driverPropertyInfoArray[2].required = false;
            }
            return driverPropertyInfoArray;
        }
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[8];
        driverPropertyInfoArray[0] = new DriverPropertyInfo("url", string);
        driverPropertyInfoArray[0].required = true;
        if (((Hashtable)properties).get("user") == null) {
            driverPropertyInfoArray[1] = new DriverPropertyInfo("user", null);
            driverPropertyInfoArray[1].required = true;
        }
        if (((Hashtable)properties).get("password") == null) {
            driverPropertyInfoArray[2] = new DriverPropertyInfo("password", null);
            driverPropertyInfoArray[2].required = true;
        }
        if (((Hashtable)properties).get("database") == null) {
            driverPropertyInfoArray[3] = new DriverPropertyInfo("database", null);
            driverPropertyInfoArray[3].required = false;
        }
        if (((Hashtable)properties).get("fbs") == null) {
            driverPropertyInfoArray[3] = new DriverPropertyInfo("fbs", null);
            driverPropertyInfoArray[3].required = false;
        }
        if (((Hashtable)properties).get("sendbs") == null) {
            driverPropertyInfoArray[3] = new DriverPropertyInfo("sendbs", null);
            driverPropertyInfoArray[3].required = false;
        }
        if (((Hashtable)properties).get("recvbs") == null) {
            driverPropertyInfoArray[3] = new DriverPropertyInfo("recvbs", null);
            driverPropertyInfoArray[3].required = false;
        }
        if (((Hashtable)properties).get("roundrobin") == null) {
            driverPropertyInfoArray[3] = new DriverPropertyInfo("roundrobin", null);
            driverPropertyInfoArray[3].required = false;
        }
        return driverPropertyInfoArray;
    }

    public int getMajorVersion() {
        return 3;
    }

    public int getMinorVersion() {
        return 42;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public static void main(String[] stringArray) {
        System.out.println("OpenLink Virtuoso(TM) Driver for JDBC(TM) Version 2.x [Build 3.42]");
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

