.TH sane\-leo 5 "11 Jul 2008" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane\-leo
.SH NAME
sane\-leo \- SANE backend for LEO Technologies scanners
.SH DESCRIPTION
The
.B sane\-leo
library implements a SANE (Scanner Access Now Easy) backend that
provides access to some LEO SCSI flatbed scanners. This backend
should be considered
.B beta-quality
software! LEO scanners were also sold under the Across Technologies brand.
.PP
The scanners that should work with this backend are:
.PP
.RS
.ft CR
.nf
   Vendor Model           status
----------------------  -----------
  Across FS-1130          tested
  Leo S3                  tested
.fi
.ft R
.RE

The options the backend supports can either be selected through
command line options to programs like scanimage or through GUI
elements in xscanimage or xsane.

.br
If you have any strange behavior, please report to the backend
maintainer or to the SANE mailing list.

Valid command line options and their syntax can be listed by using 
.RS
scanimage \-\-help \-d leo
.RE

.TP
.B Scan Mode

.TP
.B \-\-mode
selects the basic mode of operation of the scanner valid choices are 
.I Black & White
,
.I Grayscale
and
.I Color
The Black & White mode is black and white only (1 bit). Grayscale
will produce 256 levels of gray (8 bits). Color will produce a 24 bits
color image.

.TP
.B \-\-resolution
selects the resolution for a scan. The scanner can do all resolutions
between 1 and 300, in increments of 1.


.TP
.B Geometry options

.TP
.B \-l \-t \-x \-y 
control the scan area: \-l sets the top left x coordinate, \-t the top
left y coordinate, \-x selects the width and \-y the height of the scan
area. All parameters are specified in millimeters by default.


.TP
.B Enhancement options

.TP
.B \-\-custom\-gamma
(grayscale and color mode only) allows the user to specify a gamma table (see the
next 3 parameters).

.TP 
.B \-\-red\-gamma\-table 
(color mode only) can be used to download a user defined
gamma table for the red channel. The table must be 256 bytes long.

.TP 
.B \-\-green\-gamma\-table 
(color mode only) can be used to download a user defined
gamma table for the green channel. The table must be 256 bytes long.

.TP
.B \-\-blue\-gamma\-table 
(color mode only) can be used to download a user defined gamma table
for the blue channel. The table must be 256 bytes long.

.TP
.B \-\-halftone
(Black & White only) select the halftone mask to use. Possible values are 
.I Diamond
,
.I 8x8 Coarse Fatting
,
.I 8x8 Fine Fatting
,
.I 8x8 Bayer
and
.I 8x8 Vertical Line

.TP 
.B \-\-preview
requests a preview scan. The resolution used for that scan is 28 dpi
and the scan area is the maximum allowed. The scan mode is user
selected. The default is "no".


.SH CONFIGURATION FILE
The configuration file @CONFIGDIR@/leo.conf supports only one information: the device name to use (eg /dev/scanner).


.SH FILES
.TP
.I @LIBDIR@/libsane\-leo.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane\-leo.so
The shared library implementing this backend (present on systems that
support dynamic loading).


.SH ENVIRONMENT
.TP
.B SANE_DEBUG_LEO
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend. E.g.,
a value of 128 requests all debug output to be printed. Smaller levels
reduce verbosity.


.SH LIMITATIONS
The windows TWAIN driver has many more options than this SANE
backend. However they are only software adjustments. This backend only
implements what the scanner can support.


.SH BUGS

None known.


.SH "SEE ALSO"

sane\-scsi(5), scanimage(1), xscanimage(1), xsane(1), sane(7)


.SH AUTHOR

.TP
The package is actively maintained by Frank Zago.
.I http://www.zago.net/sane/#leo
