/*
 * Decompiled with CFR 0.152.
 */
package org.xmlsoap.rt;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.misc.NamespaceHandler;
import org.xmlsoap.rt.FixupTable;
import org.xmlsoap.rt.ISoapArrayStream;
import org.xmlsoap.rt.ISoapCompoundStream;
import org.xmlsoap.rt.ISoapDeserializationContext;
import org.xmlsoap.rt.ISoapElement;
import org.xmlsoap.rt.ISoapNodeHandler;
import org.xmlsoap.rt.ISoapPackageStream;
import org.xmlsoap.rt.ISoapResolver;
import org.xmlsoap.rt.ISoapSimpleStream;
import org.xmlsoap.rt.ISoapStreamFactory;
import org.xmlsoap.rt.ParserState;
import org.xmlsoap.rt.SoapTypeMapper;

public class SoapParser
extends SAXParser
implements ISoapDeserializationContext {
    Vector Headers = new Vector();
    Object Body = null;
    ClassLoader classLoader;
    ISoapStreamFactory typeMapper;
    Locator saxLocator = null;
    ISoapNodeHandler currentHandler;
    boolean ignoreNonWhiteSpace = false;
    Stack namespaces = new Stack();
    FixupTable packageForEnvelope = new FixupTable(this);
    Stack packageStack = new Stack();
    String currentID = null;

    public SoapParser(ClassLoader classLoader, ISoapStreamFactory iSoapStreamFactory) throws SAXException {
        this.classLoader = classLoader;
        this.typeMapper = iSoapStreamFactory == null ? SoapTypeMapper.getCurrentTypeMapper() : iSoapStreamFactory;
        Handler handler = new Handler();
        this.setDocumentHandler(handler);
        this.setNamespaceHandler(handler);
        this.setNamespaces(true);
        this.currentHandler = new PreEnvelopeState(this);
        this.packageStack.push(this.packageForEnvelope);
    }

    public void error(String string) throws SAXException {
        throw new SAXParseException(string, this.saxLocator);
    }

    public void finish(Object object) throws SAXException {
        if (!(this.currentHandler instanceof EmbeddedElementUnmarshalState)) {
            this.error("FSM error - not in EmbeddedElement state");
        }
        EmbeddedElementUnmarshalState embeddedElementUnmarshalState = (EmbeddedElementUnmarshalState)this.currentHandler;
        if (embeddedElementUnmarshalState.id != null) {
            this.getCurrentPackage().bind(embeddedElementUnmarshalState.id, object);
            embeddedElementUnmarshalState.id = null;
        }
    }

    public Object getBody() {
        return this.Body;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    ISoapPackageStream getCurrentPackage() {
        return (ISoapPackageStream)this.packageStack.peek();
    }

    public int getHeaderCount(int n) {
        return this.Headers.size();
    }

    public Enumeration getHeaders() {
        return this.Headers.elements();
    }

    public boolean getIgnoreNonWhiteSpace() {
        return this.ignoreNonWhiteSpace;
    }

    String getNCName(String string) {
        int n = string.indexOf(58);
        if (n != -1) {
            string = string.substring(n + 1, string.length());
        }
        return string;
    }

    String getNSPrefix(String string) {
        int n = string.indexOf(58);
        string = n != -1 ? string.substring(0, n) : "";
        return string;
    }

    String getNSURI(String string) {
        String string2 = this.getNSPrefix(string);
        String string3 = null;
        int n = this.namespaces.size() - 1;
        while (n >= 0 && string3 == null) {
            NamespaceMapping namespaceMapping = (NamespaceMapping)this.namespaces.elementAt(n);
            if (namespaceMapping.prefix.equals(string2)) {
                string3 = namespaceMapping.uri;
            }
            --n;
        }
        if (string3 == null && string2.equals("")) {
            string3 = "";
        }
        return string3;
    }

    public ISoapStreamFactory getTypeMapper() {
        return this.typeMapper;
    }

    ParserState getUnmarshalStateFromStartElement(String string, AttributeList attributeList, SoapParser soapParser, ISoapCompoundStream iSoapCompoundStream, boolean bl, ISoapNodeHandler iSoapNodeHandler) throws SAXException {
        Object object;
        String string2 = this.getNCName(string);
        String string3 = this.getNSURI(string);
        String string4 = null;
        String string5 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = attributeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            String string10;
            object = attributeList.getName(n2);
            String string11 = this.getNCName((String)object);
            String string12 = this.getNSURI((String)object);
            if (string11.equals("type")) {
                if (string12.equals("http://www.w3.org/1999/XMLSchema") || string12.equals("")) {
                    string10 = attributeList.getValue(n2);
                    string4 = this.getNCName(string10);
                    string5 = this.getNSURI(string10);
                }
            } else if (string11.equals("null")) {
                if (string12.equals("http://www.w3.org/1999/XMLSchema") || string12.equals("")) {
                    bl4 = true;
                }
            } else if (string11.equals("arrayType")) {
                if (string12.equals("urn:schemas-xmlsoap-org:soap.v1") || string12.equals("")) {
                    string10 = attributeList.getValue(n2);
                    string7 = this.getNCName(string10);
                    string8 = this.getNSURI(string10);
                }
            } else if (string11.equals("id")) {
                if (string12.equals("urn:schemas-xmlsoap-org:soap.v1") || string12.equals("")) {
                    string6 = attributeList.getValue(n2);
                }
            } else if (string11.equals("href")) {
                if (string12.equals("urn:schemas-xmlsoap-org:soap.v1") || string12.equals("")) {
                    string9 = attributeList.getValue(n2);
                    if (string9.charAt(0) != '#') {
                        this.error("href attribute on <" + string2 + "> must begin with a '#'");
                    }
                    string9 = string9.substring(1, string9.length());
                }
            } else if (string11.equals("rootWithId")) {
                if (string12.equals("urn:schemas-xmlsoap-org:soap.v1") || string12.equals("")) {
                    bl2 = attributeList.getValue(n2).equals("1");
                }
            } else if (string11.equals("Package")) {
                if (string12.equals("urn:schemas-xmlsoap-org:soap.v1") || string12.equals("")) {
                    bl3 = attributeList.getValue(n2).equals("1");
                }
            } else if (string11.equals("mustUnderstand") && (string12.equals("urn:schemas-xmlsoap-org:soap.v1") || string12.equals(""))) {
                bl5 = attributeList.getValue(n2).equals("1");
            }
            ++n2;
        }
        if (iSoapCompoundStream == null) {
            iSoapCompoundStream = new HeaderBodyCompoundStream(this, bl, string6, bl2, bl5);
            ((EnteredHeaderOrBody)iSoapNodeHandler).currentUnmarshaler = iSoapCompoundStream;
        }
        if (string9 != null) {
            object = iSoapCompoundStream.referenceAccessor(string3, string2);
            this.getCurrentPackage().resolve(string9, (ISoapResolver)object);
            return new ReferenceElementUnmarshalState(soapParser, iSoapNodeHandler);
        }
        if (bl4) {
            iSoapCompoundStream.referenceAccessor(string3, string2).resolve(null);
            return new ReferenceElementUnmarshalState(soapParser, iSoapNodeHandler);
        }
        if (string7 == null) {
            object = new EmbeddedElementUnmarshalState(soapParser);
            ((EmbeddedElementUnmarshalState)object).init(string2, string3, string4, string5, bl3, bl2, string6, iSoapCompoundStream, iSoapNodeHandler);
            return object;
        }
        this.error("arrays not supported");
        return null;
    }

    ISoapElement getUnmarshalerForType(String string, String string2, ISoapResolver iSoapResolver) throws SAXException {
        return this.getTypeMapper().getDeserializerForType(null, null, string, string2, iSoapResolver, this);
    }

    public void parse(String string) throws SAXException, IOException {
        super.parse(string);
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        super.parse(inputSource);
    }

    public void setIgnoreNonWhiteSpace(boolean bl) {
        this.ignoreNonWhiteSpace = bl;
    }

    public int verifyWhitespace(char[] cArray, int n, int n2) {
        int n3 = -1;
        int n4 = n;
        while (n3 == -1 && n4 < n2) {
            if (!Character.isWhitespace(cArray[n4])) {
                n3 = n4;
            }
            ++n4;
        }
        return n3;
    }

    static class NamespaceMapping {
        String prefix;
        String uri;

        NamespaceMapping() {
        }
    }

    static class PreEnvelopeState
    extends ParserState {
        public PreEnvelopeState(SoapParser soapParser) {
            super(soapParser);
        }

        public void startElement(String string, AttributeList attributeList) throws SAXException {
            String string2;
            String string3 = this.ctx.getNCName(string);
            if (!string3.equals("Envelope")) {
                this.ctx.error("Expected <Envelope>");
            }
            if (!(string2 = this.ctx.getNSURI(string)).equals("urn:schemas-xmlsoap-org:soap.v1") && !string2.equals("")) {
                this.ctx.error("Expected <Envelope> tag under SOAP URI (or no URI)");
            }
            this.ctx.currentHandler = new PreHeaderState(this.ctx);
        }
    }

    static class PreHeaderState
    extends ParserState {
        public PreHeaderState(SoapParser soapParser) {
            super(soapParser);
        }

        public void startElement(String string, AttributeList attributeList) throws SAXException {
            String string2 = this.ctx.getNCName(string);
            String string3 = this.ctx.getNSURI(string);
            if (!string3.equals("urn:schemas-xmlsoap-org:soap.v1") && !string3.equals("")) {
                this.ctx.error("Expected <Header> or <Body> tag under SOAP URI (or no URI)");
            }
            if (string2.equals("Header")) {
                this.ctx.currentHandler = new EnteredHeader(this.ctx);
            } else if (string2.equals("Body")) {
                this.ctx.currentHandler = new EnteredBody(this.ctx);
            } else {
                this.ctx.error("Expected <Header> or <Body>");
            }
        }
    }

    static class PreBodyState
    extends ParserState {
        public PreBodyState(SoapParser soapParser) {
            super(soapParser);
        }

        public void startElement(String string, AttributeList attributeList) throws SAXException {
            String string2 = this.ctx.getNCName(string);
            String string3 = this.ctx.getNSURI(string);
            if (!string3.equals("urn:schemas-xmlsoap-org:soap.v1") && !string3.equals("")) {
                this.ctx.error("Expected <Body> tag under SOAP URI (or no URI)");
            }
            if (string2.equals("Body")) {
                this.ctx.currentHandler = new EnteredBody(this.ctx);
            } else {
                this.ctx.error("Expected <Body>");
            }
        }
    }

    static class UnmarshalContextFixup
    implements ISoapResolver {
        HeaderBodyCompoundStream hbcs;

        UnmarshalContextFixup(HeaderBodyCompoundStream headerBodyCompoundStream) {
            this.hbcs = headerBodyCompoundStream;
        }

        public int getElementType() {
            return 1;
        }

        public void resolve(Object object) throws SAXException {
            if (this.hbcs.id == null || this.hbcs.isrootwithid) {
                if (this.hbcs.inHeader) {
                    this.hbcs.ctx.Headers.addElement(object);
                } else if (this.hbcs.ctx.Body == null) {
                    this.hbcs.ctx.Body = object;
                } else {
                    this.hbcs.ctx.error("Cannot have more than one root under soap:Body");
                }
            }
        }
    }

    static class HeaderBodyCompoundStream
    implements ISoapCompoundStream {
        SoapParser ctx;
        boolean inHeader;
        boolean isrootwithid;
        String id;
        boolean mandatoryHeader;
        Object targetObject = null;

        HeaderBodyCompoundStream(SoapParser soapParser, boolean bl, String string, boolean bl2, boolean bl3) throws SAXException {
            this.ctx = soapParser;
            this.id = string;
            this.mandatoryHeader = bl3;
            this.inHeader = bl;
            this.isrootwithid = bl2;
        }

        public ISoapArrayStream arrayAccessor(String string, String string2, String string3, String string4, String string5, String string6, int[] nArray, boolean bl) throws SAXException {
            return null;
        }

        public ISoapCompoundStream compoundAccessor(String string, String string2, String string3, String string4, boolean bl) throws SAXException {
            UnmarshalContextFixup unmarshalContextFixup = new UnmarshalContextFixup(this);
            ISoapElement iSoapElement = this.ctx.getTypeMapper().getDeserializerForType(string, string2, string3, string4, unmarshalContextFixup, this.ctx);
            if (iSoapElement.getElementType() != 2) {
                this.ctx.error("Cannot unmarshal " + string3 + "#" + string4 + " from a compound accessor");
            }
            return (ISoapCompoundStream)iSoapElement;
        }

        public int getElementType() {
            return 2;
        }

        public ISoapResolver referenceAccessor(String string, String string2) throws SAXException {
            UnmarshalContextFixup unmarshalContextFixup = new UnmarshalContextFixup(this);
            return unmarshalContextFixup;
        }

        public ISoapSimpleStream simpleAccessor(String string, String string2, String string3, String string4) throws SAXException {
            UnmarshalContextFixup unmarshalContextFixup = new UnmarshalContextFixup(this);
            ISoapElement iSoapElement = this.ctx.getTypeMapper().getDeserializerForType(string, string2, string3, string4, unmarshalContextFixup, this.ctx);
            if (iSoapElement.getElementType() != 0) {
                this.ctx.error("Cannot unmarshal " + string3 + "#" + string4 + " from a simple accessor");
            }
            return (ISoapSimpleStream)iSoapElement;
        }

        public void term() throws SAXException {
        }
    }

    static class EmbeddedElementUnmarshalState
    extends ParserState {
        ISoapNodeHandler nextHandler;
        String accessorName;
        String accessorURI;
        String typeName;
        String typeURI;
        boolean ispackage;
        boolean isrootwithid;
        String id;
        ISoapCompoundStream surroundingUnmarshaler;
        ISoapElement currentUnmarshaler = null;
        Vector chars = new Vector();

        public EmbeddedElementUnmarshalState(SoapParser soapParser) {
            super(soapParser);
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.currentUnmarshaler == null) {
                this.chars.addElement(new TextChunk(cArray, n, n2));
                if (this.ctx.verifyWhitespace(cArray, n, n2) != -1) {
                    if (this.id == null || this.isrootwithid) {
                        this.currentUnmarshaler = this.surroundingUnmarshaler.simpleAccessor(this.accessorURI, this.accessorName, this.typeURI, this.typeName);
                    } else {
                        ISoapStreamFactory iSoapStreamFactory = this.ctx.getCurrentPackage().getIndependentElementFactory();
                        this.currentUnmarshaler = iSoapStreamFactory.getDeserializerForType(this.accessorURI, this.accessorName, this.typeURI, this.typeName, null, this.ctx);
                    }
                }
            } else if (this.currentUnmarshaler.getElementType() == 2) {
                if (!this.ctx.getIgnoreNonWhiteSpace() && this.ctx.verifyWhitespace(cArray, n, n2) != -1) {
                    this.ctx.error("content = mixed is invalid under SOAP/1.0 section 8");
                }
            } else {
                this.chars.addElement(new TextChunk(cArray, n, n2));
            }
        }

        public void endElement(String string) throws SAXException {
            int n = this.chars.size();
            if (this.currentUnmarshaler == null) {
                if (n == 0) {
                    this.surroundingUnmarshaler.referenceAccessor(this.accessorURI, this.accessorName).resolve(null);
                } else {
                    this.currentUnmarshaler = this.surroundingUnmarshaler.simpleAccessor(this.accessorURI, this.accessorName, this.typeURI, this.typeName);
                }
            }
            if (this.currentUnmarshaler != null) {
                if (this.currentUnmarshaler.getElementType() == 2) {
                    if (this.ispackage) {
                        this.ctx.getCurrentPackage().seal();
                        this.ctx.packageStack.pop();
                    }
                    ((ISoapCompoundStream)this.currentUnmarshaler).term();
                } else {
                    String string2 = "";
                    int n2 = 0;
                    while (n2 < n) {
                        TextChunk textChunk = (TextChunk)this.chars.elementAt(n2);
                        string2 = String.valueOf(string2) + new String(textChunk.rgch, textChunk.offset, textChunk.length);
                        ++n2;
                    }
                    ((ISoapSimpleStream)this.currentUnmarshaler).content(string2);
                }
            }
            this.ctx.currentHandler = this.nextHandler;
        }

        public void init(String string, String string2, String string3, String string4, boolean bl, boolean bl2, String string5, ISoapCompoundStream iSoapCompoundStream, ISoapNodeHandler iSoapNodeHandler) {
            this.accessorName = string;
            this.accessorURI = string2;
            this.typeName = string3;
            this.typeURI = string4;
            this.ispackage = bl;
            this.isrootwithid = bl2;
            this.id = string5;
            this.nextHandler = iSoapNodeHandler;
            this.surroundingUnmarshaler = iSoapCompoundStream;
            if (this.ispackage) {
                this.ctx.packageStack.push(new FixupTable(this.ctx));
            }
        }

        public void startElement(String string, AttributeList attributeList) throws SAXException {
            Object object;
            if (this.currentUnmarshaler == null) {
                if (this.id == null || this.isrootwithid) {
                    this.currentUnmarshaler = this.surroundingUnmarshaler.compoundAccessor(this.accessorURI, this.accessorName, this.typeURI, this.typeName, this.ispackage);
                } else {
                    object = this.ctx.getCurrentPackage().getIndependentElementFactory();
                    this.currentUnmarshaler = object.getDeserializerForType(this.accessorURI, this.accessorName, this.typeURI, this.typeName, null, this.ctx);
                }
            }
            if (this.currentUnmarshaler.getElementType() == 0) {
                this.ctx.error("content=mixed not allowed under section 8 of SOAP/1.0");
            }
            this.ctx.currentHandler = object = this.ctx.getUnmarshalStateFromStartElement(string, attributeList, this.ctx, (ISoapCompoundStream)this.currentUnmarshaler, false, this);
        }
    }

    static abstract class EnteredHeaderOrBody
    extends EmbeddedElementUnmarshalState {
        public EnteredHeaderOrBody(SoapParser soapParser) {
            super(soapParser);
        }

        public void endElement(String string) throws SAXException {
            ((ISoapCompoundStream)this.currentUnmarshaler).term();
            this.ctx.getCurrentPackage().seal();
            this.setNextState(true);
        }

        abstract boolean inHeader();

        abstract void setNextState(boolean var1);

        public void startElement(String string, AttributeList attributeList) throws SAXException {
            this.ctx.currentHandler = this.ctx.getUnmarshalStateFromStartElement(string, attributeList, this.ctx, null, this.inHeader(), this);
        }
    }

    static class EnteredHeader
    extends EnteredHeaderOrBody {
        public EnteredHeader(SoapParser soapParser) {
            super(soapParser);
        }

        boolean inHeader() {
            return true;
        }

        void setNextState(boolean bl) {
            this.ctx.currentHandler = !bl ? this : new PreBodyState(this.ctx);
        }
    }

    static class EnteredBody
    extends EnteredHeaderOrBody {
        public EnteredBody(SoapParser soapParser) {
            super(soapParser);
        }

        boolean inHeader() {
            return false;
        }

        void setNextState(boolean bl) {
            this.ctx.currentHandler = !bl ? this : new PostBodyState(this.ctx);
        }
    }

    static class PostBodyState
    extends ParserState {
        public PostBodyState(SoapParser soapParser) {
            super(soapParser);
        }

        public void endElement(String string) throws SAXException {
            this.ctx.currentHandler = new PostEnvelopeState(this.ctx);
        }
    }

    static class PostEnvelopeState
    extends ParserState {
        public PostEnvelopeState(SoapParser soapParser) {
            super(soapParser);
        }

        public void endElement(String string) throws SAXException {
            this.ctx.error("Unexpected");
        }
    }

    static class ReferenceElementUnmarshalState
    extends ParserState {
        ISoapNodeHandler nextHandler;

        public ReferenceElementUnmarshalState(SoapParser soapParser, ISoapNodeHandler iSoapNodeHandler) {
            super(soapParser);
            this.nextHandler = iSoapNodeHandler;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.ctx.verifyWhitespace(cArray, n, n2);
        }

        public void endElement(String string) throws SAXException {
            this.ctx.currentHandler = this.nextHandler;
        }
    }

    static class TextChunk {
        char[] rgch;
        int offset;
        int length;

        TextChunk(char[] cArray, int n, int n2) {
            this.rgch = cArray;
            this.offset = n;
            this.length = n2;
        }
    }

    class Handler
    implements NamespaceHandler,
    DocumentHandler {
        Handler() {
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            SoapParser.this.currentHandler.characters(cArray, n, n2);
        }

        public void endDocument() {
        }

        public void endElement(String string) throws SAXException {
            SoapParser.this.currentHandler.endElement(string);
        }

        public void endNamespaceDeclScope(String string) {
            NamespaceMapping namespaceMapping = (NamespaceMapping)SoapParser.this.namespaces.pop();
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) {
        }

        public void processingInstruction(String string, String string2) {
        }

        public void setDocumentLocator(Locator locator) {
            SoapParser.this.saxLocator = locator;
        }

        public void startDocument() {
        }

        public void startElement(String string, AttributeList attributeList) throws SAXException {
            SoapParser.this.currentHandler.startElement(string, attributeList);
        }

        public void startNamespaceDeclScope(String string, String string2) {
            NamespaceMapping namespaceMapping = new NamespaceMapping();
            namespaceMapping.prefix = string;
            namespaceMapping.uri = string2;
            SoapParser.this.namespaces.push(namespaceMapping);
        }
    }
}

