/*------------------------------------------------------------------------------
* Copyright (C) 2003-2006 Ben van Klinken and the CLucene Team
* 
* Distributable under the terms of either the Apache License (Version 2.0) or 
* the GNU Lesser General Public License, as specified in the COPYING file.
------------------------------------------------------------------------------*/
#include "test.h"

//checks that adding more than the min_merge value goes ok...
//checks for a mem leak that used to occur
void testIWmergeSegments1(CuTest *tc){
	RAMDirectory ram;
	SimpleAnalyzer a;
	IndexWriter ndx2(&ram,&a,true);
	ndx2.close(); //test immediate closing bug reported
	
	IndexWriter ndx(&ram,&a,false);
	ndx.setUseCompoundFile(false);
	ndx.setMergeFactor(2);
	ndx.setMinMergeDocs(1);
	TCHAR fld[1000];
	for ( int i=0;i<1000;i++ ){
        English::IntToEnglish(i,fld,1000);

		Document doc;
		doc.add ( *Field::Text(_T("field"),fld) );
		ndx.addDocument(&doc);
	}
	ndx.optimize(); //optimize so we can read terminfosreader with segmentreader
	ndx.close();

	//test the ram loading
	RAMDirectory ram2(&ram);
	IndexReader* reader2 = IndexReader::open(&ram2);
	SegmentReader* segreader = (SegmentReader*)reader2;
	Term* term = _CLNEW Term(_T("field"),fld);
	TermEnum* en = reader2->terms(term);
	CLUCENE_ASSERT(en->next());
	_CLDELETE(en);
	_CLDECDELETE(term);
	_CLDELETE(reader2);
}
CuSuite *testindexwriter(void)
{
	CuSuite *suite = CuSuiteNew(_T("CLucene IndexWriter Test"));
	SUITE_ADD_TEST(suite, testIWmergeSegments1);

    return suite; 
}
// EOF
