//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    /// <remarks>
    ///  This class provides a dialog base class which handles multiple
    ///  pages and allows the user to switch between these pages in
    ///  different ways.
    ///  Currently, <code>Auto</code>, <code>Plain</code>, <code>List</code>, <code>Tree</code> and <code>Tabbed</code> face
    ///  types are available (@see KPageView).
    ///  <li><b>Example:</b></li>
    ///  <pre>
    ///  UrlDialog.UrlDialog( QWidget parent )
    ///  {
    ///    setFaceType( List );
    ///    QLabel label = new QLabel( "Test Page" );
    ///    addPage( label, i18n( "My Test Page" ) );
    ///    label = new QLabel( "Second Test Page" );
    ///    KPageWidgetItem page = new KPageWidgetItem( label, i18n( "My Second Test Page" ) );
    ///    page.SetHeader( i18n( "My header string" ) );
    ///    page.SetIcon( KIcon( "file" ) );
    ///    addPage( page );
    ///  }
    ///  </pre>
    ///  See <see cref="IKPageDialogSignals"></see> for signals emitted by KPageDialog
    /// </remarks>        <author> Tobias Koenig (tokoe@kde.org)
    ///  </author>
    ///         <short> A dialog base class which can handle multiple pages. </short>
    [SmokeClass("KPageDialog")]
    public class KPageDialog : KDialog, IDisposable {
        protected KPageDialog(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KPageDialog), this);
        }
        /// <remarks>
        /// 
        /// <li>
        /// <code>Auto</code>   - A dialog with a face based on the structure of the
        ///                   available pages.
        ///                   If only a single page is added, the dialog behaves like
        ///                   in <code>Plain</code> mode, with multiple pages without sub pages
        ///                   it behaves like in <code>List</code> mode and like in <code>Tree</code> mode
        ///                   otherwise.
        /// </li>
        /// 
        /// <li>
        /// <code>Plain</code>  - A normal dialog.
        /// </li>
        /// 
        /// <li>
        /// <code>List</code>   - A dialog with an icon list on the left side and a
        ///                   representation of the contents on the right side.
        /// </li>
        /// 
        /// <li>
        /// <code>Tree</code>   - A dialog with a tree on the left side and a
        ///                   representation of the contents on the right side.
        /// </li>
        /// 
        /// <li>
        /// <code>Tabbed</code> - A dialog with a tab bar above the representation
        ///                   of the contents.
        ///      
        /// </li></remarks>        <short>   </short>
        public enum FaceType {
            Auto = KPageView.FaceType.Auto,
            Plain = KPageView.FaceType.Plain,
            List = KPageView.FaceType.List,
            Tree = KPageView.FaceType.Tree,
            Tabbed = KPageView.FaceType.Tabbed,
        }
        // KPageDialog* KPageDialog(KPageDialogPrivate& arg1,KPageWidget* arg2,QWidget* arg3,Qt::WindowFlags arg4); >>>> NOT CONVERTED
        // KPageDialog* KPageDialog(KPageDialogPrivate& arg1,KPageWidget* arg2,QWidget* arg3); >>>> NOT CONVERTED
        /// <remarks>
        ///  Creates a new page dialog.
        ///      </remarks>        <short>    Creates a new page dialog.</short>
        public KPageDialog(QWidget parent, uint flags) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KPageDialog#$", "KPageDialog(QWidget*, Qt::WindowFlags)", typeof(void), typeof(QWidget), parent, typeof(uint), flags);
        }
        public KPageDialog(QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KPageDialog#", "KPageDialog(QWidget*)", typeof(void), typeof(QWidget), parent);
        }
        public KPageDialog() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KPageDialog", "KPageDialog()", typeof(void));
        }
        /// <remarks>
        ///  Sets the face type of the dialog.
        ///      </remarks>        <short>    Sets the face type of the dialog.</short>
        public void SetFaceType(KPageDialog.FaceType faceType) {
            interceptor.Invoke("setFaceType$", "setFaceType(KPageDialog::FaceType)", typeof(void), typeof(KPageDialog.FaceType), faceType);
        }
        /// <remarks>
        ///  Adds a new top level page to the dialog.
        /// <param> name="widget" The widget of the page.
        /// </param><param> name="name" The name which is displayed in the navigation view.
        /// </param></remarks>        <return> The associated @see KPageWidgetItem.
        ///      </return>
        ///         <short>    Adds a new top level page to the dialog.</short>
        public KPageWidgetItem AddPage(QWidget widget, string name) {
            return (KPageWidgetItem) interceptor.Invoke("addPage#$", "addPage(QWidget*, const QString&)", typeof(KPageWidgetItem), typeof(QWidget), widget, typeof(string), name);
        }
        /// <remarks>
        ///  Adds a new top level page to the dialog.
        /// <param> name="item" The @see KPageWidgetItem which describes the page.
        ///      </param></remarks>        <short>    Adds a new top level page to the dialog.</short>
        public void AddPage(KPageWidgetItem item) {
            interceptor.Invoke("addPage#", "addPage(KPageWidgetItem*)", typeof(void), typeof(KPageWidgetItem), item);
        }
        /// <remarks>
        ///  Inserts a new page in the dialog.
        /// <param> name="before" The new page will be insert before this @see KPageWidgetItem
        ///                on the same level in hierarchy.
        /// </param><param> name="widget" The widget of the page.
        /// </param><param> name="name" The name which is displayed in the navigation view.
        /// </param></remarks>        <return> The associated @see KPageWidgetItem.
        ///      </return>
        ///         <short>    Inserts a new page in the dialog.</short>
        public KPageWidgetItem InsertPage(KPageWidgetItem before, QWidget widget, string name) {
            return (KPageWidgetItem) interceptor.Invoke("insertPage##$", "insertPage(KPageWidgetItem*, QWidget*, const QString&)", typeof(KPageWidgetItem), typeof(KPageWidgetItem), before, typeof(QWidget), widget, typeof(string), name);
        }
        /// <remarks>
        ///  Inserts a new page in the dialog.
        /// <param> name="before" The new page will be insert before this @see KPageWidgetItem
        ///                on the same level in hierarchy.
        /// </param><param> name="item" The @see KPageWidgetItem which describes the page.
        ///      </param></remarks>        <short>    Inserts a new page in the dialog.</short>
        public void InsertPage(KPageWidgetItem before, KPageWidgetItem item) {
            interceptor.Invoke("insertPage##", "insertPage(KPageWidgetItem*, KPageWidgetItem*)", typeof(void), typeof(KPageWidgetItem), before, typeof(KPageWidgetItem), item);
        }
        /// <remarks>
        ///  Inserts a new sub page in the dialog.
        /// <param> name="parent" The new page will be insert as child of this @see KPageWidgetItem.
        /// </param><param> name="widget" The widget of the page.
        /// </param><param> name="name" The name which is displayed in the navigation view.
        /// </param></remarks>        <return> The associated @see KPageWidgetItem.
        ///      </return>
        ///         <short>    Inserts a new sub page in the dialog.</short>
        public KPageWidgetItem AddSubPage(KPageWidgetItem parent, QWidget widget, string name) {
            return (KPageWidgetItem) interceptor.Invoke("addSubPage##$", "addSubPage(KPageWidgetItem*, QWidget*, const QString&)", typeof(KPageWidgetItem), typeof(KPageWidgetItem), parent, typeof(QWidget), widget, typeof(string), name);
        }
        /// <remarks>
        ///  Inserts a new sub page in the dialog.
        /// <param> name="parent" The new page will be insert as child of this @see KPageWidgetItem.
        /// </param><param> name="item" The @see KPageWidgetItem which describes the page.
        ///      </param></remarks>        <short>    Inserts a new sub page in the dialog.</short>
        public void AddSubPage(KPageWidgetItem parent, KPageWidgetItem item) {
            interceptor.Invoke("addSubPage##", "addSubPage(KPageWidgetItem*, KPageWidgetItem*)", typeof(void), typeof(KPageWidgetItem), parent, typeof(KPageWidgetItem), item);
        }
        /// <remarks>
        ///  Removes the page associated with the given @see KPageWidgetItem.
        ///      </remarks>        <short>    Removes the page associated with the given @see KPageWidgetItem.</short>
        public void RemovePage(KPageWidgetItem item) {
            interceptor.Invoke("removePage#", "removePage(KPageWidgetItem*)", typeof(void), typeof(KPageWidgetItem), item);
        }
        /// <remarks>
        ///  Sets the page which is associated with the given @see KPageWidgetItem to
        ///  be the current page and emits the currentPageChanged() signal.
        ///      </remarks>        <short>    Sets the page which is associated with the given @see KPageWidgetItem to  be the current page and emits the currentPageChanged() signal.</short>
        public void SetCurrentPage(KPageWidgetItem item) {
            interceptor.Invoke("setCurrentPage#", "setCurrentPage(KPageWidgetItem*)", typeof(void), typeof(KPageWidgetItem), item);
        }
        /// <remarks>
        ///  Returns the @see KPageWidgetItem for the current page or 0 if there is no
        ///  current page.
        ///      </remarks>        <short>    Returns the @see KPageWidgetItem for the current page or 0 if there is no  current page.</short>
        public KPageWidgetItem CurrentPage() {
            return (KPageWidgetItem) interceptor.Invoke("currentPage", "currentPage() const", typeof(KPageWidgetItem));
        }
        /// <remarks>
        ///  This constructor can be used by subclasses to provide a custom page widget.
        ///  \param widget The KPageWidget object will be reparented to this object, so you can create
        ///  it without parent and you are not allowed to delete it.
        ///      </remarks>        <short>    This constructor can be used by subclasses to provide a custom page widget.</short>
        public KPageDialog(KPageWidget widget, QWidget parent, uint flags) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KPageDialog##$", "KPageDialog(KPageWidget*, QWidget*, Qt::WindowFlags)", typeof(void), typeof(KPageWidget), widget, typeof(QWidget), parent, typeof(uint), flags);
        }
        public KPageDialog(KPageWidget widget, QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KPageDialog##", "KPageDialog(KPageWidget*, QWidget*)", typeof(void), typeof(KPageWidget), widget, typeof(QWidget), parent);
        }
        /// <remarks>
        ///  Returns the page widget of the dialog or 0 if no page widget is set.
        ///      </remarks>        <short>    Returns the page widget of the dialog or 0 if no page widget is set.</short>
        protected KPageWidget PageWidget() {
            return (KPageWidget) interceptor.Invoke("pageWidget", "pageWidget()", typeof(KPageWidget));
        }
        ~KPageDialog() {
            interceptor.Invoke("~KPageDialog", "~KPageDialog()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~KPageDialog", "~KPageDialog()", typeof(void));
        }
        protected new IKPageDialogSignals Emit {
            get { return (IKPageDialogSignals) Q_EMIT; }
        }
    }

    public interface IKPageDialogSignals : IKDialogSignals {
        /// <remarks>
        ///  This signal is emitted whenever the current page has changed.
        /// <param> name="item" The new current page or 0 if no current page is available.
        ///      </param></remarks>        <short>    This signal is emitted whenever the current page has changed.</short>
        [Q_SIGNAL("void currentPageChanged(KPageWidgetItem*, KPageWidgetItem*)")]
        void CurrentPageChanged(KPageWidgetItem current, KPageWidgetItem before);
        /// <remarks>
        ///  This signal is emitted whenever a page has been removed.
        /// <param> name="page" The page which has been removed
        /// </param></remarks>        <short>    This signal is emitted whenever a page has been removed.</short>
        [Q_SIGNAL("void pageRemoved(KPageWidgetItem*)")]
        void PageRemoved(KPageWidgetItem page);
    }
}
