/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.webapp.filters;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class DownloadCountFilter
implements Filter {
    private File storage;
    private Properties counts;
    private Timer timer;
    private ServletContext servletContext;

    public void init(FilterConfig config) throws ServletException {
        this.servletContext = config.getServletContext();
        String statsFilename = config.getInitParameter("filename");
        this.storage = new File(statsFilename);
        this.counts = new Properties();
        try {
            this.counts.load(new FileInputStream(this.storage));
        }
        catch (FileNotFoundException e) {
            this.servletContext.log("File for download statistics not found: " + statsFilename);
            try {
                if (!this.storage.getParentFile().mkdirs() || !this.storage.createNewFile()) {
                    this.servletContext.log("File for download statistics could not be created: " + statsFilename);
                }
            }
            catch (IOException e1) {
                this.servletContext.log("Exception trying to create file for download statistics: " + e1.getMessage());
            }
        }
        catch (IOException e) {
            this.servletContext.log("File for download statistics could not be read: " + e.getMessage());
        }
        String delayString = config.getInitParameter("storeDelay");
        int delayInSeconds = Integer.parseInt(delayString);
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate((TimerTask)new Saver(), 10000L, (long)(1000 * delayInSeconds));
    }

    public void destroy() {
        this.timer.cancel();
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request;
        if (req instanceof HttpServletRequest && (request = (HttpServletRequest)req).getMethod().equalsIgnoreCase("get")) {
            String contextPath = request.getContextPath();
            String requestUri = request.getRequestURI();
            String requestPath = requestUri.substring(contextPath.length());
            String countString = this.counts.getProperty(requestPath);
            int count = 0;
            if (countString != null) {
                count = Integer.parseInt(countString);
            }
            this.counts.setProperty(requestPath, String.valueOf(++count));
        }
        chain.doFilter(req, res);
    }

    private class Saver
    extends TimerTask {
        private Saver() {
        }

        public void run() {
            try {
                FileOutputStream out = new FileOutputStream(DownloadCountFilter.this.storage);
                DownloadCountFilter.this.counts.store(out, null);
                out.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

