# Asciidoctor Boost Links Extension


This extension creates links to Boost libraries and tools with inline
Asciidoc syntax.

``` {.asciidoc}
boost:core[]
```

This will render as if the equivalent AsciiDoc code was used:

``` {.asciidoc}
https://www.boost.org/libs/core[Boost.Core]
```

When processed by Asciidoc, this renders as
\"[Boost.Core](https://www.boost.org/libs/core)\":

``` {.html}
<a href="https://www.boost.org/libs/core">Boost.Core</a>
```

The extension supports Boost libraries and tools.

Configuration {#_configuration}

### Links to Libraries

The extension helps you create links to Boost libraries. The format is
very similar to the syntax for URLs in Asciidoc. However, the extension
will automatically convert the library name to the appropriate URL and
display the library name if the positional argument is not provided.

``` {.asciidoc}
boost:core[]
```

This will render as if the equivalent AsciiDoc code was used:

``` {.asciidoc}
https://www.boost.org/libs/core[Boost.Core]
```

When processed by Asciidoc, this renders as
\"[Boost.Core](https://www.boost.org/libs/core)\":

``` {.html}
<a href="https://www.boost.org/libs/core">Boost.Core</a>
```

### Boost Tools

Boost tools, such as Boost.Docca, have different link formats. The
extension will identify the tool and render the link accordingly.

``` {.asciidoc}
boost:docca[]
```

This will render as if the equivalent AsciiDoc code was used:

``` {.asciidoc}
https://www.boost.org/tools/docca[Boost.Docca]
```

When processed by Asciidoc, this renders as
\"[Boost.Docca](https://www.boost.org/tools/docca)\":

``` {.html}
<a href="https://www.boost.org/tools/docca">Boost.Docca</a>
```

### Unknown libraries

Unknown libraries render as if the library exists:

``` {.asciidoc}
boost:a[]
```

This will render as if the equivalent AsciiDoc code was used:

``` {.asciidoc}
https://www.boost.org/libs/a[Boost.A]
```

When processed by Asciidoc, this renders as
\"[Boost.A](https://www.boost.org/libs/a)\":

``` {.html}
<a href="https://www.boost.org/libs/a">Boost.A</a>
```

### Positional arguments

Positional arguments allow you to specify the text to display in the
link.

``` {.asciidoc}
boost:boostdep[Dependencies]
```

This will render as if the equivalent AsciiDoc code was used:

``` {.asciidoc}
https://www.boost.org/tools/boostdep[Dependencies]
```

When processed by Asciidoc, this renders as
\"[Dependencies](https://www.boost.org/tools/boostdep)\":

``` {.html}
<a href="https://www.boost.org/tools/boostdep">Dependencies</a>
```

### Forwarding attributes

If any attributes are passed to the link, they will be forwarded to the
generated link.

``` {.asciidoc}
boost:quickbook[Quickbook,window=_blank]
```

This will render as if the equivalent AsciiDoc code was used:

``` {.asciidoc}
https://www.boost.org/tools/quickbook[Quickbook,window=_blank]
```

When processed by Asciidoc, this renders as
\"[Quickbook,window=\_blank](https://www.boost.org/tools/quickbook)\":

``` {.html}
<a href="https://www.boost.org/tools/quickbook" target="_blank" rel="noopener">Quickbook</a>
```

It also works when no text is provided:

``` {.asciidoc}
boost:utility[window=_blank]
```

This will render as if the equivalent AsciiDoc code was used:

``` {.asciidoc}
https://www.boost.org/libs/utility[Boost.Utility,window=_blank]
```

When processed by Asciidoc, this renders as
\"[Boost.Utility,window=\_blank](https://www.boost.org/libs/utility)\":

``` {.html}
<a href="https://www.boost.org/libs/utility" target="_blank" rel="noopener">Boost.Utility</a>
```

### Exceptions to Pascal Case

A few libraries and tools have exceptions to the Pascal Case rule (the
\"Boost.LibraryName\" format). These exceptions are defined when
requested by library authors or when the Pascal Case format is
problematic. The extension will identify these exceptions and render the
link accordingly.

``` {.asciidoc}
boost:build[]
```

This will render as if the equivalent AsciiDoc code was used:

``` {.asciidoc}
https://www.boost.org/tools/build[B2]
```

When processed by Asciidoc, this renders as
\"[B2](https://www.boost.org/tools/build)\":

``` {.html}
<a href="https://www.boost.org/tools/build">B2</a>
```

Or Boost.URL, where the library name is an acronym:

``` {.asciidoc}
boost:url[]
```

This will render as if the equivalent AsciiDoc code was used:

``` {.asciidoc}
https://www.boost.org/libs/url[Boost.URL]
```

When processed by Asciidoc, this renders as
\"[Boost.URL](https://www.boost.org/libs/url)\":

``` {.html}
<a href="https://www.boost.org/libs/url">Boost.URL</a>
```
