/*
 * Copyright (c) 2003 Benedikt Meurer (benedikt.meurer@unix-ag.uni-siegen.de)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __XFPRINT_XFPRINTSETTINGS_H__
#define __XFPRINT_XFPRINTSETTINGS_H__

#include "option.h"
#include "xfprinter.h"

typedef struct _XfPrintSettingsSheets		XfPrintSettingsSheets;
typedef struct _XfPrintSettingsVirtualPages	XfPrintSettingsVirtualPages;
typedef struct _XfPrintSettingsPrettyPrint	XfPrintSettingsPrettyPrint;
typedef struct _XfPrintSettingsInput		XfPrintSettingsInput;
typedef struct _XfPrintSettingsHeadings		XfPrintSettingsHeadings;
typedef struct _XfPrintSettings			XfPrintSettings;

struct _XfPrintSettingsSheets
{
	gboolean	landscape;
	gboolean	fillcols;
	guint		cols;
	guint		rows;
	const gchar	*papersize;
	gboolean	borders;
	gboolean	reverse;
};

struct _XfPrintSettingsVirtualPages
{
	guint		linenumbers;
	guint		lpp;		/* lines per page */
	guint		cpl;		/* chars per line */
	guint		tabsize;
	const gchar	*nonprtfmt;
};

struct _XfPrintSettingsPrettyPrint
{
	const gchar	*language;
	const gchar	*highlight;
	guint		strip;
};

struct _XfPrintSettingsInput
{
	const gchar	*encoding;
	gboolean	all;
	guint		from;
	guint		to;
	gboolean	cut;
	gboolean	interpret;
	gboolean	binary;
};

struct _XfPrintSettingsHeadings
{
	gboolean	headers;
	gchar		header[64];
	gchar		underlay[64];
	gchar		ctitle[64];
	gchar		ltitle[64];
	gchar		rtitle[64];
	gchar		cfooter[64];
	gchar		lfooter[64];
	gchar		rfooter[64];
};

struct _XfPrintSettings
{
	XfPrintSettingsSheets		sheets;
	XfPrintSettingsVirtualPages	vpages;
	XfPrintSettingsPrettyPrint	pprint;
	XfPrintSettingsInput		input;
	XfPrintSettingsHeadings		headings;

	guint				copies;
};

extern XfPrintSettings	*xfprintsettings_defaults(void);
extern XfPrintSettings	*xfprintsettings_load(void);
extern void		xfprintsettings_save(const XfPrintSettings *);
extern void		xfprintsettings_free(XfPrintSettings *);

/* predefined options */
extern const XfceOption papersizes[];
extern const XfceOption encodings[];
extern const XfceOption languages[];
extern const XfceOption non_printable_fmts[];
extern const XfceOption hilevels[];

#endif	/* !__XFPRINT_XFPRINTSETTINGS_H__ */
