/*
 *	--- preferences.cpp ---
 * 
 * Written by Krzysztof "Kristoff" Godlewski (krzygod@kki.net.pl)
 */

#include <qvbox.h>
#include <qhbox.h>
#include <kconfig.h>
#include <klocale.h>
#include <kapplication.h>

#include "preferences.h"
#include "preferences.moc"

PrefDialog::PrefDialog( QWidget *parent )
    : KDialogBase( parent, "PrefDialog", true, 
                   i18n("KAsteroids Preferences"), Ok | Cancel, Ok, true)
{                  
  QVBox *page = makeVBoxMainWidget();
  QHBox *hb = new QHBox( page );
  QLabel *label = new QLabel( i18n("Start new game with"), hb );
  spinShips = new QSpinBox( 1, 5, 1, hb );
  label = new QLabel( i18n(" ships."), hb );

  checkBoxes = new QPtrList<QCheckBox>;
  for( int i = 0; i < 2; i++ )
  {
    QCheckBox *cb = new QCheckBox( page );
    checkBoxes->append( cb );
  }

  checkBoxes->at(0)->setText( i18n("Show highscores on Game Over") );
  checkBoxes->at(1)->setText( i18n("Player can destroy Powerups") );

  incInitialSize(QSize(20,20), true);

  readConfig();
}	// --- end constructor ---

PrefDialog::~PrefDialog()
{
  delete checkBoxes;
}

void PrefDialog::readConfig()
{
  KConfigBase *conf = kapp->config();

  if( conf )
  {
    conf->setGroup( "Preferences" );

    spinShips->setValue( conf->readNumEntry( "numShips", 3 ) );

    checkBoxes->at(0)->setChecked( conf->readBoolEntry( "showHiscores" , false ) );
    checkBoxes->at(1)->setChecked( conf->readBoolEntry( "canDestroyPowerups", true ) );
  }
}

void PrefDialog::slotOk()
{
  KConfigBase *conf = kapp->config();

  if( conf )
  {
    conf->setGroup( "Preferences" );
    conf->writeEntry( "numShips", spinShips->value() );
    conf->writeEntry( "showHiscores", checkBoxes->at(0)->isChecked() );
    conf->writeEntry( "canDestroyPowerups", checkBoxes->at(1)->isChecked() );

    conf->sync();

    accept();
  }
}

