/***************************************************************************
                            KConfig.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KCONFIG_H
#define KCONFIG_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KConfigBase.h>

/**


Copyright (c) 2000 Matthias Elter

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

****************************************************************
 @short 

*/
@class KEntry; 
@class KEntryKey; 

@class KEntryMap; 

@interface KConfig : KConfigBase 

/** 
 Constructs a KConfig object.

*/
- initWithText: (NSString *)fileName bReadOnly: (BOOL)bReadOnly bUseKDEGlobals: (BOOL)bUseKDEGlobals resType: (NSString *)resType;
- init;

/** 
 Destructs the KConfig object.

 Writes back any dirty configuration entries, and destroys
 dynamically created objects.
   
*/
- (void) dealloc;

/** 
 Clears all entries out of the @p dirtyEntryMap, so the
 values will not be written to disk on a later call to
 @ref -sync.

*/
- rollback: (BOOL)bDeep;
- rollback;

/** 
 Returns a list of groups that are known.
   
*/
- (NSArray *) groupList;

/** 
 Clears all internal data structures and then reread
 configuration information from disk.
   
*/
- reparseConfiguration;

/** 
 Returns true if the specified group is known.

*/
- (BOOL) internalHasGroup: (NSString *)group;

/** 
 Returns a map (tree) of the entries in the specified group.

 Do not use this function, the implementation / return type are
 subject to change.

   
*/
//- (KEntryMap*) internalEntryMap: (NSString *)pGroup;

/** 
 Returns a copy of the internal map used to hold all entries.

 Do not use this function, the implementation / return type are
 subject to change.

   
*/
//- (KEntryMap*) internalEntryMap;

/** 
 Inserts a (key, value) pair into the internal storage mechanism of
 the configuration object.

*/
- putData: (KEntryKey*)_key _data: (KEntry*)_data _checkGroup: (BOOL)_checkGroup;
- putData: (KEntryKey*)_key _data: (KEntry*)_data ;

/** 
 Looks up an entry in the config object's internal structure.

*/
- (KEntry*) lookupData: (KEntryKey*)_key;
@end

/** Override these methods in subclasses of KConfig to customise event handling behaviour */
@protocol KConfigEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
