/***************************************************************************
                            KCharsets.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KCHARSETS_H
#define KCHARSETS_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Charset font and encoder/decoder handling.

 This is needed, because Qt's font matching algorithm gives the font
 family a higher priority than the charset.  For many applications
 this is not acceptable, since it can totally obscure the output,
 in languages which use non iso-8859-1 charsets.

 @author Lars Knoll <knoll@kde.org>

 @version $Id: KCharsets.h,v 1.3 2002/03/15 02:12:19 rdale Exp $
 
 @short 
 Charset font and encoder/decoder handling.
*/
@class QTextCodec; 

@interface  KCharsets : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/**  destructor 
*/
- (void) dealloc;

/** 
 provided for compatibility.
     
*/
- (QTextCodec*) codecForName: (NSString *)name;

/** 
 tries to find a QTextCodec to convert the given encoding from and to
 Unicode. If no codec could be found the latin1 codec will be returned an
 ok will be set to false.
     
*/
- (QTextCodec*) codecForName: (NSString *)n ok: (BOOL)ok;

/** 
 Lists all available encodings as names.
     
*/
- (NSArray *) availableEncodingNames;

/** 
 Lists the available encoding names together with a more descriptive language.
     
*/
- (NSArray *) descriptiveEncodingNames;

/** 
 Lists all languages.
     
*/
//- (NSArray *) languages;

/** 
 Lists all available encodings for language name 'language'.
     
*/
//- (NSArray *) encodingsForLanguage: (NSString *)language;

/** 
 returns the language the encoding is used for. 
     
*/
- (NSString *) languageForEncoding: (NSString *)encoding;

/** 
 returns the encoding for a string obtained with -descriptiveEncodingNames
     
*/
- (NSString *) encodingForName: (NSString *)descriptiveName;

/** 
 converts an entity to a character. The string must contain only the
 entity without the trailing ';'.

*/
+ (unichar*) fromEntity: (NSString *)str;

/** 
 Overloaded member function. Tries to find an entity in the
 @ref QString str.

*/
+ (unichar*) fromEntity: (NSString *)str len: (int)len;

/** 
 converts a QChar to an entity. The returned string does already
 contain the leading '&' and the trailing ';'.
     
*/
+ (NSString *) toEntity: (unichar *)ch;

/**  protected constructor. If you need the kcharsets object, use
        @ref -[KGlobal charsets] instead.
    
*/
- init;
@end

#endif
