/***************************************************************************
                            HTMLTableRowElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLTABLEROWELEMENT_H
#define HTMLTABLEROWELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 A row in a table. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html edef]-TR">
 TR element definition </a> in HTML 4.0.

 
 @short 
 A row in a table.
*/

@class HTMLCollection;

@interface HTMLTableRowElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 The index of this row, relative to the entire table.
     
*/
- (long) rowIndex;

/** 
 see @ref rowIndex

 This function is obsolete - the rowIndex property is actually supposed to be read-only
 (http://www.w3.org/DOM/updates/REC-DOM-Level-1-19981001-errata.html)
     
*/
- setRowIndex: (long)arg1;

/** 
 The index of this row, relative to the current section ( <code>
 THEAD </code> , <code> TFOOT </code> , or <code> TBODY </code>
 ).

     
*/
- (long) sectionRowIndex;

/** 
 see @ref sectionRowIndex

 This function is obsolete - the sectionRowIndex property is actually supposed to be read-only
 (http://www.w3.org/DOM/updates/REC-DOM-Level-1-19981001-errata.html)
     
*/
- setSectionRowIndex: (long)arg1;

/** 
 The collection of cells in this row.

     
*/
- (HTMLCollection*) cells;

/** 
 see @ref cells

 This function is obsolete - the cells property is actually supposed to be read-only
 (http://www.w3.org/DOM/updates/REC-DOM-Level-1-19981001-errata.html)
     
*/
- setCells: (HTMLCollection*)arg1;

/** 
 Horizontal alignment of data within cells of this row. See the
 <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-align-TD">
 align attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) align;

/** 
 see @ref align
     
*/
- setAlign: (NSString *)arg1;

/** 
 Background color for rows. See the <a
 href="http://www.w3.org/TR/REC-html40/present/graphics.-[html adef]-bgcolor">
 bgcolor attribute definition </a> in HTML 4.0. This attribute
 is deprecated in HTML 4.0.

     
*/
- (NSString *) bgColor;

/** 
 see @ref bgColor
     
*/
- setBgColor: (NSString *)arg1;

/** 
 Alignment character for cells in a column. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-char">
 char attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) ch;

/** 
 see @ref ch
     
*/
- setCh: (NSString *)arg1;

/** 
 Offset of alignment character. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-charoff">
 charoff attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) chOff;

/** 
 see @ref chOff
     
*/
- setChOff: (NSString *)arg1;

/** 
 Vertical alignment of data within cells of this row. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-valign">
 valign attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) vAlign;

/** 
 see @ref vAlign
     
*/
- setVAlign: (NSString *)arg1;

/** 
 Insert an empty <code> TD </code> cell into this row.

     
*/
- (HTMLElement*) insertCell: (long)index;

/** 
 Delete a cell from the current row.

     
*/
- deleteCell: (long)index;
@end

#endif
