/***************************************************************************
                            KTextBrowser.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 An extended {@link QTextBrowser}.

 By default it will
 invoke the system mailer or the system browser when a link is
 activated, or it can emit the signal {@link #urlClick} or {@link #mailClick}
 when a link is activated.

 See {@link KTextBrowserSignals} for signals emitted by KTextBrowser.

 

 @author Espen Sand (espensa@online.no)

 @version $Id: KTextBrowser.java,v 1.7 2002/11/26 04:17:35 rdale Exp $
 
 @short Extended QTextBrowser.

*/
public class KTextBrowser extends QTextBrowser  {
	protected KTextBrowser(Class dummy){super((Class) null);}

	private native void newKTextBrowser( QWidget parent, String name, boolean notifyClick);

/** 
 Constructor.

*/
	public KTextBrowser( QWidget parent, String name, boolean notifyClick) {
		super((Class) null);
		newKTextBrowser( parent, name, notifyClick);
	}
	private native void newKTextBrowser();
	public KTextBrowser() {
		super((Class) null);
		newKTextBrowser();
	}

/** 
 Destructor.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Decide whether a click on a link should be handled internally
 or if a signal should be emitted.

*/
	public native void setNotifyClick( boolean notifyClick);

/** 
 Returns whether a click on a link should be handled internally
 or if a signal should be emitted.
     
*/
	public native boolean isNotifyClick();

/** 
       Reimplemented to NOT set the source but to do the special handling.
       Do not call.
     
*/
	public native void setSource( String name);

/** 
 Makes sure Key_Escape is ignored
     
*/
	protected native void keyPressEvent( QKeyEvent e);

/** 
 Make sure we use our own hand cursor
     
*/
	protected native void viewportMouseMoveEvent( QMouseEvent e);

/** 
 Reimplemented to support Qt2 behavior (Ctrl-Wheel = fast scroll)
     
*/
	protected native void contentsWheelEvent( QWheelEvent e);
	protected native void virtual_hook( int identifier, int data);
}
