/***************************************************************************
                            DCOPRef.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A DCOPRef(erence) encapsulates a remote DCOP object as a triple
 <app,obj,type> where type is optional. It allows for calling and
 passing DCOP objects.

 A DCOP reference makes it possible to return references to other DCOP
 objects in a DCOP interface, for example in the method
 giveMeAnotherObject() in an interface like this:

 <pre>
	class Example : public DCOPObject
	{
	   K_DCOP
	...
	k_dcop:
	   DCOPRef giveMeAnotherObject();
	   int doSomething( String, float, boolean );
	   ASYNC pingMe( QCString message );
	   UserType userFunction( UserType );
	};
 </pre>

 In addition, the reference can operate as a comfortable generic
 stub to call remote DCOP objects in cases where no DCOPStub is
 available. The advantage of using DCOPRef instead of the low-level
 functions DCOPClient.call() and DCOPClient.send() are the nicer
 syntax and the implicit runtime error checking.

 Say you want to call the method "doSomething" from the above
 interface on an object called "example" that lives in application
 "foo". Using DCOPRef, you would write

 <pre>
	DCOPRef example( "foo", "example" );
	int result = example.call( "doSomething", "Hello World", (float)2.5, true );
 </pre>

 If it is important for you to know whether the call succeeded or
 not, you can use the slightly more elaborate pattern:

 <pre>
	DCOPRef example( "foo", "example" );
	DCOPReply reply = example.call( "doSomething", "Hello World", (float)2.5, true );
	if ( reply.isValid() ) {
	    int result = reply;
	    // ...
	}
 </pre>

 For curiosity, here is how you would achieve the exactly same
 functionality by using DCOPClient.call() directly:

 <pre>
    byte[] data, replyData;
    QCString replyType;
    QDataStream arg( data, IO_WriteOnly );
    arg << String("hello world" ), (float) 2.5 << true;
    if ( DCOPClient.mainClient().call( app, obj,
			     "doSomething(String,float,bool)",
			     data, replyType, replyData ) ) {
	if ( replyType == "int" ) {
	    int result;
	    QDataStream reply( replyData, IO_ReadOnly );
	    reply >> result;
	    // ...
	}
    }
 </pre>

 As you might see from the code snippet, the DCOPRef has to "guess"
 the names of the datatypes of the arguments to construct a dcop
 call. This is done through global inline overloads of the
 dcopTypeName function, for example

 <pre>
	inline String dcopTypeName( String ) { return "String"; }
 </pre>

 If you use custom data types that do support QDataStream but have
 no corrsponding dcopTypeName overload, you can either provide such
 an overload or use a DCOPArg wrapper that allows you to specify the type.

 <pre>
	UserType userType;
	DCOPReply reply = example.call( "userFunction", DCOPArg( userType, "UserType" ) );
 </pre>

 Similar, when you retrieve such a data type, you can use an
 explicit call to DCOPReply.get():

 <pre>
	UserType userType;
	reply.get( userType, "UserType" );
 </pre>

 The function send() works very similar to call(), only that it
 returns a simple boolean on whether the signal could be sent or not:

 <pre>
	if ( example.pingMe( "message" ) == false )
	   qWarning("could not ping example" );
 </pre>

 A DCOP reference operates on DCOPClient.mainClient(), unless you
 explicitely specify another client with setDCOPClient().

 @author Matthias Ettrich <ettrich@kde.org>, Torben Weis <weis@kde.org>
 
 @short *
 A DCOPRef(erence) encapsulates a remote DCOP object as a triple
 <app,obj,type> where type is optional.
*/
public class  DCOPRef implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected DCOPRef(Class dummy){}

	private native void newDCOPRef();

/** 
 Creates a null reference.
     
*/
	public DCOPRef() {
		newDCOPRef();
	}
	private native void newDCOPRef( DCOPRef ref);

/** 
 Copy constructor.
     
*/
	public DCOPRef( DCOPRef ref) {
		newDCOPRef( ref);
	}
	private native void newDCOPRef( String app, String obj);

/** 
  Creates a reference for application <code>app</code> and object <code>obj</code>

*/
	public DCOPRef( String app, String obj) {
		newDCOPRef( app, obj);
	}
	private native void newDCOPRef( String app);
	public DCOPRef( String app) {
		newDCOPRef( app);
	}
	private native void newDCOPRef( DCOPObjectInterface object);

/** 
 Creates a reference to an existing dcop object

*/
	public DCOPRef( DCOPObjectInterface object) {
		newDCOPRef( object);
	}
	private native void newDCOPRef( String app, String obj, String type);

/** 
  Creates a reference for application <code>app</code> and object <code>obj</code>
 with a specified type <code>type.</code>

*/
	public DCOPRef( String app, String obj, String type) {
		newDCOPRef( app, obj, type);
	}

/** 
 Tests wether it is a null reference.

*/
	public native boolean isNull();

/** 
 Name of the application in which the object resides.

*/
	public native String app();

/** 
 Object ID of the referenced object.

*/
	public native String obj();

/** 
 @obsolete
     
*/
	public native String object();

/** 
 Type of the referenced object. May be null (i.e. unknown).

*/
	public native String type();

/** 
 Changes the referenced object. Resets the type to unknown (null).

*/
	public native void setRef( String app, String obj);
	public native void setRef( String app);

/** 
 Changes the referenced object.

*/
	public native void setRef( String app, String obj, String type);

/** 
 Makes this a null reference.
     
*/
	public native void clear();

/** 
 Returns the dcop client the reference operates on. If no client
 has been set, this is the DCOPClient.mainClient().

*/
	public native DCOPClient dcopClient();

/** 
 Sets a specific dcop client for this reference. Otherwise
 DCOPClient.mainClient() is used.

*/
	public native void setDCOPClient( DCOPClient client);

/** 
 Calls the function <code>fun</code> on the object referenced by this reference. 

*/
//	public native DCOPReply call( String fun);

/** 
 Calls the function <code>fun</code> on the object referenced by this reference. 

*/
//	public native template <class T1> DCOPReply call( String fun, T1* t1);

/** 
 Calls the function <code>fun</code> on the object referenced by this reference. 

*/
//	public native template <class T1,class T2> DCOPReply call( String fun, T1* t1, T2* t2);

/** 
 Calls the function <code>fun</code> on the object referenced by this reference. 

*/
//	public native template <class T1,class T2, class T3> DCOPReply call( String fun, T1* t1, T2* t2, T3* t3);

/** 
 Calls the function <code>fun</code> on the object referenced by this reference. 

*/
//	public native template <class T1,class T2,class T3,class T4> DCOPReply call( String fun, T1* t1, T2* t2, T3* t3, T4* t4);

/** 
 Calls the function <code>fun</code> on the object referenced by this reference. 

*/
//	public native template <class T1,class T2,class T3,class T4,class T5> DCOPReply call( String fun, T1* t1, T2* t2, T3* t3, T4* t4, T5* t5);

/** 
 Calls the function <code>fun</code> on the object referenced by this reference. 

*/
//	public native template <class T1,class T2,class T3,class T4,class T5,class T6> DCOPReply call( String fun, T1* t1, T2* t2, T3* t3, T4* t4, T5* t5, T6* t6);

/** 
 Calls the function <code>fun</code> on the object referenced by this reference. 

*/
//	public native template <class T1,class T2,class T3,class T4,class T5,class T6,class T7> DCOPReply call( String fun, T1* t1, T2* t2, T3* t3, T4* t4, T5* t5, T6* t6, T7* t7);

/** 
 Calls the function <code>fun</code> on the object referenced by this reference. 

*/
//	public native template <class T1,class T2,class T3,class T4,class T5,class T6,class T7,class T8> DCOPReply call( String fun, T1* t1, T2* t2, T3* t3, T4* t4, T5* t5, T6* t6, T7* t7, T8* t8);

/** 
 Calls the function <code>fun</code> on the object referenced by this reference. 
 Unlike {@link #call} this method does not expect a return value.

*/
	public native boolean send( String fun);

/** 
 Calls the function <code>fun</code> on the object referenced by this reference. 
 Unlike {@link #call} this method does not expect a return value.

*/
//	public native template <class T1> bool send( String fun, T1* t1);

/** 
 Calls the function <code>fun</code> on the object referenced by this reference. 
 Unlike {@link #call} this method does not expect a return value.

*/
//	public native template <class T1,class T2> bool send( String fun, T1* t1, T2* t2);

/** 
 Calls the function <code>fun</code> on the object referenced by this reference. 
 Unlike {@link #call} this method does not expect a return value.

*/
//	public native template <class T1,class T2, class T3> bool send( String fun, T1* t1, T2* t2, T3* t3);

/** 
 Calls the function <code>fun</code> on the object referenced by this reference. 
 Unlike {@link #call} this method does not expect a return value.

*/
//	public native template <class T1,class T2,class T3,class T4> bool send( String fun, T1* t1, T2* t2, T3* t3, T4* t4);

/** 
 Calls the function <code>fun</code> on the object referenced by this reference. 
 Unlike {@link #call} this method does not expect a return value.

*/
//	public native template <class T1,class T2,class T3,class T4,class T5> bool send( String fun, T1* t1, T2* t2, T3* t3, T4* t4, T5* t5);

/** 
 Calls the function <code>fun</code> on the object referenced by this reference. 
 Unlike {@link #call} this method does not expect a return value.

*/
//	public native template <class T1,class T2,class T3,class T4,class T5,class T6> bool send( String fun, T1* t1, T2* t2, T3* t3, T4* t4, T5* t5, T6* t6);

/** 
 Calls the function <code>fun</code> on the object referenced by this reference. 
 Unlike {@link #call} this method does not expect a return value.

*/
//	public native template <class T1,class T2,class T3,class T4,class T5,class T6,class T7> bool send( String fun, T1* t1, T2* t2, T3* t3, T4* t4, T5* t5, T6* t6, T7* t7);

/** 
 Calls the function <code>fun</code> on the object referenced by this reference. 
 Unlike {@link #call} this method does not expect a return value.

*/
//	public native template <class T1,class T2,class T3,class T4,class T5,class T6,class T7,class T8> bool send( String fun, T1* t1, T2* t2, T3* t3, T4* t4, T5* t5, T6* t6, T7* t7, T8* t8);
}
