/***************************************************************************
                            kde_KSharedPixmap.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSHAREDPIXMAP
#define KDE_KSHAREDPIXMAP

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Shared pixmap client.

 A shared pixmap is a pixmap that resides on the X server, is referenced
 by a global id string, and can be accessed by all X clients.

 This class is a client class to shared pixmaps in KDE. You can use it
 to copy (a part of) a shared pixmap into. KSharedPixmap inherits KPixmap
 for that purpose.

 The server part of shared pixmaps is not implemented here. 
 That part is provided by KPixmapServer, in the source file:
 kdebase/kdesktop/pixmapserver.cc.

 An example: copy from a shared pixmap:
 <pre>
   KSharedPixmap *pm = new KSharedPixmap;
   connect(pm, SIGNAL(done(bool)), SLOT(slotDone(bool)));
   pm->loadFromShared("My Pixmap");
 </pre>

 
 @author Geert Jansen <jansen@kde.org>

 @version $Id: kde_KSharedPixmap.h,v 1.4 2002/11/25 12:24:35 rdale Exp $

 @short *
 Shared pixmap client.
*/

/** *
 Construct an empty pixmap.
     
*/
kde_KSharedPixmap * kde_new_KSharedPixmap();

/** *
 Destroys the pixmap.
     
*/
void kde_del_KSharedPixmap( kde_KSharedPixmap* p );

/** *
 Load from a shared pixmap reference. The signal done() is emitted
 when the operation has finished.

*/
int kde_KSharedPixmap_loadFromShared(kde_KSharedPixmap* instPointer,qt_QString * name, qt_QRect* rect);

/** *
 Check whether a shared pixmap is available.

*/
int kde_KSharedPixmap_isAvailable(kde_KSharedPixmap* instPointer,qt_QString * name);

/** Casts a 'kde_KSharedPixmap *' to a 'kde_KPixmap*' */
kde_KPixmap* kde_KSharedPixmap_KPixmap(kde_KSharedPixmap* instPointer);

/** Casts a 'kde_KSharedPixmap *' to a 'qt_QWidget *' */
qt_QWidget * kde_KSharedPixmap_QWidget(kde_KSharedPixmap* instPointer);

#endif
