/* This file is part of the KDE project
   Copyright (C) 2001 Holger Freyther <freyther@yahoo.com>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; version 2
   of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include <kiconloader.h>
#include <kapplication.h>
#include <klocale.h>
#include <kconfig.h>
#include <kfiledialog.h>
#include <konq_popupmenu.h>

#include <qpixmap.h>
#include <qdir.h>
#include <qiconset.h>
#include <qstringlist.h>

#include "kmetamenu.h"
#include "kdirmenu.h"
#include "kmetamenu.moc"

KMetaMenu::KMetaMenu( QWidget *parent, const KURL &url,
        const QString &text, const QString &key)
: QPopupMenu( parent),
  m_root( 0 ), m_home( 0 ), m_etc( 0 ), m_current( 0 ), m_browse( 0 ) {
     int recent_no;
     group = key;
     actions.setAutoDelete( TRUE );

     QStringList dirList;

     m_home = new KDirMenu( parent, url.path(), QDir::homeDirPath() , text );
     insertItem( SmallIcon( "kfm_home" ), i18n("&Home Directory"), m_home);
     dirList << QDir::homeDirPath();

     m_root = new KDirMenu( parent, url.path(), QDir::rootDirPath() , text );
     insertItem( SmallIcon( "folder_red" ), i18n("&Root Directory"), m_root);
     dirList << QDir::rootDirPath();

     QString confDir = QDir::rootDirPath()+ "etc";
     if ( QFileInfo( confDir ).isWritable() )
     {
         m_etc  = new KDirMenu( parent, url.path(), confDir, text );
         insertItem( SmallIcon( "folder_yellow" ) ,
                 i18n("&System Configuration"), m_etc);
         dirList << confDir;

         connect(m_etc , SIGNAL(fileChosen(const QString &)),
                 SLOT(slotFileChosen(const QString &) ) );
     }

     if ( url.isLocalFile()
             && dirList.find( url.path() ) == dirList.end()
             && QFileInfo( url.path() ).isWritable() )
     {
         // Also add current working directory
         m_current = new KDirMenu( parent, url.path(), url.path(), text );
         insertItem( SmallIcon( "folder_blue" ), i18n( "&Current Directory" ),
                 m_current );

	 connect(m_current, SIGNAL(fileChosen(const QString &)),
                 SLOT(slotFileChosen(const QString &) ) );
     }

     connect(m_root, SIGNAL(fileChosen(const QString &)),
             SLOT(slotFileChosen(const QString &) ) );
     connect(m_home, SIGNAL(fileChosen(const QString &)),
             SLOT(slotFileChosen(const QString &) ) );

     m_browse = new KAction(i18n("&Browse..."), 0, this, SLOT(slotBrowse()), this );
     m_browse->plug(this);
     // read the last chosen dirs
     // first set the group according to our parameter
     conf = kapp->config( );
     conf->setGroup(key );
     recent_no = conf->readNumEntry("ShowRecent", 5);
     list = conf->readListEntry("Paths");
     if ( list.count() > 0 )
         insertSeparator();
     int i=1;
     for( QStringList::Iterator it =list.begin(); it != list.end(); ++it) {
         if( i == (recent_no + 1) )
	     break;
         KAction *action = new KAction(*it, 0, this, SLOT(slotFastPath() ), this );
         action->plug(this );
         actions.append( action );
         i++;
     }
}
KMetaMenu::KMetaMenu( ){

}
KMetaMenu::~KMetaMenu(){
     delete m_root;
     delete m_home;
     delete m_etc;
     delete m_current;
     delete m_browse;
     actions.clear();
}
void KMetaMenu::slotFileChosen(const QString &path ){
     writeConfig(path );
     emit fileChosen(path );
}
void KMetaMenu::slotFastPath( ) {
     KAction *action;
     action = (KAction*) sender();
     QString text = action->plainText( );
     slotFileChosen( text );
}
void KMetaMenu::writeConfig( const QString &path){
     list.remove(path );
     list.prepend(path );
     conf->setGroup( group );
     conf->writeEntry("Paths",list );
     conf->sync( );
}
void KMetaMenu::slotBrowse() {
     QString dest = KFileDialog::getExistingDirectory();
     if( dest.isEmpty() ) return;
     slotFileChosen( dest );
}
