/***************************************************************************
                          pybrowse_part.h  -  description
                             -------------------
    begin                : Tue Aug 28 2001
    copyright            : (C) 2001 by Christian Bird
    email                : chrisb@lineo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef _PYBROWSE_PART_H_
#define _PYBROWSE_PART_H_

#include <kate/application.h>
#include <kate/document.h>
#include <kate/mainwindow.h>
#include <kate/plugin.h>
#include <kate/view.h>
#include <kate/viewmanager.h>
#include <kate/toolviewmanager.h>
#include <kate/documentmanager.h>

#include <kdockwidget.h>
#include <klibloader.h>
#include <klocale.h>
#include <qstring.h>
#include "kpybrowser.h"

class KatePluginFactory : public KLibFactory
{
  Q_OBJECT

  public:
    KatePluginFactory();
    virtual ~KatePluginFactory();

    virtual QObject* createObject( QObject* parent = 0,
                                const char* pname = 0, const char* name = "QObject",
                                const QStringList &args = QStringList() );

  private:
    static KInstance* s_instance;
};

class KatePluginPyBrowse : public Kate::Plugin, Kate::PluginViewInterface
{
  Q_OBJECT

  public:
    KatePluginPyBrowse( QObject* parent = 0, const char* name = 0 );
    virtual ~KatePluginPyBrowse();
    KPyBrowser *kpybrowser;
    
    void addView(Kate::MainWindow *win);
    void removeView(Kate::MainWindow *win);
    QPtrList<class PluginView> m_views;
    Kate::MainWindow *main_win;
  
  private:
    KDockWidget *my_dock;

  public slots:
    void slotShowPyBrowser();
    void slotSelected(QString name, int line);
    void slotUpdatePyBrowser();
    
};
#endif
