# OBS! M4 processed!
`
CHAIN=growisofs dvd+rw-format dvd+rw-booktype dvd+rw-mediainfo

dvd+rw-tools:	$(CHAIN)

WARN=#-Wall	# developers are welcomed to build with `make WARN=-Wall'
'
ifelse(OS,NetBSD,`define(`OS',`BSD')')
ifelse(OS,OpenBSD,`define(`OS',`BSD')')
ifelse(OS,FreeBSD,`define(`OS',`BSD')LDLIBS=-lcam')
ifelse(OS,BSD,`
#
# OpenBSD/NetBSD/FreeBSD section
#
CC	?=gcc
CFLAGS	+=$(WARN) -O2
CXX	?=g++
CXXFLAGS+=$(WARN) -O2 -fno-exceptions

.SUFFIXES: .c .cpp .o

.c.o:
	$(CC) $(CFLAGS) -c -o $@ $<
.cpp.o:
	$(CXX) $(CXXFLAGS) -c -o $@ $<
.o:	# try to please both BSD vv&vv GNU make at the same time...
	$(CXX) $(CXXFLAGS) -o $@ $> $^ $(LDFLAGS) $(LDLIBS)

# yes, default is set-root-uid, `make BIN_MODE=0755 install' to override...
BIN_MODE?=04755
install:	dvd+rw-tools
	install -o root -m $(BIN_MODE) $(CHAIN) /usr/local/bin
	install -o root -m 0644 growisofs.1 /usr/local/man/man1
')
ifelse(OS,SunOS,`
#
# Solaris section
#
.SUFFIXES: .c .cpp .o

# check for WorkShop C++
syscmd(`(CC -flags) > /dev/null 2>&1')
ifelse(sysval,0,`
CC	=cc
CFLAGS	=-O -xstrconst -w
CXX	=CC
CXXFLAGS=-O -features=no%except,conststrings -w
',`
CC	=gcc
CFLAGS	=$(WARN) -02
GXX	=g++
CXXFLAGS=$(WARN) -O2 -fno-exceptions
')

LDLIBS=-lvolmgt

.c.o:
	$(CC) $(CFLAGS) -c -o $@ $<
.cpp.o:
	$(CXX) $(CXXFLAGS) -c -o $@ $<
%:	%.o
	$(CXX) $(CXXFLAGS) -o $@ $^ $(LDFLAGS) $(LDLIBS)

install:	dvd+rw-tools
	install -o root -m 04755 $(CHAIN) /usr/local/bin
	install -o root -m 0644 growisofs.1 /usr/local/man/man1
')
changequote([, ])
ifelse(OS,Linux,[
#
# Linux section
#
CC	=gcc
CFLAGS	+=$(WARN) -O2
CXX	=g++
CXXFLAGS+=$(WARN) -O2 -fno-exceptions

LINK.o=$(LINK.cc)

prefix?=/usr/local
bin_mode?=0755	# yes, default is *no* set-uid
minus_o:=$(shell [[ `id -u` == 0 ]] && echo "-o root")
install:	dvd+rw-tools
	[[ -d $(prefix)/bin ]] || mkdir -p $(prefix)/bin
	install $(minus_o) -m $(bin_mode) $(CHAIN) $(prefix)/bin
	[[ -d $(prefix)/man/man1 ]] || mkdir -p $(prefix)/man/man1
	install $(minus_o) -m 0644 growisofs.1 $(prefix)/man/man1
])
# common section
[
growisofs:		growisofs_mmc.o growisofs.o
growisofs.o:		growisofs.c
growisofs_mmc.o:	growisofs_mmc.cpp transport.hxx

dvd+rw-format:		dvd+rw-format.o
dvd+rw-format.o:	dvd+rw-format.cpp transport.hxx

dvd+rw-mediainfo:	dvd+rw-mediainfo.o
dvd+rw-mediainfo.o:	dvd+rw-mediainfo.cpp transport.hxx

dvd+rw-booktype:	dvd+rw-booktype.o
dvd+rw-booktype.o:	dvd+rw-booktype.cpp transport.hxx

rpl8:			rpl8.o
rpl8.o:			rpl8.cpp transport.hxx
+rpl8:			rpl8
#so that I can invoke `make +rpl8' to build rpl8...
]
