#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <glib.h>

#include <pan/base/article.h>
#include <pan/base/base-prefs.h>

#include <pan/filters/filter.h>
#include <pan/filters/filter-aggregate.h>
#include <pan/filters/filter-binary.h>
#include <pan/filters/filter-cached.h>
#include <pan/filters/filter-crosspost.h>
#include <pan/filters/filter-mine.h>
#include <pan/filters/filter-date.h>
#include <pan/filters/filter-linecount.h>
#include <pan/filters/filter-new.h>
#include <pan/filters/filter-phrase.h>
#include <pan/filters/filter-saved.h>
#include <pan/filters/filter-score.h>
#include <pan/filters/filter-thread.h>

static void
init_pan (void)
{
	base_prefs_init (g_get_tmp_dir(), ">", 100, FALSE, FALSE);
}

extern int server_saving_enabled;

static int
test_phrases (void)
{
	Article * article;
	GPtrArray * articles;
	Server * server;
	Group * group;
	static gulong number = 0;
	gint test = 0;
	Filter * f = filter_phrase_new ();

	server = server_new ();
	server->name = "dummy_server";
	group = group_new (server, "dummy_group");
	group_set_is_folder (group, TRUE);
	articles = g_ptr_array_new ();

	article = article_new (group);
	article->number = ++number;
	article_init_header (article, HEADER_MESSAGE_ID, "<asdf@foobar.com>", 0);

#define test(header_key,header_val,expected_result) \
	article_init_header (article, header_key, header_val, 0); \
	if (!!filter_test_article (f, article) != !!expected_result) return 1; \
	g_message ("PASS: filter-phrase %d", ++test);

	filter_phrase_set (FILTER_PHRASE(f), PHRASE_MATCH_CONTAINS, PHRASE_KEY_SUBJECT, "fillyjonk");
	test (HEADER_SUBJECT, "Can we find fillyjonk when it's by itself?", TRUE)
	test (HEADER_SUBJECT, "Can we findfillyjonkwhen it's inside a string?", TRUE)
	test (HEADER_SUBJECT, "WTF is a fillyjonk?", TRUE)
	test (HEADER_SUBJECT, "WTF is a fillyjon?", FALSE)

	filter_phrase_set (FILTER_PHRASE(f), PHRASE_MATCH_STARTS_WITH, PHRASE_KEY_SUBJECT, "fillyjonk");
	test (HEADER_SUBJECT, "fillyjonk at the front", TRUE)
	test (HEADER_SUBJECT, "Fillyjonk at the front, in Caps", TRUE)
	test (HEADER_SUBJECT, "at the end comes the fillyjonk", FALSE)
	test (HEADER_SUBJECT, "the fillyjonk comes before the mymble", FALSE)

	filter_phrase_set (FILTER_PHRASE(f), PHRASE_MATCH_ENDS_WITH, PHRASE_KEY_SUBJECT, "fillyjonk");
	test (HEADER_SUBJECT, "fillyjonk at the front", FALSE)
	test (HEADER_SUBJECT, "at the end comes the fillyjonk", TRUE)
	test (HEADER_SUBJECT, "at the end, in caps, comes the Fillyjonk", TRUE)
	test (HEADER_SUBJECT, "the fillyjonk comes before the mymble", FALSE)

	filter_phrase_set (FILTER_PHRASE(f), PHRASE_MATCH_IS, PHRASE_KEY_SUBJECT, "fillyjonk");
	test (HEADER_SUBJECT, "fillyjonk at the front", FALSE)
	test (HEADER_SUBJECT, "at the end comes the fillyjonk", FALSE)
	test (HEADER_SUBJECT, "at the end, in caps, comes the Fillyjonk", FALSE)
	test (HEADER_SUBJECT, "the fillyjonk comes before the mymble", FALSE)
	test (HEADER_SUBJECT, " fillyjonk ", FALSE)
	test (HEADER_SUBJECT, "fillyjonk ", FALSE)
	test (HEADER_SUBJECT, "fillyjonk", TRUE)
	test (HEADER_SUBJECT, "illyjonk", FALSE)
	test (HEADER_SUBJECT, "fillyjonk ", FALSE)

	return 0;
}

int
main (void)
{
	gint val;
	g_thread_init (NULL);
	init_pan ();
	server_saving_enabled = FALSE;

	val = test_phrases ();
	if (val)
		return val;

	g_message ("All filter tests passed");
	return 0;
}
