/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Pan - A Newsreader for Gtk+
 * Copyright (C) 2002  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __NNTP_H__
#define __NNTP_H__

#include <glib.h>

#include <pan/base/article.h>
#include <pan/base/group.h>
#include <pan/base/server.h>
#include <pan/base/message-identifier.h>
#include <pan/base/status-item.h>

#include <pan/sockets.h>

enum
{
	NNTP_VERBOSE_TEXT		= 1<<0,
	NNTP_VERBOSE_INIT_STEPS		= 1<<1,
	NNTP_VERBOSE_NEXT_STEP		= 1<<2,
	NNTP_VERBOSE			= ~0
};

int    nntp_command              (StatusItem           * status,
                                  PanSocket            * sock,
                                  const char          ** setme_result,
                                  const char           * command);
 
int    nntp_command_va           (StatusItem           * status,
                                  PanSocket            * sock,
                                  const char          ** setme_result,
                                  const char           * command_va,
                                  ...);

int    nntp_handshake            (StatusItem           * status,
                                  PanSocket            * socket,
                                  gboolean             * setme_posting_ok);

int    nntp_authenticate         (StatusItem           * status,
                                  PanSocket            * socket);

int    nntp_authenticate_types   (StatusItem           * status,
                                  PanSocket            * socket,
                                  gboolean              check_auth_types);

void   nntp_disconnect           (StatusItem           * status,
                                  PanSocket            * socket);

int    nntp_noop                 (StatusItem           * status,
                                  PanSocket            * socket);

int    nntp_set_group            (StatusItem           * status,
                                  PanSocket            * socket,
                                  const char           * groupname);

int    nntp_can_post             (StatusItem           * status,
                                  PanSocket            * sock,
                                  gboolean             * setme_can_post);

int    nntp_post                 (StatusItem           * status,
                                  PanSocket            * socket,
                                  const char           * message);

int    nntp_get_group_info       (StatusItem           * status,
                                  PanSocket            * sock,
                                  const char           * group_name,
                                  gulong               * setme_article_qty,
                                  gulong               * setme_low_num,
                                  gulong               * setme_high_num,
                                  const gboolean       * abort);

int    nntp_article_download     (StatusItem           * status,
                                  PanSocket            * sock,
                                  MessageIdentifier    * mid,
                                  const gboolean       * abort_download,
                                  int                    nntp_verbosity);

/**
 * This will try to get headers for articles [low-high] from the specified
 * server/group and store them as Article objects in the setme array.
 *
 * If verbose is true and the operation is successful,  the StatusItem will
 * emit low-high status_item_next_step signals.
 */
int nntp_download_headers (StatusItem       * item,
                           PanSocket        * sock,
                           Group            * group,
                           gulong             low,
                           gulong             high,
                           const gboolean   * abort,
                           const char       * progress_fmt,
                           GPtrArray        * setme);

/**
 * emits articles->len status_item_next_step signals.
 */
int  nntp_download_bodies (StatusItem          * item,
                           PanSocket           * sock,
                           const gboolean      * abort,
                           MessageIdentifier  ** identifiers,
                           int                   identifier_qty,
                           int                 * index,
                           gboolean              abort_if_one_fails);

int nntp_cancel (StatusItem            * item,
                 const char            * message_id,
                 PanSocket             * sock);

#endif /* __NNTP_H__ */
