/***************************************************************************
                            KActionMenu.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KACTIONMENU_H
#define KACTIONMENU_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KAction.h>

/**

 A KActionMenu is an action that holds a sub-menu of other actions.
 -insert and -remove allow to insert and remove actions into this action-menu.
 Plugged in a popupmenu, it will create a submenu.
 Plugged in a toolbar, it will create a button with a popup menu.

 This is the action used by the XMLGUI since it holds other actions.
 If you want a submenu for selecting one tool among many (without icons), see KSelectAction.
 See also setDelayed about the main action.
 
 @short 
 A KActionMenu is an action that holds a sub-menu of other actions.
*/
@class KPopupMenu; 
@class QIconSet; 

@interface KActionMenu : KAction 
- initWithText: (NSString *)text parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text ;
- initWithText: (NSString *)text iconset: (QIconSet*)icon parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text iconset: (QIconSet*)icon ;
- initWithText: (NSString *)text icon: (NSString *)icon parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text icon: (NSString *)icon ;
- initWithObject: (QObject *)parent name: (NSString *)name;
- init;
- (void) dealloc;
- insert: (KAction*)arg1 index: (int)index;
- insert: (KAction*)arg1 ;
- remove: (KAction*)arg1;
- (KPopupMenu*) popupMenu;
- popup: (QPoint*)global;

/** 
       Returns true if this action creates a delayed popup menu
       when plugged in a KToolbar.
     
*/
- (BOOL) delayed;

/** 
       If set to true, this action will create a delayed popup menu
       when plugged in a KToolbar. Otherwise it creates a normal popup.
       Default: delayed

       Remember that if the "main" action (the toolbar button itself)
       cannot be clicked, then you should call setDelayed(false).

       On the opposite, if the main action can be clicked, it can only happen
       in a toolbar: in a menu, the parent of a submenu can't be activated.
       To get a "normal" menu item when plugged a menu (and no submenu)
       use KToolBarPopupAction.
    
*/
- setDelayed: (BOOL)_delayed;

/** 
 Returns true if this action creates a sticky popup menu.
 See @ref setStickyMenu.
     
*/
- (BOOL) stickyMenu;

/** 
 If set to true, this action will create a sticky popup menu
 when plugged in a KToolbar.
 "Sticky", means it's visible until a selection is made or the mouse is
 clicked elsewhere. This feature allows you to make a selection without
 having to press and hold down the mouse while making a selection.
 Default: sticky.
     
*/
- setStickyMenu: (BOOL)sticky;
- (int) plug: (QWidget *)widget index: (int)index;
- (int) plug: (QWidget *)widget ;
- unplug: (QWidget *)widget;
- setEnabled: (BOOL)b;
- setText: (int)identifier text: (NSString *)text;
- setIconSet: (int)identifier iconSet: (QIconSet*)iconSet;
- setIconSet: (QIconSet*)i;
- setText: (NSString *)s;
@end

/** Override these methods in subclasses of KActionMenu to customise event handling behaviour */
@protocol KActionMenuEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
